/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.error;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@Validated
public class OBError1 {
    @JsonProperty(value="ErrorCode")
    private String errorCode = null;
    @JsonProperty(value="Message")
    private String message = null;
    @JsonProperty(value="Path")
    private String path = null;
    @JsonProperty(value="Url")
    private String url = null;

    public OBError1 errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(required=true, value="Low level textual error code, e.g., UK.OBIE.Field.Missing")
    @NotNull
    @Size(min=1, max=128)
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public OBError1 message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="A description of the error that occurred. e.g., 'A mandatory field isn't supplied' or 'RequestedExecutionDateTime must be in future' OBIE doesn't standardise this field")
    @NotNull
    @Size(min=1, max=500)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public OBError1 path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(value="Recommended but optional reference to the JSON Path of the field with error, e.g., Data.Initiation.InstructedAmount.Currency")
    @Size(min=1, max=500)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public OBError1 url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="URL to help remediate the problem, or provide more information, or to API Reference, or help etc")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBError1 obError1 = (OBError1)o;
        return Objects.equals(this.errorCode, obError1.errorCode) && Objects.equals(this.message, obError1.message) && Objects.equals(this.path, obError1.path) && Objects.equals(this.url, obError1.url);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.message, this.path, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBError1 {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

