/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.error;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.error.OBError1;

@ApiModel(description="An array of detail error codes, and messages, and URLs to documentation to help remediation.")
@Validated
public class OBErrorResponse1 {
    @JsonProperty(value="Code")
    private String code = null;
    @JsonProperty(value="Id")
    private String id = null;
    @JsonProperty(value="Message")
    private String message = null;
    @JsonProperty(value="Errors")
    @Valid
    private List<OBError1> errors = new ArrayList<OBError1>();

    public OBErrorResponse1 code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(required=true, value="High level textual error code, to help categorize the errors.")
    @NotNull
    @Size(min=1, max=40)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public OBErrorResponse1 id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="A unique reference for the error instance, for audit purposes, in case of unknown/unclassified errors.")
    @Size(min=1, max=40)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OBErrorResponse1 message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="Brief Error message, e.g., 'There is something wrong with the request parameters provided'")
    @NotNull
    @Size(min=1, max=500)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public OBErrorResponse1 errors(List<OBError1> errors) {
        this.errors = errors;
        return this;
    }

    public OBErrorResponse1 addErrorsItem(OBError1 errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @Size(min=1)
    public List<OBError1> getErrors() {
        return this.errors;
    }

    public void setErrors(List<OBError1> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBErrorResponse1 obErrorResponse1 = (OBErrorResponse1)o;
        return Objects.equals(this.code, obErrorResponse1.code) && Objects.equals(this.id, obErrorResponse1.id) && Objects.equals(this.message, obErrorResponse1.message) && Objects.equals(this.errors, obErrorResponse1.errors);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.id, this.message, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBErrorResponse1 {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

