/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBExternalAuthorisation1Code;

@ApiModel(description="The authorisation type request from the TPP.")
@Validated
public class OBAuthorisation1 {
    @JsonProperty(value="AuthorisationType")
    private OBExternalAuthorisation1Code authorisationType = null;
    @JsonProperty(value="CompletionDateTime")
    private DateTime completionDateTime = null;

    public OBAuthorisation1 authorisationType(OBExternalAuthorisation1Code authorisationType) {
        this.authorisationType = authorisationType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExternalAuthorisation1Code getAuthorisationType() {
        return this.authorisationType;
    }

    public void setAuthorisationType(OBExternalAuthorisation1Code authorisationType) {
        this.authorisationType = authorisationType;
    }

    public OBAuthorisation1 completionDateTime(DateTime completionDateTime) {
        this.completionDateTime = completionDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time at which the requested authorisation flow must be completed. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getCompletionDateTime() {
        return this.completionDateTime;
    }

    public void setCompletionDateTime(DateTime completionDateTime) {
        this.completionDateTime = completionDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBAuthorisation1 obAuthorisation1 = (OBAuthorisation1)o;
        return Objects.equals((Object)this.authorisationType, (Object)obAuthorisation1.authorisationType) && Objects.equals(this.completionDateTime, obAuthorisation1.completionDateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorisationType, this.completionDateTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBAuthorisation1 {\n");
        sb.append("    authorisationType: ").append(this.toIndentedString((Object)this.authorisationType)).append("\n");
        sb.append("    completionDateTime: ").append(this.toIndentedString(this.completionDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

