/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBCashAccount3;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.datamodel.payment.OBPostalAddress6;
import uk.org.openbanking.datamodel.payment.OBRemittanceInformation1;
import uk.org.openbanking.datamodel.payment.OBSupplementaryData1;

@ApiModel(description="The Initiation payload is sent by the initiating party to the ASPSP. It is used to request movement of funds from the debtor account to a creditor for a single domestic payment.")
@Validated
public class OBDomestic2 {
    @JsonProperty(value="InstructionIdentification")
    private String instructionIdentification = null;
    @JsonProperty(value="EndToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="LocalInstrument")
    private String localInstrument = null;
    @JsonProperty(value="InstructedAmount")
    private OBActiveOrHistoricCurrencyAndAmount instructedAmount = null;
    @JsonProperty(value="DebtorAccount")
    private OBCashAccount3 debtorAccount = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount3 creditorAccount = null;
    @JsonProperty(value="CreditorPostalAddress")
    private OBPostalAddress6 creditorPostalAddress = null;
    @JsonProperty(value="RemittanceInformation")
    private OBRemittanceInformation1 remittanceInformation = null;
    @JsonProperty(value="SupplementaryData")
    private OBSupplementaryData1 supplementaryData = null;

    public OBDomestic2 instructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identification as assigned by an instructing party for an instructed party to unambiguously identify the instruction. Usage: the  instruction identification is a point to point reference that can be used between the instructing party and the instructed party to refer to the individual instruction. It can be included in several messages related to the instruction.")
    @NotNull
    @Size(min=1, max=35)
    public String getInstructionIdentification() {
        return this.instructionIdentification;
    }

    public void setInstructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
    }

    public OBDomestic2 endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identification assigned by the initiating party to unambiguously identify the transaction. This identification is passed on, unchanged, throughout the entire end-to-end chain. Usage: The end-to-end identification can be used for reconciliation or to link tasks relating to the transaction. It can be included in several messages related to the transaction. OB: The Faster Payments Scheme can only access 31 characters for the EndToEndIdentification field.")
    @NotNull
    @Size(min=1, max=35)
    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public OBDomestic2 localInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    public String getLocalInstrument() {
        return this.localInstrument;
    }

    public void setLocalInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
    }

    public OBDomestic2 instructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public OBDomestic2 debtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount3 getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBDomestic2 creditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBCashAccount3 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public OBDomestic2 creditorPostalAddress(OBPostalAddress6 creditorPostalAddress) {
        this.creditorPostalAddress = creditorPostalAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBPostalAddress6 getCreditorPostalAddress() {
        return this.creditorPostalAddress;
    }

    public void setCreditorPostalAddress(OBPostalAddress6 creditorPostalAddress) {
        this.creditorPostalAddress = creditorPostalAddress;
    }

    public OBDomestic2 remittanceInformation(OBRemittanceInformation1 remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBRemittanceInformation1 getRemittanceInformation() {
        return this.remittanceInformation;
    }

    public void setRemittanceInformation(OBRemittanceInformation1 remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
    }

    public OBDomestic2 supplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBSupplementaryData1 getSupplementaryData() {
        return this.supplementaryData;
    }

    public void setSupplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBDomestic2 obDomestic2 = (OBDomestic2)o;
        return Objects.equals(this.instructionIdentification, obDomestic2.instructionIdentification) && Objects.equals(this.endToEndIdentification, obDomestic2.endToEndIdentification) && Objects.equals(this.localInstrument, obDomestic2.localInstrument) && Objects.equals(this.instructedAmount, obDomestic2.instructedAmount) && Objects.equals(this.debtorAccount, obDomestic2.debtorAccount) && Objects.equals(this.creditorAccount, obDomestic2.creditorAccount) && Objects.equals(this.creditorPostalAddress, obDomestic2.creditorPostalAddress) && Objects.equals(this.remittanceInformation, obDomestic2.remittanceInformation) && Objects.equals(this.supplementaryData, obDomestic2.supplementaryData);
    }

    public int hashCode() {
        return Objects.hash(this.instructionIdentification, this.endToEndIdentification, this.localInstrument, this.instructedAmount, this.debtorAccount, this.creditorAccount, this.creditorPostalAddress, this.remittanceInformation, this.supplementaryData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBDomestic2 {\n");
        sb.append("    instructionIdentification: ").append(this.toIndentedString(this.instructionIdentification)).append("\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    localInstrument: ").append(this.toIndentedString(this.localInstrument)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorPostalAddress: ").append(this.toIndentedString(this.creditorPostalAddress)).append("\n");
        sb.append("    remittanceInformation: ").append(this.toIndentedString(this.remittanceInformation)).append("\n");
        sb.append("    supplementaryData: ").append(this.toIndentedString(this.supplementaryData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

