/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.payment.OBCashAccountCreditor3;
import uk.org.openbanking.datamodel.payment.OBCashAccountDebtor4;
import uk.org.openbanking.datamodel.payment.OBDomesticStandingOrder3FinalPaymentAmount;
import uk.org.openbanking.datamodel.payment.OBDomesticStandingOrder3FirstPaymentAmount;
import uk.org.openbanking.datamodel.payment.OBDomesticStandingOrder3RecurringPaymentAmount;
import uk.org.openbanking.datamodel.payment.OBSupplementaryData1;

@ApiModel(description="The Initiation payload is sent by the initiating party to the ASPSP. It is used to request movement of funds from the debtor account to a creditor for a domestic standing order.")
public class OBDomesticStandingOrder3 {
    @JsonProperty(value="Frequency")
    private String frequency = null;
    @JsonProperty(value="Reference")
    private String reference = null;
    @JsonProperty(value="NumberOfPayments")
    private String numberOfPayments = null;
    @JsonProperty(value="FirstPaymentDateTime")
    private DateTime firstPaymentDateTime = null;
    @JsonProperty(value="RecurringPaymentDateTime")
    private DateTime recurringPaymentDateTime = null;
    @JsonProperty(value="FinalPaymentDateTime")
    private DateTime finalPaymentDateTime = null;
    @JsonProperty(value="FirstPaymentAmount")
    private OBDomesticStandingOrder3FirstPaymentAmount firstPaymentAmount = null;
    @JsonProperty(value="RecurringPaymentAmount")
    private OBDomesticStandingOrder3RecurringPaymentAmount recurringPaymentAmount = null;
    @JsonProperty(value="FinalPaymentAmount")
    private OBDomesticStandingOrder3FinalPaymentAmount finalPaymentAmount = null;
    @JsonProperty(value="DebtorAccount")
    private OBCashAccountDebtor4 debtorAccount = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccountCreditor3 creditorAccount = null;
    @JsonProperty(value="SupplementaryData")
    private OBSupplementaryData1 supplementaryData = null;

    public OBDomesticStandingOrder3 frequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(EvryDay)$|^(EvryWorkgDay)$|^IntrvlDay:(0?[2-9]|[1-2][0-9]|3[0-1])$|^(IntrvlWkDay:0[1-9]:0[1-7])$|^(WkInMnthDay:0[1-5]:0[1-7])$|^(IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]))$|^(QtrDay:(ENGLISH|SCOTTISH|RECEIVED))$")
    @Size(min=1, max=35)
    @ApiModelProperty(required=true, value="Individual Definitions: EvryDay - Every day EvryWorkgDay - Every working day IntrvlDay - An interval specified in number of calendar days (02 to 31) IntrvlWkDay - An interval specified in weeks (01 to 09), and the day within the week (01 to 07) WkInMnthDay - A monthly interval, specifying the week of the month (01 to 05) and day within the week (01 to 07) IntrvlMnthDay - An interval specified in months (between 01 to 06, 12, 24), specifying the day within the month (-05 to -01, 1 to 31) QtrDay - Quarterly (either ENGLISH, SCOTTISH, or RECEIVED). ENGLISH = Paid on the 25th March, 24th June, 29th September and 25th December. SCOTTISH = Paid on the 2nd February, 15th May, 1st August and 11th November. RECEIVED = Paid on the 20th March, 19th June, 24th September and 20th December. Individual Patterns: EvryDay (ScheduleCode) EvryWorkgDay (ScheduleCode) IntrvlDay:NoOfDay (ScheduleCode + NoOfDay) IntrvlWkDay:IntervalInWeeks:DayInWeek (ScheduleCode + IntervalInWeeks + DayInWeek) WkInMnthDay:WeekInMonth:DayInWeek (ScheduleCode + WeekInMonth + DayInWeek) IntrvlMnthDay:IntervalInMonths:DayInMonth (ScheduleCode + IntervalInMonths + DayInMonth) QtrDay: + either (ENGLISH, SCOTTISH or RECEIVED) ScheduleCode + QuarterDay The regular expression for this element combines five smaller versions for each permitted pattern. To aid legibility - the components are presented individually here: EvryDay EvryWorkgDay IntrvlDay:((0[2-9])|([1-2][0-9])|3[0-1]) IntrvlWkDay:0[1-9]:0[1-7] WkInMnthDay:0[1-5]:0[1-7] IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]) QtrDay:(ENGLISH|SCOTTISH|RECEIVED) Full Regular Expression: ^(EvryDay)$|^(EvryWorkgDay)$|^IntrvlDay:(0?[2-9]|[1-2][0-9]|3[0-1])$|^(IntrvlWkDay:0[1-9]:0[1-7])$|^(WkInMnthDay:0[1-5]:0[1-7])$|^(IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]))$|^(QtrDay:(ENGLISH|SCOTTISH|RECEIVED))$")
    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public OBDomesticStandingOrder3 reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique reference, as assigned by the creditor, to unambiguously refer to the payment transaction. Usage: If available, the initiating party should provide this reference in the structured remittance information, to enable reconciliation by the creditor upon receipt of the amount of money. If the business context requires the use of a creditor reference or a payment remit identification, and only one identifier can be passed through the end-to-end chain, the creditor's reference or payment remittance identification should be quoted in the end-to-end transaction identification.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public OBDomesticStandingOrder3 numberOfPayments(String numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Number of the payments that will be made in completing this frequency sequence including any executed since the sequence start date.")
    public String getNumberOfPayments() {
        return this.numberOfPayments;
    }

    public void setNumberOfPayments(String numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
    }

    public OBDomesticStandingOrder3 firstPaymentDateTime(DateTime firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The date on which the first payment for a Standing Order schedule will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getFirstPaymentDateTime() {
        return this.firstPaymentDateTime;
    }

    public void setFirstPaymentDateTime(DateTime firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
    }

    public OBDomesticStandingOrder3 recurringPaymentDateTime(DateTime recurringPaymentDateTime) {
        this.recurringPaymentDateTime = recurringPaymentDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The date on which the first recurring payment for a Standing Order schedule will be made.  Usage: This must be populated only if the first recurring date is different to the first payment date. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getRecurringPaymentDateTime() {
        return this.recurringPaymentDateTime;
    }

    public void setRecurringPaymentDateTime(DateTime recurringPaymentDateTime) {
        this.recurringPaymentDateTime = recurringPaymentDateTime;
    }

    public OBDomesticStandingOrder3 finalPaymentDateTime(DateTime finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The date on which the final payment for a Standing Order schedule will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getFinalPaymentDateTime() {
        return this.finalPaymentDateTime;
    }

    public void setFinalPaymentDateTime(DateTime finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
    }

    public OBDomesticStandingOrder3 firstPaymentAmount(OBDomesticStandingOrder3FirstPaymentAmount firstPaymentAmount) {
        this.firstPaymentAmount = firstPaymentAmount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBDomesticStandingOrder3FirstPaymentAmount getFirstPaymentAmount() {
        return this.firstPaymentAmount;
    }

    public void setFirstPaymentAmount(OBDomesticStandingOrder3FirstPaymentAmount firstPaymentAmount) {
        this.firstPaymentAmount = firstPaymentAmount;
    }

    public OBDomesticStandingOrder3 recurringPaymentAmount(OBDomesticStandingOrder3RecurringPaymentAmount recurringPaymentAmount) {
        this.recurringPaymentAmount = recurringPaymentAmount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBDomesticStandingOrder3RecurringPaymentAmount getRecurringPaymentAmount() {
        return this.recurringPaymentAmount;
    }

    public void setRecurringPaymentAmount(OBDomesticStandingOrder3RecurringPaymentAmount recurringPaymentAmount) {
        this.recurringPaymentAmount = recurringPaymentAmount;
    }

    public OBDomesticStandingOrder3 finalPaymentAmount(OBDomesticStandingOrder3FinalPaymentAmount finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBDomesticStandingOrder3FinalPaymentAmount getFinalPaymentAmount() {
        return this.finalPaymentAmount;
    }

    public void setFinalPaymentAmount(OBDomesticStandingOrder3FinalPaymentAmount finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
    }

    public OBDomesticStandingOrder3 debtorAccount(OBCashAccountDebtor4 debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBCashAccountDebtor4 getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBCashAccountDebtor4 debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBDomesticStandingOrder3 creditorAccount(OBCashAccountCreditor3 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBCashAccountCreditor3 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccountCreditor3 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public OBDomesticStandingOrder3 supplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBSupplementaryData1 getSupplementaryData() {
        return this.supplementaryData;
    }

    public void setSupplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBDomesticStandingOrder3 obDomesticStandingOrder3 = (OBDomesticStandingOrder3)o;
        return Objects.equals(this.frequency, obDomesticStandingOrder3.frequency) && Objects.equals(this.reference, obDomesticStandingOrder3.reference) && Objects.equals(this.numberOfPayments, obDomesticStandingOrder3.numberOfPayments) && Objects.equals(this.firstPaymentDateTime, obDomesticStandingOrder3.firstPaymentDateTime) && Objects.equals(this.recurringPaymentDateTime, obDomesticStandingOrder3.recurringPaymentDateTime) && Objects.equals(this.finalPaymentDateTime, obDomesticStandingOrder3.finalPaymentDateTime) && Objects.equals(this.firstPaymentAmount, obDomesticStandingOrder3.firstPaymentAmount) && Objects.equals(this.recurringPaymentAmount, obDomesticStandingOrder3.recurringPaymentAmount) && Objects.equals(this.finalPaymentAmount, obDomesticStandingOrder3.finalPaymentAmount) && Objects.equals(this.debtorAccount, obDomesticStandingOrder3.debtorAccount) && Objects.equals(this.creditorAccount, obDomesticStandingOrder3.creditorAccount) && Objects.equals(this.supplementaryData, obDomesticStandingOrder3.supplementaryData);
    }

    public int hashCode() {
        return Objects.hash(this.frequency, this.reference, this.numberOfPayments, this.firstPaymentDateTime, this.recurringPaymentDateTime, this.finalPaymentDateTime, this.firstPaymentAmount, this.recurringPaymentAmount, this.finalPaymentAmount, this.debtorAccount, this.creditorAccount, this.supplementaryData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBDomesticStandingOrder3 {\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    numberOfPayments: ").append(this.toIndentedString(this.numberOfPayments)).append("\n");
        sb.append("    firstPaymentDateTime: ").append(this.toIndentedString(this.firstPaymentDateTime)).append("\n");
        sb.append("    recurringPaymentDateTime: ").append(this.toIndentedString(this.recurringPaymentDateTime)).append("\n");
        sb.append("    finalPaymentDateTime: ").append(this.toIndentedString(this.finalPaymentDateTime)).append("\n");
        sb.append("    firstPaymentAmount: ").append(this.toIndentedString(this.firstPaymentAmount)).append("\n");
        sb.append("    recurringPaymentAmount: ").append(this.toIndentedString(this.recurringPaymentAmount)).append("\n");
        sb.append("    finalPaymentAmount: ").append(this.toIndentedString(this.finalPaymentAmount)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    supplementaryData: ").append(this.toIndentedString(this.supplementaryData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

