/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBExchangeRateType2Code;

@ApiModel(description="Provides details on the currency exchange rate and contract.")
@Validated
public class OBExchangeRate1 {
    @JsonProperty(value="UnitCurrency")
    private String unitCurrency = null;
    @JsonProperty(value="ExchangeRate")
    private BigDecimal exchangeRate = null;
    @JsonProperty(value="RateType")
    private OBExchangeRateType2Code rateType = null;
    @JsonProperty(value="ContractIdentification")
    private String contractIdentification = null;

    public OBExchangeRate1 unitCurrency(String unitCurrency) {
        this.unitCurrency = unitCurrency;
        return this;
    }

    @ApiModelProperty(required=true, value="Currency in which the rate of exchange is expressed in a currency exchange. In the example 1GBP = xxxCUR, the unit currency is GBP.")
    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    public String getUnitCurrency() {
        return this.unitCurrency;
    }

    public void setUnitCurrency(String unitCurrency) {
        this.unitCurrency = unitCurrency;
    }

    public OBExchangeRate1 exchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
        return this;
    }

    @ApiModelProperty(value="The factor used for conversion of an amount from one currency to another. This reflects the price at which one currency was bought with another currency.")
    @Valid
    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public OBExchangeRate1 rateType(OBExchangeRateType2Code rateType) {
        this.rateType = rateType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExchangeRateType2Code getRateType() {
        return this.rateType;
    }

    public void setRateType(OBExchangeRateType2Code rateType) {
        this.rateType = rateType;
    }

    public OBExchangeRate1 contractIdentification(String contractIdentification) {
        this.contractIdentification = contractIdentification;
        return this;
    }

    @ApiModelProperty(value="Unique and unambiguous reference to the foreign exchange contract agreed between the initiating party/creditor and the debtor agent.")
    @Size(min=1, max=256)
    public String getContractIdentification() {
        return this.contractIdentification;
    }

    public void setContractIdentification(String contractIdentification) {
        this.contractIdentification = contractIdentification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBExchangeRate1 obExchangeRate1 = (OBExchangeRate1)o;
        return Objects.equals(this.unitCurrency, obExchangeRate1.unitCurrency) && Objects.equals(this.exchangeRate, obExchangeRate1.exchangeRate) && Objects.equals((Object)this.rateType, (Object)obExchangeRate1.rateType) && Objects.equals(this.contractIdentification, obExchangeRate1.contractIdentification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unitCurrency, this.exchangeRate, this.rateType, this.contractIdentification});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBExchangeRate1 {\n");
        sb.append("    unitCurrency: ").append(this.toIndentedString(this.unitCurrency)).append("\n");
        sb.append("    exchangeRate: ").append(this.toIndentedString(this.exchangeRate)).append("\n");
        sb.append("    rateType: ").append(this.toIndentedString((Object)this.rateType)).append("\n");
        sb.append("    contractIdentification: ").append(this.toIndentedString(this.contractIdentification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

