/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBCashAccount3;
import uk.org.openbanking.datamodel.payment.OBRemittanceInformation1;

@ApiModel(description="The Initiation payload is sent by the initiating party to the ASPSP. It is used to request movement of funds using a payment file.")
@Validated
public class OBFile1 {
    @JsonProperty(value="FileType")
    private String fileType = null;
    @JsonProperty(value="FileHash")
    private String fileHash = null;
    @JsonProperty(value="FileReference")
    private String fileReference = null;
    @JsonProperty(value="NumberOfTransactions")
    private String numberOfTransactions = null;
    @JsonProperty(value="ControlSum")
    private BigDecimal controlSum = null;
    @JsonProperty(value="RequestedExecutionDateTime")
    private DateTime requestedExecutionDateTime = null;
    @JsonProperty(value="LocalInstrument")
    private String localInstrument = null;
    @JsonProperty(value="DebtorAccount")
    private OBCashAccount3 debtorAccount = null;
    @JsonProperty(value="RemittanceInformation")
    private OBRemittanceInformation1 remittanceInformation = null;

    public OBFile1 fileType(String fileType) {
        this.fileType = fileType;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the payment file type.")
    @NotNull
    @Size(min=1, max=40)
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public OBFile1 fileHash(String fileHash) {
        this.fileHash = fileHash;
        return this;
    }

    @ApiModelProperty(required=true, value="A base64 encoding of a SHA256 hash of the file to be uploaded.")
    @NotNull
    @Size(min=1, max=44)
    public String getFileHash() {
        return this.fileHash;
    }

    public void setFileHash(String fileHash) {
        this.fileHash = fileHash;
    }

    public OBFile1 fileReference(String fileReference) {
        this.fileReference = fileReference;
        return this;
    }

    @ApiModelProperty(value="Reference for the file.")
    @Size(min=1, max=40)
    public String getFileReference() {
        return this.fileReference;
    }

    public void setFileReference(String fileReference) {
        this.fileReference = fileReference;
    }

    public OBFile1 numberOfTransactions(String numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    @ApiModelProperty(value="Number of individual transactions contained in the payment information group.")
    @Pattern(regexp="[0-9]{1,15}")
    @Size(min=1, max=15)
    public String getNumberOfTransactions() {
        return this.numberOfTransactions;
    }

    public void setNumberOfTransactions(String numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
    }

    public OBFile1 controlSum(BigDecimal controlSum) {
        this.controlSum = controlSum;
        return this;
    }

    @ApiModelProperty(value="Total of all individual amounts included in the group, irrespective of currencies.")
    @Valid
    public BigDecimal getControlSum() {
        return this.controlSum;
    }

    public void setControlSum(BigDecimal controlSum) {
        this.controlSum = controlSum;
    }

    public OBFile1 requestedExecutionDateTime(DateTime requestedExecutionDateTime) {
        this.requestedExecutionDateTime = requestedExecutionDateTime;
        return this;
    }

    @ApiModelProperty(value="Date at which the initiating party requests the clearing agent to process the payment.  Usage: This is the date on which the debtor's account is to be debited. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getRequestedExecutionDateTime() {
        return this.requestedExecutionDateTime;
    }

    public void setRequestedExecutionDateTime(DateTime requestedExecutionDateTime) {
        this.requestedExecutionDateTime = requestedExecutionDateTime;
    }

    public OBFile1 localInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
        return this;
    }

    @ApiModelProperty(value="User community specific instrument. Usage: This element is used to specify a local instrument, local clearing option and/or further qualify the service or service level.")
    @Size(min=1, max=35)
    public String getLocalInstrument() {
        return this.localInstrument;
    }

    public void setLocalInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
    }

    public OBFile1 debtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount3 getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBFile1 remittanceInformation(OBRemittanceInformation1 remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBRemittanceInformation1 getRemittanceInformation() {
        return this.remittanceInformation;
    }

    public void setRemittanceInformation(OBRemittanceInformation1 remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBFile1 obFile1 = (OBFile1)o;
        return Objects.equals(this.fileType, obFile1.fileType) && Objects.equals(this.fileHash, obFile1.fileHash) && Objects.equals(this.fileReference, obFile1.fileReference) && Objects.equals(this.numberOfTransactions, obFile1.numberOfTransactions) && Objects.equals(this.controlSum, obFile1.controlSum) && Objects.equals(this.requestedExecutionDateTime, obFile1.requestedExecutionDateTime) && Objects.equals(this.localInstrument, obFile1.localInstrument) && Objects.equals(this.debtorAccount, obFile1.debtorAccount) && Objects.equals(this.remittanceInformation, obFile1.remittanceInformation);
    }

    public int hashCode() {
        return Objects.hash(this.fileType, this.fileHash, this.fileReference, this.numberOfTransactions, this.controlSum, this.requestedExecutionDateTime, this.localInstrument, this.debtorAccount, this.remittanceInformation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBFile1 {\n");
        sb.append("    fileType: ").append(this.toIndentedString(this.fileType)).append("\n");
        sb.append("    fileHash: ").append(this.toIndentedString(this.fileHash)).append("\n");
        sb.append("    fileReference: ").append(this.toIndentedString(this.fileReference)).append("\n");
        sb.append("    numberOfTransactions: ").append(this.toIndentedString(this.numberOfTransactions)).append("\n");
        sb.append("    controlSum: ").append(this.toIndentedString(this.controlSum)).append("\n");
        sb.append("    requestedExecutionDateTime: ").append(this.toIndentedString(this.requestedExecutionDateTime)).append("\n");
        sb.append("    localInstrument: ").append(this.toIndentedString(this.localInstrument)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    remittanceInformation: ").append(this.toIndentedString(this.remittanceInformation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

