/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBCashAccount3;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.datamodel.payment.OBBranchAndFinancialInstitutionIdentification3;
import uk.org.openbanking.datamodel.payment.OBChargeBearerType1Code;
import uk.org.openbanking.datamodel.payment.OBExchangeRate1;
import uk.org.openbanking.datamodel.payment.OBPartyIdentification43;
import uk.org.openbanking.datamodel.payment.OBPriority2Code;
import uk.org.openbanking.datamodel.payment.OBRemittanceInformation1;
import uk.org.openbanking.datamodel.payment.OBSupplementaryData1;

@ApiModel(description="The Initiation payload is sent by the initiating party to the ASPSP. It is used to request movement of funds from the debtor account to a creditor for a single international payment.")
@Validated
public class OBInternational2 {
    @JsonProperty(value="InstructionIdentification")
    private String instructionIdentification = null;
    @JsonProperty(value="EndToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="LocalInstrument")
    private String localInstrument = null;
    @JsonProperty(value="InstructionPriority")
    private OBPriority2Code instructionPriority = null;
    @JsonProperty(value="Purpose")
    private String purpose = null;
    @JsonProperty(value="ChargeBearer")
    private OBChargeBearerType1Code chargeBearer = null;
    @JsonProperty(value="CurrencyOfTransfer")
    private String currencyOfTransfer = null;
    @JsonProperty(value="InstructedAmount")
    private OBActiveOrHistoricCurrencyAndAmount instructedAmount = null;
    @JsonProperty(value="ExchangeRateInformation")
    private OBExchangeRate1 exchangeRateInformation = null;
    @JsonProperty(value="DebtorAccount")
    private OBCashAccount3 debtorAccount = null;
    @JsonProperty(value="Creditor")
    private OBPartyIdentification43 creditor = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification3 creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount3 creditorAccount = null;
    @JsonProperty(value="RemittanceInformation")
    private OBRemittanceInformation1 remittanceInformation = null;
    @JsonProperty(value="SupplementaryData")
    private OBSupplementaryData1 supplementaryData = null;

    public OBInternational2 instructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identification as assigned by an instructing party for an instructed party to unambiguously identify the instruction. Usage: the  instruction identification is a point to point reference that can be used between the instructing party and the instructed party to refer to the individual instruction. It can be included in several messages related to the instruction.")
    @NotNull
    @Size(min=1, max=35)
    public String getInstructionIdentification() {
        return this.instructionIdentification;
    }

    public void setInstructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
    }

    public OBInternational2 endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identification assigned by the initiating party to unambiguously identify the transaction. This identification is passed on, unchanged, throughout the entire end-to-end chain. Usage: The end-to-end identification can be used for reconciliation or to link tasks relating to the transaction. It can be included in several messages related to the transaction. OB: The Faster Payments Scheme can only access 31 characters for the EndToEndIdentification field.")
    @NotNull
    @Size(min=1, max=35)
    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public OBInternational2 localInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    public String getLocalInstrument() {
        return this.localInstrument;
    }

    public void setLocalInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
    }

    public OBInternational2 instructionPriority(OBPriority2Code instructionPriority) {
        this.instructionPriority = instructionPriority;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBPriority2Code getInstructionPriority() {
        return this.instructionPriority;
    }

    public void setInstructionPriority(OBPriority2Code instructionPriority) {
        this.instructionPriority = instructionPriority;
    }

    @Size(min=1, max=4)
    public OBInternational2 purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(value="")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public OBInternational2 chargeBearer(OBChargeBearerType1Code chargeBearer) {
        this.chargeBearer = chargeBearer;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBChargeBearerType1Code getChargeBearer() {
        return this.chargeBearer;
    }

    public void setChargeBearer(OBChargeBearerType1Code chargeBearer) {
        this.chargeBearer = chargeBearer;
    }

    public OBInternational2 currencyOfTransfer(String currencyOfTransfer) {
        this.currencyOfTransfer = currencyOfTransfer;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the currency of the to be transferred amount, which is different from the currency of the debtor's account.")
    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    public String getCurrencyOfTransfer() {
        return this.currencyOfTransfer;
    }

    public void setCurrencyOfTransfer(String currencyOfTransfer) {
        this.currencyOfTransfer = currencyOfTransfer;
    }

    public OBInternational2 instructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public OBInternational2 exchangeRateInformation(OBExchangeRate1 exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBExchangeRate1 getExchangeRateInformation() {
        return this.exchangeRateInformation;
    }

    public void setExchangeRateInformation(OBExchangeRate1 exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
    }

    public OBInternational2 debtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount3 getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBInternational2 creditor(OBPartyIdentification43 creditor) {
        this.creditor = creditor;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBPartyIdentification43 getCreditor() {
        return this.creditor;
    }

    public void setCreditor(OBPartyIdentification43 creditor) {
        this.creditor = creditor;
    }

    public OBInternational2 creditorAgent(OBBranchAndFinancialInstitutionIdentification3 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification3 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification3 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBInternational2 creditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBCashAccount3 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public OBInternational2 remittanceInformation(OBRemittanceInformation1 remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBRemittanceInformation1 getRemittanceInformation() {
        return this.remittanceInformation;
    }

    public void setRemittanceInformation(OBRemittanceInformation1 remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
    }

    public OBInternational2 supplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBSupplementaryData1 getSupplementaryData() {
        return this.supplementaryData;
    }

    public void setSupplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBInternational2 obInternational2 = (OBInternational2)o;
        return Objects.equals(this.instructionIdentification, obInternational2.instructionIdentification) && Objects.equals(this.endToEndIdentification, obInternational2.endToEndIdentification) && Objects.equals(this.localInstrument, obInternational2.localInstrument) && Objects.equals((Object)this.instructionPriority, (Object)obInternational2.instructionPriority) && Objects.equals(this.purpose, obInternational2.purpose) && Objects.equals((Object)this.chargeBearer, (Object)obInternational2.chargeBearer) && Objects.equals(this.currencyOfTransfer, obInternational2.currencyOfTransfer) && Objects.equals(this.instructedAmount, obInternational2.instructedAmount) && Objects.equals(this.exchangeRateInformation, obInternational2.exchangeRateInformation) && Objects.equals(this.debtorAccount, obInternational2.debtorAccount) && Objects.equals(this.creditor, obInternational2.creditor) && Objects.equals(this.creditorAgent, obInternational2.creditorAgent) && Objects.equals(this.creditorAccount, obInternational2.creditorAccount) && Objects.equals(this.remittanceInformation, obInternational2.remittanceInformation) && Objects.equals(this.supplementaryData, obInternational2.supplementaryData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.instructionIdentification, this.endToEndIdentification, this.localInstrument, this.instructionPriority, this.purpose, this.chargeBearer, this.currencyOfTransfer, this.instructedAmount, this.exchangeRateInformation, this.debtorAccount, this.creditor, this.creditorAgent, this.creditorAccount, this.remittanceInformation, this.supplementaryData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBInternational2 {\n");
        sb.append("    instructionIdentification: ").append(this.toIndentedString(this.instructionIdentification)).append("\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    localInstrument: ").append(this.toIndentedString(this.localInstrument)).append("\n");
        sb.append("    instructionPriority: ").append(this.toIndentedString((Object)this.instructionPriority)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    chargeBearer: ").append(this.toIndentedString((Object)this.chargeBearer)).append("\n");
        sb.append("    currencyOfTransfer: ").append(this.toIndentedString(this.currencyOfTransfer)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    exchangeRateInformation: ").append(this.toIndentedString(this.exchangeRateInformation)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    creditor: ").append(this.toIndentedString(this.creditor)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    remittanceInformation: ").append(this.toIndentedString(this.remittanceInformation)).append("\n");
        sb.append("    supplementaryData: ").append(this.toIndentedString(this.supplementaryData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

