/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBCashAccount3;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.datamodel.payment.OBBranchAndFinancialInstitutionIdentification3;
import uk.org.openbanking.datamodel.payment.OBChargeBearerType1Code;
import uk.org.openbanking.datamodel.payment.OBPartyIdentification43;

@ApiModel(description="The Initiation payload is sent by the initiating party to the ASPSP. It is used to request movement of funds from the debtor account to a creditor for an international standing order.")
@Validated
public class OBInternationalStandingOrder1 {
    @JsonProperty(value="Frequency")
    private String frequency = null;
    @JsonProperty(value="Reference")
    private String reference = null;
    @JsonProperty(value="NumberOfPayments")
    private String numberOfPayments = null;
    @JsonProperty(value="FirstPaymentDateTime")
    private DateTime firstPaymentDateTime = null;
    @JsonProperty(value="FinalPaymentDateTime")
    private DateTime finalPaymentDateTime = null;
    @JsonProperty(value="Purpose")
    private String purpose = null;
    @JsonProperty(value="ChargeBearer")
    private OBChargeBearerType1Code chargeBearer = null;
    @JsonProperty(value="CurrencyOfTransfer")
    private String currencyOfTransfer = null;
    @JsonProperty(value="InstructedAmount")
    private OBActiveOrHistoricCurrencyAndAmount instructedAmount = null;
    @JsonProperty(value="DebtorAccount")
    private OBCashAccount3 debtorAccount = null;
    @JsonProperty(value="Creditor")
    private OBPartyIdentification43 creditor = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification3 creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount3 creditorAccount = null;

    public OBInternationalStandingOrder1 frequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(required=true, value="Individual Definitions: EvryDay - Every day EvryWorkgDay - Every working day IntrvlWkDay - An interval specified in weeks (01 to 09), and the day within the week (01 to 07) WkInMnthDay - A monthly interval, specifying the week of the month (01 to 05) and day within the week (01 to 07) IntrvlMnthDay - An interval specified in months (between 01 to 06, 12, 24), specifying the day within the month (-5 to -1, 1 to 31) QtrDay - Quarterly (either ENGLISH, SCOTTISH, or RECEIVED).  ENGLISH = Paid on the 25th March, 24th June, 29th September and 25th December.  SCOTTISH = Paid on the 2nd February, 15th May, 1st August and 11th November. RECEIVED = Paid on the 20th March, 19th June, 24th September and 20th December.  Individual Patterns: EvryDay (ScheduleCode) EvryWorkgDay (ScheduleCode) IntrvlWkDay:IntervalInWeeks:DayInWeek (ScheduleCode + IntervalInWeeks + DayInWeek) WkInMnthDay:WeekInMonth:DayInWeek (ScheduleCode + WeekInMonth + DayInWeek) IntrvlMnthDay:IntervalInMonths:DayInMonth (ScheduleCode + IntervalInMonths + DayInMonth) QtrDay: + either (ENGLISH, SCOTTISH or RECEIVED) ScheduleCode + QuarterDay The regular expression for this element combines five smaller versions for each permitted pattern. To aid legibility - the components are presented individually here: EvryDay EvryWorkgDay IntrvlWkDay:0[1-9]:0[1-7] WkInMnthDay:0[1-5]:0[1-7] IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]) QtrDay:(ENGLISH|SCOTTISH|RECEIVED) Full Regular Expression: ^(EvryDay)$|^(EvryWorkgDay)$|^(IntrvlWkDay:0[1-9]:0[1-7])$|^(WkInMnthDay:0[1-5]:0[1-7])$|^(IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]))$|^(QtrDay:(ENGLISH|SCOTTISH|RECEIVED))$")
    @NotNull
    @Pattern(regexp="^(EvryDay)$|^(EvryWorkgDay)$|^(IntrvlWkDay:0[1-9]:0[1-7])$|^(WkInMnthDay:0[1-5]:0[1-7])$|^(IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]))$|^(QtrDay:(ENGLISH|SCOTTISH|RECEIVED))$")
    @Size(min=1, max=35)
    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public OBInternationalStandingOrder1 reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Unique reference, as assigned by the creditor, to unambiguously refer to the payment transaction. Usage: If available, the initiating party should provide this reference in the structured remittance information, to enable reconciliation by the creditor upon receipt of the amount of money. If the business context requires the use of a creditor reference or a payment remit identification, and only one identifier can be passed through the end-to-end chain, the creditor's reference or payment remittance identification should be quoted in the end-to-end transaction identification.")
    @Size(min=1, max=35)
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public OBInternationalStandingOrder1 numberOfPayments(String numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
        return this;
    }

    @ApiModelProperty(value="Number of the payments that will be made in completing this frequency sequence including any executed since the sequence start date. ")
    @Size(min=1, max=35)
    public String getNumberOfPayments() {
        return this.numberOfPayments;
    }

    public void setNumberOfPayments(String numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
    }

    public OBInternationalStandingOrder1 firstPaymentDateTime(DateTime firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The date on which the first payment for a Standing Order schedule will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getFirstPaymentDateTime() {
        return this.firstPaymentDateTime;
    }

    public void setFirstPaymentDateTime(DateTime firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
    }

    public OBInternationalStandingOrder1 finalPaymentDateTime(DateTime finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
        return this;
    }

    @ApiModelProperty(value="The date on which the final payment for a Standing Order schedule will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getFinalPaymentDateTime() {
        return this.finalPaymentDateTime;
    }

    public void setFinalPaymentDateTime(DateTime finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
    }

    public OBInternationalStandingOrder1 purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(value="Specifies the external purpose code in the format of character string with a maximum length of 35 characters. The list of valid codes is an external code list published separately. External code sets can be downloaded from www.iso20022.org.")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public OBInternationalStandingOrder1 chargeBearer(OBChargeBearerType1Code chargeBearer) {
        this.chargeBearer = chargeBearer;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBChargeBearerType1Code getChargeBearer() {
        return this.chargeBearer;
    }

    public void setChargeBearer(OBChargeBearerType1Code chargeBearer) {
        this.chargeBearer = chargeBearer;
    }

    public OBInternationalStandingOrder1 currencyOfTransfer(String currencyOfTransfer) {
        this.currencyOfTransfer = currencyOfTransfer;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the currency of the to be transferred amount, which is different from the currency of the debtor's account.")
    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    public String getCurrencyOfTransfer() {
        return this.currencyOfTransfer;
    }

    public void setCurrencyOfTransfer(String currencyOfTransfer) {
        this.currencyOfTransfer = currencyOfTransfer;
    }

    public OBInternationalStandingOrder1 instructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public OBInternationalStandingOrder1 debtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount3 getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBInternationalStandingOrder1 creditor(OBPartyIdentification43 creditor) {
        this.creditor = creditor;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBPartyIdentification43 getCreditor() {
        return this.creditor;
    }

    public void setCreditor(OBPartyIdentification43 creditor) {
        this.creditor = creditor;
    }

    public OBInternationalStandingOrder1 creditorAgent(OBBranchAndFinancialInstitutionIdentification3 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification3 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification3 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBInternationalStandingOrder1 creditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBCashAccount3 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBInternationalStandingOrder1 obInternationalStandingOrder1 = (OBInternationalStandingOrder1)o;
        return Objects.equals(this.frequency, obInternationalStandingOrder1.frequency) && Objects.equals(this.reference, obInternationalStandingOrder1.reference) && Objects.equals(this.numberOfPayments, obInternationalStandingOrder1.numberOfPayments) && Objects.equals(this.firstPaymentDateTime, obInternationalStandingOrder1.firstPaymentDateTime) && Objects.equals(this.finalPaymentDateTime, obInternationalStandingOrder1.finalPaymentDateTime) && Objects.equals(this.purpose, obInternationalStandingOrder1.purpose) && Objects.equals((Object)this.chargeBearer, (Object)obInternationalStandingOrder1.chargeBearer) && Objects.equals(this.currencyOfTransfer, obInternationalStandingOrder1.currencyOfTransfer) && Objects.equals(this.instructedAmount, obInternationalStandingOrder1.instructedAmount) && Objects.equals(this.debtorAccount, obInternationalStandingOrder1.debtorAccount) && Objects.equals(this.creditor, obInternationalStandingOrder1.creditor) && Objects.equals(this.creditorAgent, obInternationalStandingOrder1.creditorAgent) && Objects.equals(this.creditorAccount, obInternationalStandingOrder1.creditorAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.frequency, this.reference, this.numberOfPayments, this.firstPaymentDateTime, this.finalPaymentDateTime, this.purpose, this.chargeBearer, this.currencyOfTransfer, this.instructedAmount, this.debtorAccount, this.creditor, this.creditorAgent, this.creditorAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBInternationalStandingOrder1 {\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    numberOfPayments: ").append(this.toIndentedString(this.numberOfPayments)).append("\n");
        sb.append("    firstPaymentDateTime: ").append(this.toIndentedString(this.firstPaymentDateTime)).append("\n");
        sb.append("    finalPaymentDateTime: ").append(this.toIndentedString(this.finalPaymentDateTime)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    chargeBearer: ").append(this.toIndentedString((Object)this.chargeBearer)).append("\n");
        sb.append("    currencyOfTransfer: ").append(this.toIndentedString(this.currencyOfTransfer)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    creditor: ").append(this.toIndentedString(this.creditor)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

