/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBExternalStatus2Code;

@ApiModel(description="The multiple authorisation flow response from the ASPSP.")
@Validated
public class OBMultiAuthorisation1 {
    @JsonProperty(value="Status")
    private OBExternalStatus2Code status = null;
    @JsonProperty(value="NumberRequired")
    private Integer numberRequired = null;
    @JsonProperty(value="NumberReceived")
    private Integer numberReceived = null;
    @JsonProperty(value="LastUpdateDateTime")
    private DateTime lastUpdateDateTime = null;
    @JsonProperty(value="ExpirationDateTime")
    private DateTime expirationDateTime = null;

    public OBMultiAuthorisation1 status(OBExternalStatus2Code status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExternalStatus2Code getStatus() {
        return this.status;
    }

    public void setStatus(OBExternalStatus2Code status) {
        this.status = status;
    }

    public OBMultiAuthorisation1 numberRequired(Integer numberRequired) {
        this.numberRequired = numberRequired;
        return this;
    }

    @ApiModelProperty(value="Number of authorisations required for payment order (total required at the start of the multi authorisation journey).")
    public Integer getNumberRequired() {
        return this.numberRequired;
    }

    public void setNumberRequired(Integer numberRequired) {
        this.numberRequired = numberRequired;
    }

    public OBMultiAuthorisation1 numberReceived(Integer numberReceived) {
        this.numberReceived = numberReceived;
        return this;
    }

    @ApiModelProperty(value="Number of authorisations required for payment order (total required at the start of the multi authorisation journey).")
    public Integer getNumberReceived() {
        return this.numberReceived;
    }

    public void setNumberReceived(Integer numberReceived) {
        this.numberReceived = numberReceived;
    }

    public OBMultiAuthorisation1 lastUpdateDateTime(DateTime lastUpdateDateTime) {
        this.lastUpdateDateTime = lastUpdateDateTime;
        return this;
    }

    @ApiModelProperty(value="Last date and time at the authorisation flow was updated. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getLastUpdateDateTime() {
        return this.lastUpdateDateTime;
    }

    public void setLastUpdateDateTime(DateTime lastUpdateDateTime) {
        this.lastUpdateDateTime = lastUpdateDateTime;
    }

    public OBMultiAuthorisation1 expirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time at which the requested authorisation flow must be completed. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public void setExpirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBMultiAuthorisation1 obMultiAuthorisation1 = (OBMultiAuthorisation1)o;
        return Objects.equals((Object)this.status, (Object)obMultiAuthorisation1.status) && Objects.equals(this.numberRequired, obMultiAuthorisation1.numberRequired) && Objects.equals(this.numberReceived, obMultiAuthorisation1.numberReceived) && Objects.equals(this.lastUpdateDateTime, obMultiAuthorisation1.lastUpdateDateTime) && Objects.equals(this.expirationDateTime, obMultiAuthorisation1.expirationDateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.numberRequired, this.numberReceived, this.lastUpdateDateTime, this.expirationDateTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBMultiAuthorisation1 {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    numberRequired: ").append(this.toIndentedString(this.numberRequired)).append("\n");
        sb.append("    numberReceived: ").append(this.toIndentedString(this.numberReceived)).append("\n");
        sb.append("    lastUpdateDateTime: ").append(this.toIndentedString(this.lastUpdateDateTime)).append("\n");
        sb.append("    expirationDateTime: ").append(this.toIndentedString(this.expirationDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

