/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBCharge1;
import uk.org.openbanking.datamodel.payment.OBExchangeRate2;
import uk.org.openbanking.datamodel.payment.OBInternational2;
import uk.org.openbanking.datamodel.payment.OBMultiAuthorisation1;
import uk.org.openbanking.datamodel.payment.OBTransactionIndividualStatus1Code;

@Validated
public class OBWriteDataInternationalResponse2 {
    @JsonProperty(value="InternationalPaymentId")
    private String internationalPaymentId = null;
    @JsonProperty(value="ConsentId")
    private String consentId = null;
    @JsonProperty(value="CreationDateTime")
    private DateTime creationDateTime = null;
    @JsonProperty(value="Status")
    private OBTransactionIndividualStatus1Code status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private DateTime statusUpdateDateTime = null;
    @JsonProperty(value="ExpectedExecutionDateTime")
    private DateTime expectedExecutionDateTime = null;
    @JsonProperty(value="ExpectedSettlementDateTime")
    private DateTime expectedSettlementDateTime = null;
    @JsonProperty(value="Charges")
    @Valid
    private List<OBCharge1> charges = null;
    @JsonProperty(value="ExchangeRateInformation")
    private OBExchangeRate2 exchangeRateInformation = null;
    @JsonProperty(value="Initiation")
    private OBInternational2 initiation = null;
    @JsonProperty(value="MultiAuthorisation")
    private OBMultiAuthorisation1 multiAuthorisation = null;

    public OBWriteDataInternationalResponse2 internationalPaymentId(String internationalPaymentId) {
        this.internationalPaymentId = internationalPaymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the international payment resource.")
    @NotNull
    @Size(min=1, max=40)
    public String getInternationalPaymentId() {
        return this.internationalPaymentId;
    }

    public void setInternationalPaymentId(String internationalPaymentId) {
        this.internationalPaymentId = internationalPaymentId;
    }

    public OBWriteDataInternationalResponse2 consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the consent resource.")
    @NotNull
    @Size(min=1, max=128)
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public OBWriteDataInternationalResponse2 creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the message was created. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBWriteDataInternationalResponse2 status(OBTransactionIndividualStatus1Code status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBTransactionIndividualStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBTransactionIndividualStatus1Code status) {
        this.status = status;
    }

    public OBWriteDataInternationalResponse2 statusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the resource status was updated. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBWriteDataInternationalResponse2 expectedExecutionDateTime(DateTime expectedExecutionDateTime) {
        this.expectedExecutionDateTime = expectedExecutionDateTime;
        return this;
    }

    @ApiModelProperty(value="Expected execution date and time for the payment resource. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getExpectedExecutionDateTime() {
        return this.expectedExecutionDateTime;
    }

    public void setExpectedExecutionDateTime(DateTime expectedExecutionDateTime) {
        this.expectedExecutionDateTime = expectedExecutionDateTime;
    }

    public OBWriteDataInternationalResponse2 expectedSettlementDateTime(DateTime expectedSettlementDateTime) {
        this.expectedSettlementDateTime = expectedSettlementDateTime;
        return this;
    }

    @ApiModelProperty(value="Expected settlement date and time for the payment resource. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getExpectedSettlementDateTime() {
        return this.expectedSettlementDateTime;
    }

    public void setExpectedSettlementDateTime(DateTime expectedSettlementDateTime) {
        this.expectedSettlementDateTime = expectedSettlementDateTime;
    }

    public OBWriteDataInternationalResponse2 charges(List<OBCharge1> charges) {
        this.charges = charges;
        return this;
    }

    public OBWriteDataInternationalResponse2 addChargesItem(OBCharge1 chargesItem) {
        if (this.charges == null) {
            this.charges = new ArrayList<OBCharge1>();
        }
        this.charges.add(chargesItem);
        return this;
    }

    @ApiModelProperty(value="Set of elements used to provide details of a charge for the payment initiation.")
    @Valid
    public List<OBCharge1> getCharges() {
        return this.charges;
    }

    public void setCharges(List<OBCharge1> charges) {
        this.charges = charges;
    }

    public OBWriteDataInternationalResponse2 exchangeRateInformation(OBExchangeRate2 exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBExchangeRate2 getExchangeRateInformation() {
        return this.exchangeRateInformation;
    }

    public void setExchangeRateInformation(OBExchangeRate2 exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
    }

    public OBWriteDataInternationalResponse2 initiation(OBInternational2 initiation) {
        this.initiation = initiation;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBInternational2 getInitiation() {
        return this.initiation;
    }

    public void setInitiation(OBInternational2 initiation) {
        this.initiation = initiation;
    }

    public OBWriteDataInternationalResponse2 multiAuthorisation(OBMultiAuthorisation1 multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBMultiAuthorisation1 getMultiAuthorisation() {
        return this.multiAuthorisation;
    }

    public void setMultiAuthorisation(OBMultiAuthorisation1 multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDataInternationalResponse2 obWriteDataInternationalResponse2 = (OBWriteDataInternationalResponse2)o;
        return Objects.equals(this.internationalPaymentId, obWriteDataInternationalResponse2.internationalPaymentId) && Objects.equals(this.consentId, obWriteDataInternationalResponse2.consentId) && Objects.equals(this.creationDateTime, obWriteDataInternationalResponse2.creationDateTime) && Objects.equals((Object)this.status, (Object)obWriteDataInternationalResponse2.status) && Objects.equals(this.statusUpdateDateTime, obWriteDataInternationalResponse2.statusUpdateDateTime) && Objects.equals(this.expectedExecutionDateTime, obWriteDataInternationalResponse2.expectedExecutionDateTime) && Objects.equals(this.expectedSettlementDateTime, obWriteDataInternationalResponse2.expectedSettlementDateTime) && Objects.equals(this.charges, obWriteDataInternationalResponse2.charges) && Objects.equals(this.exchangeRateInformation, obWriteDataInternationalResponse2.exchangeRateInformation) && Objects.equals(this.initiation, obWriteDataInternationalResponse2.initiation) && Objects.equals(this.multiAuthorisation, obWriteDataInternationalResponse2.multiAuthorisation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.internationalPaymentId, this.consentId, this.creationDateTime, this.status, this.statusUpdateDateTime, this.expectedExecutionDateTime, this.expectedSettlementDateTime, this.charges, this.exchangeRateInformation, this.initiation, this.multiAuthorisation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDataInternationalResponse2 {\n");
        sb.append("    internationalPaymentId: ").append(this.toIndentedString(this.internationalPaymentId)).append("\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    expectedExecutionDateTime: ").append(this.toIndentedString(this.expectedExecutionDateTime)).append("\n");
        sb.append("    expectedSettlementDateTime: ").append(this.toIndentedString(this.expectedSettlementDateTime)).append("\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    exchangeRateInformation: ").append(this.toIndentedString(this.exchangeRateInformation)).append("\n");
        sb.append("    initiation: ").append(this.toIndentedString(this.initiation)).append("\n");
        sb.append("    multiAuthorisation: ").append(this.toIndentedString(this.multiAuthorisation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

