/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.payment.OBCharge2;
import uk.org.openbanking.datamodel.payment.OBExternalStatus1Code;
import uk.org.openbanking.datamodel.payment.OBInternationalStandingOrder3;
import uk.org.openbanking.datamodel.payment.OBMultiAuthorisation1;

public class OBWriteDataInternationalStandingOrderResponse3 {
    @JsonProperty(value="InternationalStandingOrderId")
    private String internationalStandingOrderId = null;
    @JsonProperty(value="ConsentId")
    private String consentId = null;
    @JsonProperty(value="CreationDateTime")
    private DateTime creationDateTime = null;
    @JsonProperty(value="Status")
    private OBExternalStatus1Code status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private DateTime statusUpdateDateTime = null;
    @JsonProperty(value="Charges")
    private List<OBCharge2> charges = null;
    @JsonProperty(value="Initiation")
    private OBInternationalStandingOrder3 initiation = null;
    @JsonProperty(value="MultiAuthorisation")
    private OBMultiAuthorisation1 multiAuthorisation = null;

    public OBWriteDataInternationalStandingOrderResponse3 internationalStandingOrderId(String internationalStandingOrderId) {
        this.internationalStandingOrderId = internationalStandingOrderId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the international standing order resource.")
    public String getInternationalStandingOrderId() {
        return this.internationalStandingOrderId;
    }

    public void setInternationalStandingOrderId(String internationalStandingOrderId) {
        this.internationalStandingOrderId = internationalStandingOrderId;
    }

    public OBWriteDataInternationalStandingOrderResponse3 consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @NotNull
    @Size(min=1, max=128)
    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the consent resource.")
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public OBWriteDataInternationalStandingOrderResponse3 creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the resource was created. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBWriteDataInternationalStandingOrderResponse3 status(OBExternalStatus1Code status) {
        this.status = status;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBExternalStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBExternalStatus1Code status) {
        this.status = status;
    }

    public OBWriteDataInternationalStandingOrderResponse3 statusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the resource status was updated. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBWriteDataInternationalStandingOrderResponse3 charges(List<OBCharge2> charges) {
        this.charges = charges;
        return this;
    }

    public OBWriteDataInternationalStandingOrderResponse3 addChargesItem(OBCharge2 chargesItem) {
        if (this.charges == null) {
            this.charges = new ArrayList<OBCharge2>();
        }
        this.charges.add(chargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Set of elements used to provide details of a charge for the payment initiation.")
    public List<OBCharge2> getCharges() {
        return this.charges;
    }

    public void setCharges(List<OBCharge2> charges) {
        this.charges = charges;
    }

    public OBWriteDataInternationalStandingOrderResponse3 initiation(OBInternationalStandingOrder3 initiation) {
        this.initiation = initiation;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBInternationalStandingOrder3 getInitiation() {
        return this.initiation;
    }

    public void setInitiation(OBInternationalStandingOrder3 initiation) {
        this.initiation = initiation;
    }

    public OBWriteDataInternationalStandingOrderResponse3 multiAuthorisation(OBMultiAuthorisation1 multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBMultiAuthorisation1 getMultiAuthorisation() {
        return this.multiAuthorisation;
    }

    public void setMultiAuthorisation(OBMultiAuthorisation1 multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDataInternationalStandingOrderResponse3 obWriteDataInternationalStandingOrderResponse3 = (OBWriteDataInternationalStandingOrderResponse3)o;
        return Objects.equals(this.internationalStandingOrderId, obWriteDataInternationalStandingOrderResponse3.internationalStandingOrderId) && Objects.equals(this.consentId, obWriteDataInternationalStandingOrderResponse3.consentId) && Objects.equals(this.creationDateTime, obWriteDataInternationalStandingOrderResponse3.creationDateTime) && Objects.equals((Object)this.status, (Object)obWriteDataInternationalStandingOrderResponse3.status) && Objects.equals(this.statusUpdateDateTime, obWriteDataInternationalStandingOrderResponse3.statusUpdateDateTime) && Objects.equals(this.charges, obWriteDataInternationalStandingOrderResponse3.charges) && Objects.equals(this.initiation, obWriteDataInternationalStandingOrderResponse3.initiation) && Objects.equals(this.multiAuthorisation, obWriteDataInternationalStandingOrderResponse3.multiAuthorisation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.internationalStandingOrderId, this.consentId, this.creationDateTime, this.status, this.statusUpdateDateTime, this.charges, this.initiation, this.multiAuthorisation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDataInternationalStandingOrderResponse3 {\n");
        sb.append("    internationalStandingOrderId: ").append(this.toIndentedString(this.internationalStandingOrderId)).append("\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    initiation: ").append(this.toIndentedString(this.initiation)).append("\n");
        sb.append("    multiAuthorisation: ").append(this.toIndentedString(this.multiAuthorisation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

