/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.payment.OBPostalAddress6;
import uk.org.openbanking.datamodel.payment.OBSupplementaryData1;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationCreditorAccount;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationDebtorAccount;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationInstructedAmount;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationRemittanceInformation;

@ApiModel(description="The Initiation payload is sent by the initiating party to the ASPSP. It is used to request movement of funds from the debtor account to a creditor for a single domestic payment.")
public class OBWriteDomestic2DataInitiation {
    @JsonProperty(value="InstructionIdentification")
    private String instructionIdentification = null;
    @JsonProperty(value="EndToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="LocalInstrument")
    private String localInstrument = null;
    @JsonProperty(value="InstructedAmount")
    private OBWriteDomestic2DataInitiationInstructedAmount instructedAmount = null;
    @JsonProperty(value="DebtorAccount")
    private OBWriteDomestic2DataInitiationDebtorAccount debtorAccount = null;
    @JsonProperty(value="CreditorAccount")
    private OBWriteDomestic2DataInitiationCreditorAccount creditorAccount = null;
    @JsonProperty(value="CreditorPostalAddress")
    private OBPostalAddress6 creditorPostalAddress = null;
    @JsonProperty(value="RemittanceInformation")
    private OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation = null;
    @JsonProperty(value="SupplementaryData")
    private OBSupplementaryData1 supplementaryData = null;

    public OBWriteDomestic2DataInitiation instructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
        return this;
    }

    @NotNull
    @Size(min=1, max=35)
    @ApiModelProperty(required=true, value="Unique identification as assigned by an instructing party for an instructed party to unambiguously identify the instruction. Usage: the  instruction identification is a point to point reference that can be used between the instructing party and the instructed party to refer to the individual instruction. It can be included in several messages related to the instruction.")
    public String getInstructionIdentification() {
        return this.instructionIdentification;
    }

    public void setInstructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
    }

    public OBWriteDomestic2DataInitiation endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @NotNull
    @Size(min=1, max=35)
    @ApiModelProperty(required=true, value="Unique identification assigned by the initiating party to unambiguously identify the transaction. This identification is passed on, unchanged, throughout the entire end-to-end chain. Usage: The end-to-end identification can be used for reconciliation or to link tasks relating to the transaction. It can be included in several messages related to the transaction. OB: The Faster Payments Scheme can only access 31 characters for the EndToEndIdentification field.")
    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public OBWriteDomestic2DataInitiation localInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    public String getLocalInstrument() {
        return this.localInstrument;
    }

    public void setLocalInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
    }

    public OBWriteDomestic2DataInitiation instructedAmount(OBWriteDomestic2DataInitiationInstructedAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBWriteDomestic2DataInitiationInstructedAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBWriteDomestic2DataInitiationInstructedAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public OBWriteDomestic2DataInitiation debtorAccount(OBWriteDomestic2DataInitiationDebtorAccount debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomestic2DataInitiationDebtorAccount getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBWriteDomestic2DataInitiationDebtorAccount debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBWriteDomestic2DataInitiation creditorAccount(OBWriteDomestic2DataInitiationCreditorAccount creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBWriteDomestic2DataInitiationCreditorAccount getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBWriteDomestic2DataInitiationCreditorAccount creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public OBWriteDomestic2DataInitiation creditorPostalAddress(OBPostalAddress6 creditorPostalAddress) {
        this.creditorPostalAddress = creditorPostalAddress;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBPostalAddress6 getCreditorPostalAddress() {
        return this.creditorPostalAddress;
    }

    public void setCreditorPostalAddress(OBPostalAddress6 creditorPostalAddress) {
        this.creditorPostalAddress = creditorPostalAddress;
    }

    public OBWriteDomestic2DataInitiation remittanceInformation(OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomestic2DataInitiationRemittanceInformation getRemittanceInformation() {
        return this.remittanceInformation;
    }

    public void setRemittanceInformation(OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
    }

    public OBWriteDomestic2DataInitiation supplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBSupplementaryData1 getSupplementaryData() {
        return this.supplementaryData;
    }

    public void setSupplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDomestic2DataInitiation obWriteDomestic2DataInitiation = (OBWriteDomestic2DataInitiation)o;
        return Objects.equals(this.instructionIdentification, obWriteDomestic2DataInitiation.instructionIdentification) && Objects.equals(this.endToEndIdentification, obWriteDomestic2DataInitiation.endToEndIdentification) && Objects.equals(this.localInstrument, obWriteDomestic2DataInitiation.localInstrument) && Objects.equals(this.instructedAmount, obWriteDomestic2DataInitiation.instructedAmount) && Objects.equals(this.debtorAccount, obWriteDomestic2DataInitiation.debtorAccount) && Objects.equals(this.creditorAccount, obWriteDomestic2DataInitiation.creditorAccount) && Objects.equals(this.creditorPostalAddress, obWriteDomestic2DataInitiation.creditorPostalAddress) && Objects.equals(this.remittanceInformation, obWriteDomestic2DataInitiation.remittanceInformation) && Objects.equals(this.supplementaryData, obWriteDomestic2DataInitiation.supplementaryData);
    }

    public int hashCode() {
        return Objects.hash(this.instructionIdentification, this.endToEndIdentification, this.localInstrument, this.instructedAmount, this.debtorAccount, this.creditorAccount, this.creditorPostalAddress, this.remittanceInformation, this.supplementaryData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDomestic2DataInitiation {\n");
        sb.append("    instructionIdentification: ").append(this.toIndentedString(this.instructionIdentification)).append("\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    localInstrument: ").append(this.toIndentedString(this.localInstrument)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorPostalAddress: ").append(this.toIndentedString(this.creditorPostalAddress)).append("\n");
        sb.append("    remittanceInformation: ").append(this.toIndentedString(this.remittanceInformation)).append("\n");
        sb.append("    supplementaryData: ").append(this.toIndentedString(this.supplementaryData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

