/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Size;

@ApiModel(description="Information supplied to enable the matching of an entry with the items that the transfer is intended to settle, such as commercial invoices in an accounts' receivable system.")
public class OBWriteDomestic2DataInitiationRemittanceInformation {
    @JsonProperty(value="Unstructured")
    private String unstructured = null;
    @JsonProperty(value="Reference")
    private String reference = null;

    public OBWriteDomestic2DataInitiationRemittanceInformation unstructured(String unstructured) {
        this.unstructured = unstructured;
        return this;
    }

    @Size(min=1, max=140)
    @ApiModelProperty(value="Information supplied to enable the matching/reconciliation of an entry with the items that the payment is intended to settle, such as commercial invoices in an accounts' receivable system, in an unstructured form.")
    public String getUnstructured() {
        return this.unstructured;
    }

    public void setUnstructured(String unstructured) {
        this.unstructured = unstructured;
    }

    public OBWriteDomestic2DataInitiationRemittanceInformation reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique reference, as assigned by the creditor, to unambiguously refer to the payment transaction. Usage: If available, the initiating party should provide this reference in the structured remittance information, to enable reconciliation by the creditor upon receipt of the amount of money. If the business context requires the use of a creditor reference or a payment remit identification, and only one identifier can be passed through the end-to-end chain, the creditor's reference or payment remittance identification should be quoted in the end-to-end transaction identification. OB: The Faster Payments Scheme can only accept 18 characters for the ReferenceInformation field - which is where this ISO field will be mapped.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDomestic2DataInitiationRemittanceInformation obWriteDomestic2DataInitiationRemittanceInformation = (OBWriteDomestic2DataInitiationRemittanceInformation)o;
        return Objects.equals(this.unstructured, obWriteDomestic2DataInitiationRemittanceInformation.unstructured) && Objects.equals(this.reference, obWriteDomestic2DataInitiationRemittanceInformation.reference);
    }

    public int hashCode() {
        return Objects.hash(this.unstructured, this.reference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDomestic2DataInitiationRemittanceInformation {\n");
        sb.append("    unstructured: ").append(this.toIndentedString(this.unstructured)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

