/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

@ApiModel(description="The authorisation type request from the TPP.")
public class OBWriteDomesticConsent3DataAuthorisation {
    @JsonProperty(value="AuthorisationType")
    private AuthorisationTypeEnum authorisationType = null;
    @JsonProperty(value="CompletionDateTime")
    private DateTime completionDateTime = null;

    public OBWriteDomesticConsent3DataAuthorisation authorisationType(AuthorisationTypeEnum authorisationType) {
        this.authorisationType = authorisationType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Type of authorisation flow requested.")
    public AuthorisationTypeEnum getAuthorisationType() {
        return this.authorisationType;
    }

    public void setAuthorisationType(AuthorisationTypeEnum authorisationType) {
        this.authorisationType = authorisationType;
    }

    public OBWriteDomesticConsent3DataAuthorisation completionDateTime(DateTime completionDateTime) {
        this.completionDateTime = completionDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Date and time at which the requested authorisation flow must be completed.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getCompletionDateTime() {
        return this.completionDateTime;
    }

    public void setCompletionDateTime(DateTime completionDateTime) {
        this.completionDateTime = completionDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDomesticConsent3DataAuthorisation obWriteDomesticConsent3DataAuthorisation = (OBWriteDomesticConsent3DataAuthorisation)o;
        return Objects.equals((Object)this.authorisationType, (Object)obWriteDomesticConsent3DataAuthorisation.authorisationType) && Objects.equals(this.completionDateTime, obWriteDomesticConsent3DataAuthorisation.completionDateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorisationType, this.completionDateTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDomesticConsent3DataAuthorisation {\n");
        sb.append("    authorisationType: ").append(this.toIndentedString((Object)this.authorisationType)).append("\n");
        sb.append("    completionDateTime: ").append(this.toIndentedString(this.completionDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AuthorisationTypeEnum {
        ANY("Any"),
        SINGLE("Single");

        private String value;

        private AuthorisationTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AuthorisationTypeEnum fromValue(String text) {
            for (AuthorisationTypeEnum b : AuthorisationTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

