/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

@ApiModel(description="The multiple authorisation flow response from the ASPSP.")
public class OBWriteDomesticResponse3DataMultiAuthorisation {
    @JsonProperty(value="Status")
    private StatusEnum status = null;
    @JsonProperty(value="NumberRequired")
    private Integer numberRequired = null;
    @JsonProperty(value="NumberReceived")
    private Integer numberReceived = null;
    @JsonProperty(value="LastUpdateDateTime")
    private DateTime lastUpdateDateTime = null;
    @JsonProperty(value="ExpirationDateTime")
    private DateTime expirationDateTime = null;

    public OBWriteDomesticResponse3DataMultiAuthorisation status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Specifies the status of the authorisation flow in code form.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OBWriteDomesticResponse3DataMultiAuthorisation numberRequired(Integer numberRequired) {
        this.numberRequired = numberRequired;
        return this;
    }

    @ApiModelProperty(value="Number of authorisations required for payment order (total required at the start of the multi authorisation journey).")
    public Integer getNumberRequired() {
        return this.numberRequired;
    }

    public void setNumberRequired(Integer numberRequired) {
        this.numberRequired = numberRequired;
    }

    public OBWriteDomesticResponse3DataMultiAuthorisation numberReceived(Integer numberReceived) {
        this.numberReceived = numberReceived;
        return this;
    }

    @ApiModelProperty(value="Number of authorisations received.")
    public Integer getNumberReceived() {
        return this.numberReceived;
    }

    public void setNumberReceived(Integer numberReceived) {
        this.numberReceived = numberReceived;
    }

    public OBWriteDomesticResponse3DataMultiAuthorisation lastUpdateDateTime(DateTime lastUpdateDateTime) {
        this.lastUpdateDateTime = lastUpdateDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Last date and time at the authorisation flow was updated.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getLastUpdateDateTime() {
        return this.lastUpdateDateTime;
    }

    public void setLastUpdateDateTime(DateTime lastUpdateDateTime) {
        this.lastUpdateDateTime = lastUpdateDateTime;
    }

    public OBWriteDomesticResponse3DataMultiAuthorisation expirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Date and time at which the requested authorisation flow must be completed.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public void setExpirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDomesticResponse3DataMultiAuthorisation obWriteDomesticResponse3DataMultiAuthorisation = (OBWriteDomesticResponse3DataMultiAuthorisation)o;
        return Objects.equals((Object)this.status, (Object)obWriteDomesticResponse3DataMultiAuthorisation.status) && Objects.equals(this.numberRequired, obWriteDomesticResponse3DataMultiAuthorisation.numberRequired) && Objects.equals(this.numberReceived, obWriteDomesticResponse3DataMultiAuthorisation.numberReceived) && Objects.equals(this.lastUpdateDateTime, obWriteDomesticResponse3DataMultiAuthorisation.lastUpdateDateTime) && Objects.equals(this.expirationDateTime, obWriteDomesticResponse3DataMultiAuthorisation.expirationDateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.numberRequired, this.numberReceived, this.lastUpdateDateTime, this.expirationDateTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDomesticResponse3DataMultiAuthorisation {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    numberRequired: ").append(this.toIndentedString(this.numberRequired)).append("\n");
        sb.append("    numberReceived: ").append(this.toIndentedString(this.numberReceived)).append("\n");
        sb.append("    lastUpdateDateTime: ").append(this.toIndentedString(this.lastUpdateDateTime)).append("\n");
        sb.append("    expirationDateTime: ").append(this.toIndentedString(this.expirationDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        AUTHORISED("Authorised"),
        AWAITINGFURTHERAUTHORISATION("AwaitingFurtherAuthorisation"),
        REJECTED("Rejected");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

