/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;

@ApiModel(description="Further detailed information on the exchange rate that has been used in the payment transaction.")
public class OBWriteInternationalConsentResponse3DataExchangeRateInformation {
    @JsonProperty(value="UnitCurrency")
    private String unitCurrency = null;
    @JsonProperty(value="ExchangeRate")
    private BigDecimal exchangeRate = null;
    @JsonProperty(value="RateType")
    private RateTypeEnum rateType = null;
    @JsonProperty(value="ContractIdentification")
    private String contractIdentification = null;
    @JsonProperty(value="ExpirationDateTime")
    private DateTime expirationDateTime = null;

    public OBWriteInternationalConsentResponse3DataExchangeRateInformation unitCurrency(String unitCurrency) {
        this.unitCurrency = unitCurrency;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    @ApiModelProperty(required=true, value="Currency in which the rate of exchange is expressed in a currency exchange. In the example 1GBP = xxxCUR, the unit currency is GBP.")
    public String getUnitCurrency() {
        return this.unitCurrency;
    }

    public void setUnitCurrency(String unitCurrency) {
        this.unitCurrency = unitCurrency;
    }

    public OBWriteInternationalConsentResponse3DataExchangeRateInformation exchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The factor used for conversion of an amount from one currency to another. This reflects the price at which one currency was bought with another currency.")
    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public OBWriteInternationalConsentResponse3DataExchangeRateInformation rateType(RateTypeEnum rateType) {
        this.rateType = rateType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Specifies the type used to complete the currency exchange.")
    public RateTypeEnum getRateType() {
        return this.rateType;
    }

    public void setRateType(RateTypeEnum rateType) {
        this.rateType = rateType;
    }

    public OBWriteInternationalConsentResponse3DataExchangeRateInformation contractIdentification(String contractIdentification) {
        this.contractIdentification = contractIdentification;
        return this;
    }

    @Size(min=1, max=256)
    @ApiModelProperty(value="Unique and unambiguous reference to the foreign exchange contract agreed between the initiating party/creditor and the debtor agent.")
    public String getContractIdentification() {
        return this.contractIdentification;
    }

    public void setContractIdentification(String contractIdentification) {
        this.contractIdentification = contractIdentification;
    }

    public OBWriteInternationalConsentResponse3DataExchangeRateInformation expirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Specified date and time the exchange rate agreement will expire.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public void setExpirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteInternationalConsentResponse3DataExchangeRateInformation obWriteInternationalConsentResponse3DataExchangeRateInformation = (OBWriteInternationalConsentResponse3DataExchangeRateInformation)o;
        return Objects.equals(this.unitCurrency, obWriteInternationalConsentResponse3DataExchangeRateInformation.unitCurrency) && Objects.equals(this.exchangeRate, obWriteInternationalConsentResponse3DataExchangeRateInformation.exchangeRate) && Objects.equals((Object)this.rateType, (Object)obWriteInternationalConsentResponse3DataExchangeRateInformation.rateType) && Objects.equals(this.contractIdentification, obWriteInternationalConsentResponse3DataExchangeRateInformation.contractIdentification) && Objects.equals(this.expirationDateTime, obWriteInternationalConsentResponse3DataExchangeRateInformation.expirationDateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unitCurrency, this.exchangeRate, this.rateType, this.contractIdentification, this.expirationDateTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteInternationalConsentResponse3DataExchangeRateInformation {\n");
        sb.append("    unitCurrency: ").append(this.toIndentedString(this.unitCurrency)).append("\n");
        sb.append("    exchangeRate: ").append(this.toIndentedString(this.exchangeRate)).append("\n");
        sb.append("    rateType: ").append(this.toIndentedString((Object)this.rateType)).append("\n");
        sb.append("    contractIdentification: ").append(this.toIndentedString(this.contractIdentification)).append("\n");
        sb.append("    expirationDateTime: ").append(this.toIndentedString(this.expirationDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RateTypeEnum {
        ACTUAL("Actual"),
        AGREED("Agreed"),
        INDICATIVE("Indicative");

        private String value;

        private RateTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RateTypeEnum fromValue(String text) {
            for (RateTypeEnum b : RateTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

