/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.payment.OBPostalAddress6;

@ApiModel(description="Party that manages the account on behalf of the account owner, that is manages the registration and booking of entries on the account, calculates balances on the account and provides information about the account. This is the servicer of the beneficiary account.")
public class OBWriteInternationalStandingOrder3DataInitiationCreditorAgent {
    @JsonProperty(value="SchemeName")
    private String schemeName = null;
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="PostalAddress")
    private OBPostalAddress6 postalAddress = null;

    public OBWriteInternationalStandingOrder3DataInitiationCreditorAgent schemeName(String schemeName) {
        this.schemeName = schemeName;
        return this;
    }

    @ApiModelProperty(value="Name of the identification scheme, in a coded form as published in an external list.")
    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public OBWriteInternationalStandingOrder3DataInitiationCreditorAgent identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique and unambiguous identification of the servicing institution.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBWriteInternationalStandingOrder3DataInitiationCreditorAgent name(String name) {
        this.name = name;
        return this;
    }

    @Size(min=1, max=140)
    @ApiModelProperty(value="Name by which an agent is known and which is usually used to identify that agent.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBWriteInternationalStandingOrder3DataInitiationCreditorAgent postalAddress(OBPostalAddress6 postalAddress) {
        this.postalAddress = postalAddress;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBPostalAddress6 getPostalAddress() {
        return this.postalAddress;
    }

    public void setPostalAddress(OBPostalAddress6 postalAddress) {
        this.postalAddress = postalAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteInternationalStandingOrder3DataInitiationCreditorAgent obWriteInternationalStandingOrder3DataInitiationCreditorAgent = (OBWriteInternationalStandingOrder3DataInitiationCreditorAgent)o;
        return Objects.equals(this.schemeName, obWriteInternationalStandingOrder3DataInitiationCreditorAgent.schemeName) && Objects.equals(this.identification, obWriteInternationalStandingOrder3DataInitiationCreditorAgent.identification) && Objects.equals(this.name, obWriteInternationalStandingOrder3DataInitiationCreditorAgent.name) && Objects.equals(this.postalAddress, obWriteInternationalStandingOrder3DataInitiationCreditorAgent.postalAddress);
    }

    public int hashCode() {
        return Objects.hash(this.schemeName, this.identification, this.name, this.postalAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteInternationalStandingOrder3DataInitiationCreditorAgent {\n");
        sb.append("    schemeName: ").append(this.toIndentedString(this.schemeName)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    postalAddress: ").append(this.toIndentedString(this.postalAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

