/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.payment.OBWritePaymentDetailsResponse1DataStatusDetail;

@ApiModel(description="Payment status details.")
public class OBWritePaymentDetailsResponse1DataPaymentStatus {
    @JsonProperty(value="PaymentTransactionId")
    private String paymentTransactionId = null;
    @JsonProperty(value="Status")
    private StatusEnum status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private DateTime statusUpdateDateTime = null;
    @JsonProperty(value="StatusDetail")
    private OBWritePaymentDetailsResponse1DataStatusDetail statusDetail = null;

    public OBWritePaymentDetailsResponse1DataPaymentStatus paymentTransactionId(String paymentTransactionId) {
        this.paymentTransactionId = paymentTransactionId;
        return this;
    }

    @NotNull
    @Size(min=1, max=210)
    @ApiModelProperty(required=true, value="Unique identifier for the transaction within an servicing institution. This identifier is both unique and immutable.")
    public String getPaymentTransactionId() {
        return this.paymentTransactionId;
    }

    public void setPaymentTransactionId(String paymentTransactionId) {
        this.paymentTransactionId = paymentTransactionId;
    }

    public OBWritePaymentDetailsResponse1DataPaymentStatus status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Status of a transfe, as assigned by the transaction administrator.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OBWritePaymentDetailsResponse1DataPaymentStatus statusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the status was assigned to the transfer.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBWritePaymentDetailsResponse1DataPaymentStatus statusDetail(OBWritePaymentDetailsResponse1DataStatusDetail statusDetail) {
        this.statusDetail = statusDetail;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWritePaymentDetailsResponse1DataStatusDetail getStatusDetail() {
        return this.statusDetail;
    }

    public void setStatusDetail(OBWritePaymentDetailsResponse1DataStatusDetail statusDetail) {
        this.statusDetail = statusDetail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWritePaymentDetailsResponse1DataPaymentStatus obWritePaymentDetailsResponse1DataPaymentStatus = (OBWritePaymentDetailsResponse1DataPaymentStatus)o;
        return Objects.equals(this.paymentTransactionId, obWritePaymentDetailsResponse1DataPaymentStatus.paymentTransactionId) && Objects.equals((Object)this.status, (Object)obWritePaymentDetailsResponse1DataPaymentStatus.status) && Objects.equals(this.statusUpdateDateTime, obWritePaymentDetailsResponse1DataPaymentStatus.statusUpdateDateTime) && Objects.equals(this.statusDetail, obWritePaymentDetailsResponse1DataPaymentStatus.statusDetail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentTransactionId, this.status, this.statusUpdateDateTime, this.statusDetail});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWritePaymentDetailsResponse1DataPaymentStatus {\n");
        sb.append("    paymentTransactionId: ").append(this.toIndentedString(this.paymentTransactionId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    statusDetail: ").append(this.toIndentedString(this.statusDetail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACCEPTED("Accepted"),
        ACCEPTEDCANCELLATIONREQUEST("AcceptedCancellationRequest"),
        ACCEPTEDCREDITSETTLEMENTCOMPLETED("AcceptedCreditSettlementCompleted"),
        ACCEPTEDCUSTOMERPROFILE("AcceptedCustomerProfile"),
        ACCEPTEDFUNDSCHECKED("AcceptedFundsChecked"),
        ACCEPTEDSETTLEMENTCOMPLETED("AcceptedSettlementCompleted"),
        ACCEPTEDSETTLEMENTINPROCESS("AcceptedSettlementInProcess"),
        ACCEPTEDTECHNICALVALIDATION("AcceptedTechnicalValidation"),
        ACCEPTEDWITHCHANGE("AcceptedWithChange"),
        ACCEPTEDWITHOUTPOSTING("AcceptedWithoutPosting"),
        CANCELLED("Cancelled"),
        NOCANCELLATIONPROCESS("NoCancellationProcess"),
        PARTIALLYACCEPTEDCANCELLATIONREQUEST("PartiallyAcceptedCancellationRequest"),
        PARTIALLYACCEPTEDTECHNICALCORRECT("PartiallyAcceptedTechnicalCorrect"),
        PAYMENTCANCELLED("PaymentCancelled"),
        PENDING("Pending"),
        PENDINGCANCELLATIONREQUEST("PendingCancellationRequest"),
        RECEIVED("Received"),
        REJECTED("Rejected"),
        REJECTEDCANCELLATIONREQUEST("RejectedCancellationRequest");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

