/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.service.converter;

import uk.org.openbanking.datamodel.account.OBExternalProductType1Code;
import uk.org.openbanking.datamodel.account.OBExternalProductType2Code;
import uk.org.openbanking.datamodel.account.OBProduct1;
import uk.org.openbanking.datamodel.account.OBProduct2;

public class OBProductConverter {
    public static OBProduct1 toProduct1(OBProduct2 obProduct2) {
        OBProduct1 product1 = new OBProduct1().accountId(obProduct2.getAccountId()).productType(OBExternalProductType1Code.valueOf(obProduct2.getProductType().toString()));
        if (obProduct2.getProductId() != null) {
            product1.productIdentifier(obProduct2.getProductId());
        }
        if (obProduct2.getProductName() != null) {
            product1.productName(obProduct2.getProductName());
        }
        if (obProduct2.getSecondaryProductId() != null) {
            product1.secondaryProductIdentifier(obProduct2.getSecondaryProductId());
        }
        return product1;
    }

    public static OBProduct2 toProductBeforeV3(OBProduct2 obProduct2V3) {
        OBProduct2 product2 = new OBProduct2().accountId(obProduct2V3.getAccountId());
        switch (obProduct2V3.getProductType()) {
            case BUSINESSCURRENTACCOUNT: {
                product2.setProductType(OBExternalProductType2Code.BCA);
                break;
            }
            case PERSONALCURRENTACCOUNT: {
                product2.setProductType(OBExternalProductType2Code.PCA);
            }
        }
        if (obProduct2V3.getProductId() != null) {
            product2.productId(obProduct2V3.getProductId());
        }
        if (obProduct2V3.getProductName() != null) {
            product2.productName(obProduct2V3.getProductName());
        }
        if (obProduct2V3.getSecondaryProductId() != null) {
            product2.secondaryProductId(obProduct2V3.getSecondaryProductId());
        }
        return product2;
    }

    public static OBProduct2 toProduct2(OBProduct1 obProduct1) {
        OBProduct2 product2 = new OBProduct2().accountId(obProduct1.getAccountId()).productType(OBExternalProductType2Code.valueOf(obProduct1.getProductType().toString()));
        if (obProduct1.getProductIdentifier() != null) {
            product2.productId(obProduct1.getProductIdentifier());
        }
        if (obProduct1.getProductName() != null) {
            product2.productName(obProduct1.getProductName());
        }
        if (obProduct1.getSecondaryProductIdentifier() != null) {
            product2.secondaryProductId(obProduct1.getSecondaryProductIdentifier());
        }
        return product2;
    }
}

