/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.annotation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.rabbit.annotation.RabbitAdminNameResolver;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.RabbitListenerAnnotationBeanPostProcessor;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ExtendedMultiRabbitListenerAnnotationBeanPostProcessor
extends RabbitListenerAnnotationBeanPostProcessor {
    public ExtendedMultiRabbitListenerAnnotationBeanPostProcessor(ConnectionFactory multiRabbitConnectionFactory) {
        Assert.state((multiRabbitConnectionFactory != null ? 1 : 0) != 0, (String)"multiRabbitConnectionFactory must be available");
    }

    protected Collection<Declarable> processAmqpListener(RabbitListener rabbitListener, Method method, Object bean, String beanName) {
        String rabbitAdmin = RabbitAdminNameResolver.resolve(rabbitListener);
        RabbitListener rabbitListenerRef = this.proxyIfAdminNotPresent(rabbitListener, rabbitAdmin);
        Collection declarables = super.processAmqpListener(rabbitListenerRef, method, bean, beanName);
        declarables.forEach(declarable -> declarable.setAdminsThatShouldDeclare(new Object[]{rabbitAdmin}));
        return declarables;
    }

    private RabbitListener proxyIfAdminNotPresent(RabbitListener rabbitListener, String rabbitAdmin) {
        if (StringUtils.hasText((String)rabbitListener.admin())) {
            return rabbitListener;
        }
        return (RabbitListener)Proxy.newProxyInstance(RabbitListener.class.getClassLoader(), new Class[]{RabbitListener.class}, (InvocationHandler)new RabbitListenerAdminReplacementInvocationHandler(rabbitListener, rabbitAdmin));
    }

    private final class RabbitListenerAdminReplacementInvocationHandler
    implements InvocationHandler {
        private final RabbitListener target;
        private final String admin;

        private RabbitListenerAdminReplacementInvocationHandler(RabbitListener target, String admin) {
            this.target = target;
            this.admin = admin;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
            if (method.getName().equals("admin")) {
                return this.admin;
            }
            return method.invoke((Object)this.target, args);
        }
    }
}

