/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.annotation;

import org.springframework.amqp.rabbit.annotation.ExtendedMultiRabbitListenerAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class MultiRabbitBootstrapConfiguration
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (this.isMultiRabbitEnabled()) {
            if (registry.containsBeanDefinition("org.springframework.amqp.rabbit.config.internalRabbitListenerAnnotationProcessor")) {
                registry.removeBeanDefinition("org.springframework.amqp.rabbit.config.internalRabbitListenerAnnotationProcessor");
            }
            registry.registerBeanDefinition("org.springframework.amqp.rabbit.config.internalRabbitListenerAnnotationProcessor", (BeanDefinition)new RootBeanDefinition(ExtendedMultiRabbitListenerAnnotationBeanPostProcessor.class));
        }
    }

    private boolean isMultiRabbitEnabled() {
        String isMultiEnabledStr = this.environment.getProperty("spring.multirabbitmq.enabled");
        return Boolean.parseBoolean(isMultiEnabledStr);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

