/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import java.util.concurrent.Callable;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.SimpleResourceHolder;
import org.springframework.util.StringUtils;

public class ConnectionFactoryContextWrapper {
    private final ConnectionFactory connectionFactory;

    public ConnectionFactoryContextWrapper(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public <T> T call(Callable<T> callable) throws Exception {
        return this.call(null, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(String contextName, Callable<T> callable) throws Exception {
        try {
            this.bind(contextName);
            T t = callable.call();
            return t;
        }
        finally {
            this.unbind(contextName);
        }
    }

    public void run(Runnable runnable) {
        this.run(null, runnable);
    }

    public void run(String contextName, Runnable runnable) {
        try {
            this.bind(contextName);
            runnable.run();
        }
        finally {
            this.unbind(contextName);
        }
    }

    private void bind(String contextName) {
        if (StringUtils.hasText((String)contextName)) {
            SimpleResourceHolder.bind((Object)this.connectionFactory, (Object)contextName);
        }
    }

    private void unbind(String contextName) {
        if (StringUtils.hasText((String)contextName)) {
            SimpleResourceHolder.unbind((Object)this.connectionFactory);
        }
    }
}

