/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.MultiRabbitListenerConfigurationSelector;
import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.SimpleRoutingConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.amqp.CachingConnectionFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.ConnectionFactoryContextWrapper;
import org.springframework.boot.autoconfigure.amqp.ConnectionFactoryCustomizer;
import org.springframework.boot.autoconfigure.amqp.MultiRabbitConnectionFactoryWrapper;
import org.springframework.boot.autoconfigure.amqp.MultiRabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionFactoryBeanConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={RabbitTemplate.class, Channel.class})
@EnableConfigurationProperties(value={RabbitProperties.class, MultiRabbitProperties.class})
@Import(value={MultiRabbitListenerConfigurationSelector.class, RabbitAutoConfiguration.class})
public class MultiRabbitAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiRabbitAutoConfiguration.class);

    @Primary
    @Bean(value={"rabbitConnectionFactoryCreator"})
    @ConditionalOnProperty(prefix="spring.multirabbitmq", name={"enabled"}, havingValue="true")
    public RabbitAutoConfiguration.RabbitConnectionFactoryCreator rabbitConnectionFactoryCreator() {
        return new RabbitAutoConfiguration.RabbitConnectionFactoryCreator();
    }

    @Configuration
    @DependsOn(value={"rabbitConnectionFactoryCreator"})
    @ConditionalOnProperty(prefix="spring.multirabbitmq", name={"enabled"}, havingValue="true")
    protected static class MultiRabbitConnectionFactoryCreator
    implements BeanFactoryAware,
    ApplicationContextAware {
        private ConfigurableListableBeanFactory beanFactory;
        private ApplicationContext applicationContext;
        private final RabbitAutoConfiguration.RabbitConnectionFactoryCreator springFactoryCreator;

        MultiRabbitConnectionFactoryCreator(RabbitAutoConfiguration.RabbitConnectionFactoryCreator springFactoryCreator) {
            this.springFactoryCreator = springFactoryCreator;
        }

        @Bean
        @ConditionalOnMissingBean
        public ConnectionFactoryContextWrapper contextWrapper(ConnectionFactory connectionFactory) {
            return new ConnectionFactoryContextWrapper(connectionFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        public MultiRabbitConnectionFactoryWrapper externalEmptyWrapper() {
            return new MultiRabbitConnectionFactoryWrapper();
        }

        @Primary
        @Bean(value={"multiRabbitConnectionFactory"})
        public ConnectionFactory routingConnectionFactory(RabbitProperties rabbitProperties, MultiRabbitProperties multiRabbitProperties, MultiRabbitConnectionFactoryWrapper externalWrapper, ResourceLoader resourceLoader, ObjectProvider<CredentialsProvider> credentialsProvider, ObjectProvider<CredentialsRefreshService> credentialsRefreshService, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy, ObjectProvider<ConnectionFactoryCustomizer> connectionFactoryCustomizers) throws Exception {
            MultiRabbitConnectionFactoryWrapper internalWrapper = this.instantiateConnectionFactories(rabbitProperties, multiRabbitProperties, resourceLoader, credentialsProvider, credentialsRefreshService, connectionNameStrategy, connectionFactoryCustomizers);
            MultiRabbitConnectionFactoryWrapper aggregatedWrapper = this.aggregateConnectionFactoryWrappers(internalWrapper, externalWrapper);
            if (aggregatedWrapper.getDefaultConnectionFactory() == null) {
                throw new IllegalArgumentException("A default ConnectionFactory must be provided.");
            }
            aggregatedWrapper.getEntries().forEach((name, value) -> {
                this.registerContainerFactoryBean((String)name, value.getContainerFactory());
                this.registerRabbitAdmins((String)name, value.getConnectionFactory());
            });
            SimpleRoutingConnectionFactory connectionFactory = new SimpleRoutingConnectionFactory();
            connectionFactory.setTargetConnectionFactories(aggregatedWrapper.getConnectionFactories());
            connectionFactory.setDefaultTargetConnectionFactory(aggregatedWrapper.getDefaultConnectionFactory());
            return connectionFactory;
        }

        private MultiRabbitConnectionFactoryWrapper aggregateConnectionFactoryWrappers(MultiRabbitConnectionFactoryWrapper internalWrapper, MultiRabbitConnectionFactoryWrapper externalWrapper) {
            MultiRabbitConnectionFactoryWrapper aggregatedWrapper = new MultiRabbitConnectionFactoryWrapper();
            aggregatedWrapper.putEntriesFrom(internalWrapper);
            aggregatedWrapper.putEntriesFrom(externalWrapper);
            aggregatedWrapper.setDefaultConnectionFactory(externalWrapper.getDefaultConnectionFactory() != null ? externalWrapper.getDefaultConnectionFactory() : internalWrapper.getDefaultConnectionFactory());
            return aggregatedWrapper;
        }

        private MultiRabbitConnectionFactoryWrapper instantiateConnectionFactories(RabbitProperties rabbitProperties, MultiRabbitProperties multiRabbitProperties, ResourceLoader resourceLoader, ObjectProvider<CredentialsProvider> credentialsProvider, ObjectProvider<CredentialsRefreshService> credentialsRefreshService, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy, ObjectProvider<ConnectionFactoryCustomizer> connectionFactoryCustomizer) throws Exception {
            String defaultConnectionFactoryKey;
            MultiRabbitConnectionFactoryWrapper wrapper = new MultiRabbitConnectionFactoryWrapper();
            Map<Object, Object> propertiesMap = multiRabbitProperties != null ? multiRabbitProperties.getConnections() : Collections.emptyMap();
            for (Map.Entry<Object, Object> entry : propertiesMap.entrySet()) {
                RabbitConnectionFactoryBeanConfigurer rabbitConnectionFactoryBeanConfigurer = this.springFactoryCreator.rabbitConnectionFactoryBeanConfigurer((RabbitProperties)entry.getValue(), resourceLoader, credentialsProvider, credentialsRefreshService);
                CachingConnectionFactoryConfigurer rabbitCachingConnectionFactoryConfigurer = this.springFactoryCreator.rabbitConnectionFactoryConfigurer((RabbitProperties)entry.getValue(), connectionNameStrategy);
                CachingConnectionFactory connectionFactory = this.springFactoryCreator.rabbitConnectionFactory(rabbitConnectionFactoryBeanConfigurer, rabbitCachingConnectionFactoryConfigurer, connectionFactoryCustomizer);
                SimpleRabbitListenerContainerFactory containerFactory = this.newContainerFactory((ConnectionFactory)connectionFactory);
                RabbitAdmin rabbitAdmin = this.newRabbitAdmin((ConnectionFactory)connectionFactory);
                wrapper.addConnectionFactory((String)entry.getKey(), (ConnectionFactory)connectionFactory, (AbstractRabbitListenerContainerFactory<?>)containerFactory, rabbitAdmin);
            }
            String string = defaultConnectionFactoryKey = multiRabbitProperties != null ? multiRabbitProperties.getDefaultConnection() : null;
            if (StringUtils.hasText((String)defaultConnectionFactoryKey) && !multiRabbitProperties.getConnections().containsKey(defaultConnectionFactoryKey)) {
                String msg = String.format("MultiRabbitMQ broker '%s' set as default does not exist in configuration", defaultConnectionFactoryKey);
                LOGGER.error(msg);
                throw new IllegalArgumentException(msg);
            }
            RabbitConnectionFactoryBeanConfigurer rabbitConnectionFactoryBeanConfigurer = this.springFactoryCreator.rabbitConnectionFactoryBeanConfigurer(rabbitProperties, resourceLoader, credentialsProvider, credentialsRefreshService);
            CachingConnectionFactoryConfigurer rabbitCachingConnectionFactoryConfigurer = this.springFactoryCreator.rabbitConnectionFactoryConfigurer(rabbitProperties, connectionNameStrategy);
            ConnectionFactory defaultConnectionFactory = StringUtils.hasText((String)defaultConnectionFactoryKey) ? wrapper.getConnectionFactories().get(defaultConnectionFactoryKey) : this.springFactoryCreator.rabbitConnectionFactory(rabbitConnectionFactoryBeanConfigurer, rabbitCachingConnectionFactoryConfigurer, connectionFactoryCustomizer);
            wrapper.setDefaultConnectionFactory(defaultConnectionFactory);
            return wrapper;
        }

        private SimpleRabbitListenerContainerFactory newContainerFactory(ConnectionFactory connectionFactory) {
            SimpleRabbitListenerContainerFactory containerFactory = new SimpleRabbitListenerContainerFactory();
            containerFactory.setConnectionFactory(connectionFactory);
            return containerFactory;
        }

        private RabbitAdmin newRabbitAdmin(ConnectionFactory connectionFactory) {
            return new RabbitAdmin(connectionFactory);
        }

        private void registerContainerFactoryBean(String name, AbstractRabbitListenerContainerFactory<?> containerFactory) {
            this.beanFactory.registerSingleton(name, containerFactory);
        }

        private void registerRabbitAdmins(String name, ConnectionFactory connectionFactory) {
            String beanName = name + "-admin";
            RabbitAdmin rabbitAdmin = new RabbitAdmin(connectionFactory);
            rabbitAdmin.setApplicationContext(this.applicationContext);
            rabbitAdmin.setBeanName(beanName);
            rabbitAdmin.afterPropertiesSet();
            this.beanFactory.registerSingleton(beanName, (Object)rabbitAdmin);
        }

        public void setBeanFactory(BeanFactory beanFactory) {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }

        public void setApplicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }
    }
}

