/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.util.Assert;

public class MultiRabbitConnectionFactoryWrapper {
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    private final Map<String, Entry> immutableEntries = Collections.unmodifiableMap(this.entries);
    private ConnectionFactory defaultConnectionFactory;

    void putEntriesFrom(MultiRabbitConnectionFactoryWrapper fromWrapper) {
        if (fromWrapper != null) {
            fromWrapper.getEntries().forEach(this.entries::put);
        }
    }

    public void setDefaultConnectionFactory(ConnectionFactory connectionFactory) {
        this.defaultConnectionFactory = connectionFactory;
    }

    ConnectionFactory getDefaultConnectionFactory() {
        return this.defaultConnectionFactory;
    }

    public void addConnectionFactory(String key, ConnectionFactory connectionFactory) {
        this.addConnectionFactory(key, connectionFactory, null, null);
    }

    public void addConnectionFactory(String key, ConnectionFactory connectionFactory, AbstractRabbitListenerContainerFactory<?> containerFactory) {
        this.addConnectionFactory(key, connectionFactory, containerFactory, null);
    }

    public void addConnectionFactory(String key, ConnectionFactory connectionFactory, AbstractRabbitListenerContainerFactory<?> containerFactory, RabbitAdmin rabbitAdmin) {
        Assert.hasText((String)key, (String)"Key may not be null or empty");
        this.entries.put(key, new Entry(connectionFactory, containerFactory, rabbitAdmin));
    }

    public Map<String, Entry> getEntries() {
        return this.immutableEntries;
    }

    Map<Object, ConnectionFactory> getConnectionFactories() {
        return this.immutableEntries.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Entry)entry.getValue()).getConnectionFactory()));
    }

    static final class Entry {
        private final ConnectionFactory connectionFactory;
        private final AbstractRabbitListenerContainerFactory<?> containerFactory;
        private final RabbitAdmin rabbitAdmin;

        private Entry(ConnectionFactory connectionFactory, AbstractRabbitListenerContainerFactory<?> containerFactory, RabbitAdmin rabbitAdmin) {
            Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory may not be null");
            if (containerFactory != null) {
                containerFactory.setConnectionFactory(connectionFactory);
            }
            this.connectionFactory = connectionFactory;
            this.containerFactory = containerFactory;
            this.rabbitAdmin = rabbitAdmin;
        }

        ConnectionFactory getConnectionFactory() {
            return this.connectionFactory;
        }

        AbstractRabbitListenerContainerFactory<?> getContainerFactory() {
            return this.containerFactory;
        }

        RabbitAdmin getRabbitAdmin() {
            return this.rabbitAdmin;
        }
    }
}

