/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.File;
import java.util.Date;
import org.scalafmt.Versions$;
import org.scalafmt.cli.CliArgParser$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.CommonOptions;
import org.scalafmt.cli.Override$;
import org.scalafmt.cli.Stdout$;
import org.scalafmt.cli.WriteMode;
import org.scalafmt.config.Config$;
import org.scalafmt.config.ScalafmtConfig;
import org.scalafmt.util.AbsoluteFile;
import org.scalafmt.util.AbsoluteFile$;
import org.scalafmt.util.FileOps$;
import org.scalafmt.util.GitOps;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scopt.OptionParser;
import scopt.Read$;

public final class CliArgParser$ {
    public static final CliArgParser$ MODULE$;
    private final String usageExamples;
    private final OptionParser<CliOptions> scoptParser;
    private final String gitCommit;
    private final long buildTimeMs;

    static {
        new CliArgParser$();
    }

    public String gitCommit() {
        return this.gitCommit;
    }

    public long buildTimeMs() {
        return this.buildTimeMs;
    }

    public String usageExamples() {
        return this.usageExamples;
    }

    public OptionParser<CliOptions> scoptParser() {
        return this.scoptParser;
    }

    public String buildInfo() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"build commit: ", "\n       |build time: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.gitCommit(), new Date(this.buildTimeMs())})))).stripMargin();
    }

    private CliArgParser$() {
        MODULE$ = this;
        this.gitCommit = "143bff64f2";
        this.buildTimeMs = 1506279837219L;
        this.usageExamples = new StringOps(Predef$.MODULE$.augmentString("|scalafmt # Format all files in the current project, configuration is determined in this order:\n       |         # 1. .scalafmt.conf file in current directory\n       |         # 2. .scalafmt.conf inside root directory of current git repo\n       |         # 3. no configuration, default style\n       |scalafmt --test # throw exception on mis-formatted files, won't write to files.\n       |scalafmt --diff # Format all files that were edited in git diff against master branch.\n       |scalafmt --diff-branch 2.x # same as --diff, except against branch 2.x\n       |scalafmt --stdin # read from stdin and print to stdout\n       |scalafmt --stdin --assume-filename foo.sbt < foo.sbt # required when using --stdin to format .sbt files.\n       |scalafmt Code1.scala A.scala       # write formatted contents to file.\n       |scalafmt --stdout Code.scala       # print formatted contents to stdout.\n       |scalafmt --exclude target          # format all files in directory excluding target\n       |scalafmt --config .scalafmt.conf   # read custom style from file\n       |scalafmt --config-str \"style=IntelliJ\" # define custom style as a flag, must be quoted.")).stripMargin();
        this.scoptParser = new OptionParser<CliOptions>(){

            public boolean showUsageOnError() {
                return false;
            }

            public CliOptions org$scalafmt$cli$CliArgParser$$anon$$printAndExit(boolean inludeUsage, BoxedUnit ignore, CliOptions c) {
                if (inludeUsage) {
                    this.showUsage();
                } else {
                    this.showHeader();
                }
                throw scala.sys.package$.MODULE$.exit();
            }

            public CliOptions org$scalafmt$cli$CliArgParser$$anon$$readConfigFromFile(String file, CliOptions c) {
                return this.org$scalafmt$cli$CliArgParser$$anon$$readConfig(FileOps$.MODULE$.readFile(AbsoluteFile$.MODULE$.fromFile(new File(file), c.common().workingDirectory()), Codec$.MODULE$.fallbackSystemCodec()), c);
            }

            public CliOptions org$scalafmt$cli$CliArgParser$$anon$$readConfig(String contents, CliOptions c) {
                return c.copy((ScalafmtConfig)Config$.MODULE$.fromHoconString(contents, Config$.MODULE$.fromHoconString$default$2()).get(), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14(), c.copy$default$15(), c.copy$default$16(), c.copy$default$17());
            }

            public CliOptions org$scalafmt$cli$CliArgParser$$anon$$addFile(File file, CliOptions c) {
                AbsoluteFile absFile = AbsoluteFile$.MODULE$.fromFile(file, c.common().workingDirectory());
                Seq x$8 = (Seq)c.customFiles().$colon$plus((Object)absFile, Seq$.MODULE$.canBuildFrom());
                ScalafmtConfig x$9 = c.copy$default$1();
                Set<Range> x$10 = c.copy$default$2();
                Seq<String> x$11 = c.copy$default$4();
                WriteMode x$12 = c.copy$default$5();
                boolean x$13 = c.copy$default$6();
                boolean x$14 = c.copy$default$7();
                boolean x$15 = c.copy$default$8();
                boolean x$16 = c.copy$default$9();
                Option<Object> x$17 = c.copy$default$10();
                boolean x$18 = c.copy$default$11();
                Option<String> x$19 = c.copy$default$12();
                String x$20 = c.copy$default$13();
                Option<AbsoluteFile> x$21 = c.copy$default$14();
                CommonOptions x$22 = c.copy$default$15();
                Function1<AbsoluteFile, GitOps> x$23 = c.copy$default$16();
                boolean x$24 = c.copy$default$17();
                return c.copy(x$9, x$10, (Seq<AbsoluteFile>)x$8, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scalafmt", Versions$.MODULE$.nightly()}));
                this.opt('h', "help", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final CliOptions apply(BoxedUnit ignore, CliOptions c) {
                        return this.$outer.org$scalafmt$cli$CliArgParser$$anon$$printAndExit(true, ignore, c);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).text("prints this usage text");
                this.opt('v', "version", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final CliOptions apply(BoxedUnit ignore, CliOptions c) {
                        return this.$outer.org$scalafmt$cli$CliArgParser$$anon$$printAndExit(false, ignore, c);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).text("print version ");
                this.arg("<file>...", Read$.MODULE$.fileRead()).optional().unbounded().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final CliOptions apply(File file, CliOptions c) {
                        return this.$outer.org$scalafmt$cli$CliArgParser$$anon$$addFile(file, c);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).text("file or directory, in which case all *.scala files are formatted.");
                this.opt('f', "files", Read$.MODULE$.seqRead(Read$.MODULE$.fileRead())).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(Seq<File> files, CliOptions c) {
                        Seq x$25 = AbsoluteFile$.MODULE$.fromFiles(files, c.common().workingDirectory());
                        ScalafmtConfig x$26 = c.copy$default$1();
                        Set<Range> x$27 = c.copy$default$2();
                        Seq<String> x$28 = c.copy$default$4();
                        WriteMode x$29 = c.copy$default$5();
                        boolean x$30 = c.copy$default$6();
                        boolean x$31 = c.copy$default$7();
                        boolean x$32 = c.copy$default$8();
                        boolean x$33 = c.copy$default$9();
                        Option<Object> x$34 = c.copy$default$10();
                        boolean x$35 = c.copy$default$11();
                        Option<String> x$36 = c.copy$default$12();
                        String x$37 = c.copy$default$13();
                        Option<AbsoluteFile> x$38 = c.copy$default$14();
                        CommonOptions x$39 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$40 = c.copy$default$16();
                        boolean x$41 = c.copy$default$17();
                        return c.copy(x$26, x$27, (Seq<AbsoluteFile>)x$25, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41);
                    }
                }).hidden().text("file or directory, in which case all *.scala files are formatted. Deprecated: pass files as arguments");
                this.opt('i', "in-place", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit opt, CliOptions c) {
                        Override$ x$42 = Override$.MODULE$;
                        ScalafmtConfig x$43 = c.copy$default$1();
                        Set<Range> x$44 = c.copy$default$2();
                        Seq<AbsoluteFile> x$45 = c.copy$default$3();
                        Seq<String> x$46 = c.copy$default$4();
                        boolean x$47 = c.copy$default$6();
                        boolean x$48 = c.copy$default$7();
                        boolean x$49 = c.copy$default$8();
                        boolean x$50 = c.copy$default$9();
                        Option<Object> x$51 = c.copy$default$10();
                        boolean x$52 = c.copy$default$11();
                        Option<String> x$53 = c.copy$default$12();
                        String x$54 = c.copy$default$13();
                        Option<AbsoluteFile> x$55 = c.copy$default$14();
                        CommonOptions x$56 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$57 = c.copy$default$16();
                        boolean x$58 = c.copy$default$17();
                        return c.copy(x$43, x$44, x$45, x$46, x$42, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58);
                    }
                }).hidden().text("format files in-place (default)");
                this.opt("stdout", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit opt, CliOptions c) {
                        Stdout$ x$59 = Stdout$.MODULE$;
                        ScalafmtConfig x$60 = c.copy$default$1();
                        Set<Range> x$61 = c.copy$default$2();
                        Seq<AbsoluteFile> x$62 = c.copy$default$3();
                        Seq<String> x$63 = c.copy$default$4();
                        boolean x$64 = c.copy$default$6();
                        boolean x$65 = c.copy$default$7();
                        boolean x$66 = c.copy$default$8();
                        boolean x$67 = c.copy$default$9();
                        Option<Object> x$68 = c.copy$default$10();
                        boolean x$69 = c.copy$default$11();
                        Option<String> x$70 = c.copy$default$12();
                        String x$71 = c.copy$default$13();
                        Option<AbsoluteFile> x$72 = c.copy$default$14();
                        CommonOptions x$73 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$74 = c.copy$default$16();
                        boolean x$75 = c.copy$default$17();
                        return c.copy(x$60, x$61, x$62, x$63, x$59, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75);
                    }
                }).text("write formatted files to stdout");
                this.opt("git", Read$.MODULE$.booleanRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(boolean opt, CliOptions c) {
                        Some x$76 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)opt));
                        ScalafmtConfig x$77 = c.copy$default$1();
                        Set<Range> x$78 = c.copy$default$2();
                        Seq<AbsoluteFile> x$79 = c.copy$default$3();
                        Seq<String> x$80 = c.copy$default$4();
                        WriteMode x$81 = c.copy$default$5();
                        boolean x$82 = c.copy$default$6();
                        boolean x$83 = c.copy$default$7();
                        boolean x$84 = c.copy$default$8();
                        boolean x$85 = c.copy$default$9();
                        boolean x$86 = c.copy$default$11();
                        Option<String> x$87 = c.copy$default$12();
                        String x$88 = c.copy$default$13();
                        Option<AbsoluteFile> x$89 = c.copy$default$14();
                        CommonOptions x$90 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$91 = c.copy$default$16();
                        boolean x$92 = c.copy$default$17();
                        return c.copy(x$77, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85, (Option<Object>)x$76, x$86, x$87, x$88, x$89, x$90, x$91, x$92);
                    }
                }).text("if true, ignore files in .gitignore (default false)");
                this.opt("exclude", Read$.MODULE$.seqRead(Read$.MODULE$.stringRead())).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(Seq<String> excludes, CliOptions c) {
                        Seq<String> x$93 = excludes;
                        ScalafmtConfig x$94 = c.copy$default$1();
                        Set<Range> x$95 = c.copy$default$2();
                        Seq<AbsoluteFile> x$96 = c.copy$default$3();
                        WriteMode x$97 = c.copy$default$5();
                        boolean x$98 = c.copy$default$6();
                        boolean x$99 = c.copy$default$7();
                        boolean x$100 = c.copy$default$8();
                        boolean x$101 = c.copy$default$9();
                        Option<Object> x$102 = c.copy$default$10();
                        boolean x$103 = c.copy$default$11();
                        Option<String> x$104 = c.copy$default$12();
                        String x$105 = c.copy$default$13();
                        Option<AbsoluteFile> x$106 = c.copy$default$14();
                        CommonOptions x$107 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$108 = c.copy$default$16();
                        boolean x$109 = c.copy$default$17();
                        return c.copy(x$94, x$95, x$96, x$93, x$97, x$98, x$99, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109);
                    }
                }).text("file or directory, in which case all *.scala files are formatted.");
                this.opt('c', "config", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final CliOptions apply(String file, CliOptions c) {
                        return this.$outer.org$scalafmt$cli$CliArgParser$$anon$$readConfigFromFile(file, c);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).text("a file path to .scalafmt.conf.");
                this.opt("config-str", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final CliOptions apply(String contents, CliOptions c) {
                        return this.$outer.org$scalafmt$cli$CliArgParser$$anon$$readConfig(contents, c);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).text("configuration defined as a string");
                this.opt("stdin", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$1, CliOptions c) {
                        boolean x$110 = true;
                        ScalafmtConfig x$111 = c.copy$default$1();
                        Set<Range> x$112 = c.copy$default$2();
                        Seq<AbsoluteFile> x$113 = c.copy$default$3();
                        Seq<String> x$114 = c.copy$default$4();
                        WriteMode x$115 = c.copy$default$5();
                        boolean x$116 = c.copy$default$6();
                        boolean x$117 = c.copy$default$8();
                        boolean x$118 = c.copy$default$9();
                        Option<Object> x$119 = c.copy$default$10();
                        boolean x$120 = c.copy$default$11();
                        Option<String> x$121 = c.copy$default$12();
                        String x$122 = c.copy$default$13();
                        Option<AbsoluteFile> x$123 = c.copy$default$14();
                        CommonOptions x$124 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$125 = c.copy$default$16();
                        boolean x$126 = c.copy$default$17();
                        return c.copy(x$111, x$112, x$113, x$114, x$115, x$116, x$110, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126);
                    }
                }).text("read from stdin and print to stdout");
                this.opt("no-stderr", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$2, CliOptions c) {
                        boolean x$127 = true;
                        ScalafmtConfig x$128 = c.copy$default$1();
                        Set<Range> x$129 = c.copy$default$2();
                        Seq<AbsoluteFile> x$130 = c.copy$default$3();
                        Seq<String> x$131 = c.copy$default$4();
                        WriteMode x$132 = c.copy$default$5();
                        boolean x$133 = c.copy$default$6();
                        boolean x$134 = c.copy$default$7();
                        boolean x$135 = c.copy$default$8();
                        boolean x$136 = c.copy$default$9();
                        Option<Object> x$137 = c.copy$default$10();
                        boolean x$138 = c.copy$default$11();
                        Option<String> x$139 = c.copy$default$12();
                        String x$140 = c.copy$default$13();
                        Option<AbsoluteFile> x$141 = c.copy$default$14();
                        CommonOptions x$142 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$143 = c.copy$default$16();
                        return c.copy(x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$127);
                    }
                }).text("don't use strerr for messages, output to stdout");
                this.opt("assume-filename", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(String filename, CliOptions c) {
                        String x$144 = filename;
                        ScalafmtConfig x$145 = c.copy$default$1();
                        Set<Range> x$146 = c.copy$default$2();
                        Seq<AbsoluteFile> x$147 = c.copy$default$3();
                        Seq<String> x$148 = c.copy$default$4();
                        WriteMode x$149 = c.copy$default$5();
                        boolean x$150 = c.copy$default$6();
                        boolean x$151 = c.copy$default$7();
                        boolean x$152 = c.copy$default$8();
                        boolean x$153 = c.copy$default$9();
                        Option<Object> x$154 = c.copy$default$10();
                        boolean x$155 = c.copy$default$11();
                        Option<String> x$156 = c.copy$default$12();
                        Option<AbsoluteFile> x$157 = c.copy$default$14();
                        CommonOptions x$158 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$159 = c.copy$default$16();
                        boolean x$160 = c.copy$default$17();
                        return c.copy(x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$144, x$157, x$158, x$159, x$160);
                    }
                }).text("when using --stdin, use --assume-filename to hint to scalafmt that the input is an .sbt file.");
                this.opt("test", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$3, CliOptions c) {
                        boolean x$161 = true;
                        ScalafmtConfig x$162 = c.copy$default$1();
                        Set<Range> x$163 = c.copy$default$2();
                        Seq<AbsoluteFile> x$164 = c.copy$default$3();
                        Seq<String> x$165 = c.copy$default$4();
                        WriteMode x$166 = c.copy$default$5();
                        boolean x$167 = c.copy$default$7();
                        boolean x$168 = c.copy$default$8();
                        boolean x$169 = c.copy$default$9();
                        Option<Object> x$170 = c.copy$default$10();
                        boolean x$171 = c.copy$default$11();
                        Option<String> x$172 = c.copy$default$12();
                        String x$173 = c.copy$default$13();
                        Option<AbsoluteFile> x$174 = c.copy$default$14();
                        CommonOptions x$175 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$176 = c.copy$default$16();
                        boolean x$177 = c.copy$default$17();
                        return c.copy(x$162, x$163, x$164, x$165, x$166, x$161, x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177);
                    }
                }).text("test for mis-formatted code, exits with status 1 on failure.");
                this.opt("migrate2hocon", Read$.MODULE$.fileRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(File file, CliOptions c) {
                        Some x$178 = new Some((Object)AbsoluteFile$.MODULE$.fromFile(file, c.common().workingDirectory()));
                        ScalafmtConfig x$179 = c.copy$default$1();
                        Set<Range> x$180 = c.copy$default$2();
                        Seq<AbsoluteFile> x$181 = c.copy$default$3();
                        Seq<String> x$182 = c.copy$default$4();
                        WriteMode x$183 = c.copy$default$5();
                        boolean x$184 = c.copy$default$6();
                        boolean x$185 = c.copy$default$7();
                        boolean x$186 = c.copy$default$8();
                        boolean x$187 = c.copy$default$9();
                        Option<Object> x$188 = c.copy$default$10();
                        boolean x$189 = c.copy$default$11();
                        Option<String> x$190 = c.copy$default$12();
                        String x$191 = c.copy$default$13();
                        CommonOptions x$192 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$193 = c.copy$default$16();
                        boolean x$194 = c.copy$default$17();
                        return c.copy(x$179, x$180, x$181, x$182, x$183, x$184, x$185, x$186, x$187, x$188, x$189, x$190, x$191, (Option<AbsoluteFile>)x$178, x$192, x$193, x$194);
                    }
                }).text("migrate .scalafmt CLI style configuration to hocon style configuration in .scalafmt.conf");
                this.opt("diff", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$4, CliOptions c) {
                        Some x$195 = new Some((Object)"master");
                        ScalafmtConfig x$196 = c.copy$default$1();
                        Set<Range> x$197 = c.copy$default$2();
                        Seq<AbsoluteFile> x$198 = c.copy$default$3();
                        Seq<String> x$199 = c.copy$default$4();
                        WriteMode x$200 = c.copy$default$5();
                        boolean x$201 = c.copy$default$6();
                        boolean x$202 = c.copy$default$7();
                        boolean x$203 = c.copy$default$8();
                        boolean x$204 = c.copy$default$9();
                        Option<Object> x$205 = c.copy$default$10();
                        boolean x$206 = c.copy$default$11();
                        String x$207 = c.copy$default$13();
                        Option<AbsoluteFile> x$208 = c.copy$default$14();
                        CommonOptions x$209 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$210 = c.copy$default$16();
                        boolean x$211 = c.copy$default$17();
                        return c.copy(x$196, x$197, x$198, x$199, x$200, x$201, x$202, x$203, x$204, x$205, x$206, (Option<String>)x$195, x$207, x$208, x$209, x$210, x$211);
                    }
                }).text("If set, only format edited files in git diff against master.");
                this.opt("diff-branch", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(String branch, CliOptions c) {
                        Some x$212 = new Some((Object)branch);
                        ScalafmtConfig x$213 = c.copy$default$1();
                        Set<Range> x$214 = c.copy$default$2();
                        Seq<AbsoluteFile> x$215 = c.copy$default$3();
                        Seq<String> x$216 = c.copy$default$4();
                        WriteMode x$217 = c.copy$default$5();
                        boolean x$218 = c.copy$default$6();
                        boolean x$219 = c.copy$default$7();
                        boolean x$220 = c.copy$default$8();
                        boolean x$221 = c.copy$default$9();
                        Option<Object> x$222 = c.copy$default$10();
                        boolean x$223 = c.copy$default$11();
                        String x$224 = c.copy$default$13();
                        Option<AbsoluteFile> x$225 = c.copy$default$14();
                        CommonOptions x$226 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$227 = c.copy$default$16();
                        boolean x$228 = c.copy$default$17();
                        return c.copy(x$213, x$214, x$215, x$216, x$217, x$218, x$219, x$220, x$221, x$222, x$223, (Option<String>)x$212, x$224, x$225, x$226, x$227, x$228);
                    }
                }).text("If set, only format edited files in git diff against provided branch.");
                this.opt("build-info", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x0$1, CliOptions x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (tuple2 != null) {
                            Predef$.MODULE$.println((Object)CliArgParser$.MODULE$.buildInfo());
                            throw scala.sys.package$.MODULE$.exit();
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }).text("prints build information");
                this.opt("quiet", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$5, CliOptions c) {
                        boolean x$229 = true;
                        ScalafmtConfig x$230 = c.copy$default$1();
                        Set<Range> x$231 = c.copy$default$2();
                        Seq<AbsoluteFile> x$232 = c.copy$default$3();
                        Seq<String> x$233 = c.copy$default$4();
                        WriteMode x$234 = c.copy$default$5();
                        boolean x$235 = c.copy$default$6();
                        boolean x$236 = c.copy$default$7();
                        boolean x$237 = c.copy$default$9();
                        Option<Object> x$238 = c.copy$default$10();
                        boolean x$239 = c.copy$default$11();
                        Option<String> x$240 = c.copy$default$12();
                        String x$241 = c.copy$default$13();
                        Option<AbsoluteFile> x$242 = c.copy$default$14();
                        CommonOptions x$243 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$244 = c.copy$default$16();
                        boolean x$245 = c.copy$default$17();
                        return c.copy(x$230, x$231, x$232, x$233, x$234, x$235, x$236, x$229, x$237, x$238, x$239, x$240, x$241, x$242, x$243, x$244, x$245);
                    }
                }).text("don't print out stuff to console.");
                this.opt("debug", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$6, CliOptions c) {
                        boolean x$246 = true;
                        ScalafmtConfig x$247 = c.copy$default$1();
                        Set<Range> x$248 = c.copy$default$2();
                        Seq<AbsoluteFile> x$249 = c.copy$default$3();
                        Seq<String> x$250 = c.copy$default$4();
                        WriteMode x$251 = c.copy$default$5();
                        boolean x$252 = c.copy$default$6();
                        boolean x$253 = c.copy$default$7();
                        boolean x$254 = c.copy$default$8();
                        Option<Object> x$255 = c.copy$default$10();
                        boolean x$256 = c.copy$default$11();
                        Option<String> x$257 = c.copy$default$12();
                        String x$258 = c.copy$default$13();
                        Option<AbsoluteFile> x$259 = c.copy$default$14();
                        CommonOptions x$260 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$261 = c.copy$default$16();
                        boolean x$262 = c.copy$default$17();
                        return c.copy(x$247, x$248, x$249, x$250, x$251, x$252, x$253, x$254, x$246, x$255, x$256, x$257, x$258, x$259, x$260, x$261, x$262);
                    }
                }).text("print out diagnostics to console.");
                this.opt("non-interactive", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$7, CliOptions c) {
                        boolean x$263 = true;
                        ScalafmtConfig x$264 = c.copy$default$1();
                        Set<Range> x$265 = c.copy$default$2();
                        Seq<AbsoluteFile> x$266 = c.copy$default$3();
                        Seq<String> x$267 = c.copy$default$4();
                        WriteMode x$268 = c.copy$default$5();
                        boolean x$269 = c.copy$default$6();
                        boolean x$270 = c.copy$default$7();
                        boolean x$271 = c.copy$default$8();
                        boolean x$272 = c.copy$default$9();
                        Option<Object> x$273 = c.copy$default$10();
                        Option<String> x$274 = c.copy$default$12();
                        String x$275 = c.copy$default$13();
                        Option<AbsoluteFile> x$276 = c.copy$default$14();
                        CommonOptions x$277 = c.copy$default$15();
                        Function1<AbsoluteFile, GitOps> x$278 = c.copy$default$16();
                        boolean x$279 = c.copy$default$17();
                        return c.copy(x$264, x$265, x$266, x$267, x$268, x$269, x$270, x$271, x$272, x$273, x$263, x$274, x$275, x$276, x$277, x$278, x$279);
                    }
                }).text("disable fancy progress bar, useful in ci or sbt plugin.");
                this.opt("range", Read$.MODULE$.tupleRead(Read$.MODULE$.intRead(), Read$.MODULE$.intRead())).hidden().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(Tuple2<Object, Object> x0$2, CliOptions x1$2) {
                        Tuple2 tuple2 = new Tuple2(x0$2, (Object)x1$2);
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            CliOptions c = (CliOptions)tuple2._2();
                            if (tuple22 != null) {
                                int to;
                                int from = tuple22._1$mcI$sp();
                                int offset = from == (to = tuple22._2$mcI$sp()) ? 0 : -1;
                                Set x$280 = (Set)c.range().$plus((Object)package$.MODULE$.Range().apply(from - 1, to + offset));
                                ScalafmtConfig x$281 = c.copy$default$1();
                                Seq<AbsoluteFile> x$282 = c.copy$default$3();
                                Seq<String> x$283 = c.copy$default$4();
                                WriteMode x$284 = c.copy$default$5();
                                boolean x$285 = c.copy$default$6();
                                boolean x$286 = c.copy$default$7();
                                boolean x$287 = c.copy$default$8();
                                boolean x$288 = c.copy$default$9();
                                Option<Object> x$289 = c.copy$default$10();
                                boolean x$290 = c.copy$default$11();
                                Option<String> x$291 = c.copy$default$12();
                                String x$292 = c.copy$default$13();
                                Option<AbsoluteFile> x$293 = c.copy$default$14();
                                CommonOptions x$294 = c.copy$default$15();
                                Function1<AbsoluteFile, GitOps> x$295 = c.copy$default$16();
                                boolean x$296 = c.copy$default$17();
                                CliOptions cliOptions = c.copy(x$281, (Set<Range>)x$280, x$282, x$283, x$284, x$285, x$286, x$287, x$288, x$289, x$290, x$291, x$292, x$293, x$294, x$295, x$296);
                                return cliOptions;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }).text("(experimental) only format line range from=to");
                this.note(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|Examples:\n               |", "\n               |Please file bugs to https://github.com/scalameta/scalafmt/issues\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CliArgParser$.MODULE$.usageExamples()})))).stripMargin());
            }
        };
    }
}

