/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.facade;

import com.ghgande.j2mod.modbus.facade.AbstractModbusMaster;
import com.ghgande.j2mod.modbus.io.AbstractModbusTransport;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransaction;
import com.ghgande.j2mod.modbus.net.AbstractSerialConnection;
import com.ghgande.j2mod.modbus.net.SerialConnection;
import com.ghgande.j2mod.modbus.util.SerialParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusSerialMaster
extends AbstractModbusMaster {
    private static final Logger logger = LoggerFactory.getLogger(ModbusSerialMaster.class);
    private AbstractSerialConnection connection;
    private int transDelay = 0;

    public ModbusSerialMaster(SerialParameters param) {
        this(param, 3000, 0);
    }

    public ModbusSerialMaster(SerialParameters param, int timeout) {
        this(param, timeout, 0);
    }

    public ModbusSerialMaster(SerialParameters param, int timeout, int transDelay) {
        try {
            this.transDelay = transDelay > -1 ? transDelay : 0;
            this.connection = new SerialConnection(param);
            this.connection.setTimeout(timeout);
            this.timeout = timeout;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public AbstractSerialConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized void connect() throws Exception {
        if (this.connection != null && !this.connection.isOpen()) {
            this.connection.open();
            this.transaction = this.connection.getModbusTransport().createTransaction();
            ((ModbusSerialTransaction)this.transaction).setTransDelayMS(this.transDelay);
            this.setTransaction(this.transaction);
        }
    }

    @Override
    public synchronized void disconnect() {
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.close();
            this.transaction = null;
            this.setTransaction(null);
        }
    }

    @Override
    public void setTimeout(int timeout) {
        super.setTimeout(timeout);
        if (this.connection != null) {
            this.connection.setTimeout(timeout);
        }
    }

    @Override
    public AbstractModbusTransport getTransport() {
        return this.connection == null ? null : this.connection.getModbusTransport();
    }
}

