/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.AbstractModbusTransport;
import com.ghgande.j2mod.modbus.io.AbstractSerialTransportListener;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.msg.ModbusMessage;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.net.AbstractModbusListener;
import com.ghgande.j2mod.modbus.net.AbstractSerialConnection;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModbusSerialTransport
extends AbstractModbusTransport {
    private static final Logger logger = LoggerFactory.getLogger(ModbusSerialTransport.class);
    static final int FRAME_START = 1000;
    static final int FRAME_END = 2000;
    private AbstractSerialConnection commPort;
    boolean echo = false;
    private final Set<AbstractSerialTransportListener> listeners = Collections.synchronizedSet(new HashSet());

    @Override
    public ModbusTransaction createTransaction() {
        ModbusSerialTransaction transaction = new ModbusSerialTransaction();
        transaction.setTransport(this);
        return transaction;
    }

    @Override
    public void writeResponse(ModbusResponse msg) throws ModbusIOException {
        if (msg.getAuxiliaryType().equals((Object)ModbusResponse.AuxiliaryMessageTypes.UNIT_ID_MISSMATCH)) {
            logger.debug("Ignoring response not meant for us");
        } else {
            this.waitBetweenFrames();
            this.writeMessage(msg);
        }
    }

    @Override
    public void writeRequest(ModbusRequest msg) throws ModbusIOException {
        this.writeMessage(msg);
    }

    private void writeMessage(ModbusMessage msg) throws ModbusIOException {
        this.open();
        this.notifyListenersBeforeWrite(msg);
        this.writeMessageOut(msg);
        long startTime = System.nanoTime();
        double bytesPerSec = this.commPort.getBaudRate() / ((this.commPort.getNumDataBits() == 0 ? 8 : this.commPort.getNumDataBits()) + (this.commPort.getNumStopBits() == 0 ? 1 : this.commPort.getNumStopBits()) + (this.commPort.getParity() == 0 ? 0 : 1));
        double delay = 1.0E9 * (double)msg.getOutputLength() / bytesPerSec;
        double delayMilliSeconds = Math.floor(delay / 1000000.0);
        double delayNanoSeconds = delay % 1000000.0;
        try {
            if (delayMilliSeconds == 0.0) {
                int priority = Thread.currentThread().getPriority();
                Thread.currentThread().setPriority(1);
                long end = startTime + (long)((int)(delayNanoSeconds * 1.3));
                while (System.nanoTime() < end) {
                }
                Thread.currentThread().setPriority(priority);
            } else {
                Thread.sleep((int)(delayMilliSeconds * 1.4), (int)delayNanoSeconds);
            }
        }
        catch (Exception e) {
            logger.debug("nothing to do");
        }
        this.notifyListenersAfterWrite(msg);
    }

    @Override
    public ModbusRequest readRequest(AbstractModbusListener listener) throws ModbusIOException {
        this.open();
        this.notifyListenersBeforeRequest();
        ModbusRequest req = this.readRequestIn(listener);
        this.notifyListenersAfterRequest(req);
        return req;
    }

    @Override
    public ModbusResponse readResponse() throws ModbusIOException {
        this.notifyListenersBeforeResponse();
        ModbusResponse res = this.readResponseIn();
        this.notifyListenersAfterResponse(res);
        return res;
    }

    private void open() throws ModbusIOException {
        if (this.commPort != null && !this.commPort.isOpen()) {
            this.setTimeout(this.timeout);
            try {
                this.commPort.open();
            }
            catch (IOException e) {
                throw new ModbusIOException(String.format("Cannot open port %s - %s", this.commPort.getDescriptivePortName(), e.getMessage()));
            }
        }
    }

    @Override
    public void setTimeout(int time) {
        super.setTimeout(time);
        if (this.commPort != null) {
            this.commPort.setComPortTimeouts(256, this.timeout, this.timeout);
        }
    }

    protected abstract void writeMessageOut(ModbusMessage var1) throws ModbusIOException;

    protected abstract ModbusRequest readRequestIn(AbstractModbusListener var1) throws ModbusIOException;

    protected abstract ModbusResponse readResponseIn() throws ModbusIOException;

    public void addListener(AbstractSerialTransportListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(AbstractSerialTransportListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersBeforeRequest() {
        Set<AbstractSerialTransportListener> set = this.listeners;
        synchronized (set) {
            for (AbstractSerialTransportListener listener : this.listeners) {
                listener.beforeRequestRead(this.commPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersAfterRequest(ModbusRequest req) {
        Set<AbstractSerialTransportListener> set = this.listeners;
        synchronized (set) {
            for (AbstractSerialTransportListener listener : this.listeners) {
                listener.afterRequestRead(this.commPort, req);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersBeforeResponse() {
        Set<AbstractSerialTransportListener> set = this.listeners;
        synchronized (set) {
            for (AbstractSerialTransportListener listener : this.listeners) {
                listener.beforeResponseRead(this.commPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersAfterResponse(ModbusResponse res) {
        Set<AbstractSerialTransportListener> set = this.listeners;
        synchronized (set) {
            for (AbstractSerialTransportListener listener : this.listeners) {
                listener.afterResponseRead(this.commPort, res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersBeforeWrite(ModbusMessage msg) {
        Set<AbstractSerialTransportListener> set = this.listeners;
        synchronized (set) {
            for (AbstractSerialTransportListener listener : this.listeners) {
                listener.beforeMessageWrite(this.commPort, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersAfterWrite(ModbusMessage msg) {
        Set<AbstractSerialTransportListener> set = this.listeners;
        synchronized (set) {
            for (AbstractSerialTransportListener listener : this.listeners) {
                listener.afterMessageWrite(this.commPort, msg);
            }
        }
    }

    public void setCommPort(AbstractSerialConnection cp) throws IOException {
        this.commPort = cp;
        this.setTimeout(this.timeout);
    }

    public AbstractSerialConnection getCommPort() {
        return this.commPort;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public void setEcho(boolean b) {
        this.echo = b;
    }

    public void setBaudRate(int baud) {
        this.commPort.setBaudRate(baud);
        logger.debug("baud rate is now {}", (Object)this.commPort.getBaudRate());
    }

    void readEcho(int len) throws IOException {
        byte[] echoBuf = new byte[len];
        int echoLen = this.commPort.readBytes(echoBuf, len);
        if (logger.isDebugEnabled()) {
            logger.debug("Echo: {}", (Object)ModbusUtil.toHex(echoBuf, 0, echoLen));
        }
        if (echoLen != len) {
            logger.debug("Error: Transmit echo not received");
            throw new IOException("Echo not received");
        }
    }

    protected int readByte() throws IOException {
        if (this.commPort != null && this.commPort.isOpen()) {
            byte[] buffer = new byte[1];
            int cnt = this.commPort.readBytes(buffer, 1L);
            if (cnt != 1) {
                throw new IOException("Cannot read from serial port");
            }
            return buffer[0] & 0xFF;
        }
        throw new IOException("Comm port is not valid or not open");
    }

    void readBytes(byte[] buffer, long bytesToRead) throws IOException {
        if (this.commPort != null && this.commPort.isOpen()) {
            int cnt = this.commPort.readBytes(buffer, bytesToRead);
            if ((long)cnt != bytesToRead) {
                throw new IOException("Cannot read from serial port - truncated");
            }
        } else {
            throw new IOException("Comm port is not valid or not open");
        }
    }

    final int writeBytes(byte[] buffer, long bytesToWrite) throws IOException {
        if (this.commPort != null && this.commPort.isOpen()) {
            return this.commPort.writeBytes(buffer, bytesToWrite);
        }
        throw new IOException("Comm port is not valid or not open");
    }

    int readAsciiByte() throws IOException {
        if (this.commPort != null && this.commPort.isOpen()) {
            byte[] buffer = new byte[1];
            int cnt = this.commPort.readBytes(buffer, 1L);
            if (cnt != 1) {
                throw new IOException("Cannot read from serial port");
            }
            if (buffer[0] == 58) {
                return 1000;
            }
            if (buffer[0] == 13 || buffer[0] == 10) {
                return 2000;
            }
            logger.debug("Read From buffer: " + buffer[0] + " (" + String.format("%02X", buffer[0]) + ")");
            byte firstValue = buffer[0];
            cnt = this.commPort.readBytes(buffer, 1L);
            if (cnt != 1) {
                throw new IOException("Cannot read from serial port");
            }
            logger.debug("Read From buffer: " + buffer[0] + " (" + String.format("%02X", buffer[0]) + ")");
            int combinedValue = (Character.digit(firstValue, 16) << 4) + Character.digit(buffer[0], 16);
            logger.debug("Returning combined value of: " + String.format("%02X", combinedValue));
            return combinedValue;
        }
        throw new IOException("Comm port is not valid or not open");
    }

    final int writeAsciiByte(int value) throws IOException {
        if (this.commPort != null && this.commPort.isOpen()) {
            byte[] buffer;
            if (value == 1000) {
                buffer = new byte[]{58};
                logger.debug("Wrote FRAME_START");
            } else if (value == 2000) {
                buffer = new byte[]{13, 10};
                logger.debug("Wrote FRAME_END");
            } else {
                buffer = ModbusUtil.toHex(value);
                if (logger.isDebugEnabled()) {
                    logger.debug("Wrote byte {}={}", (Object)value, (Object)ModbusUtil.toHex(value));
                }
            }
            if (buffer != null) {
                return this.commPort.writeBytes(buffer, buffer.length);
            }
            throw new IOException("Message to send is empty");
        }
        throw new IOException("Comm port is not valid or not open");
    }

    int writeAsciiBytes(byte[] buffer, long bytesToWrite) throws IOException {
        if (this.commPort != null && this.commPort.isOpen()) {
            int cnt = 0;
            int i = 0;
            while ((long)i < bytesToWrite) {
                if (this.writeAsciiByte(buffer[i]) != 2) {
                    return cnt;
                }
                ++cnt;
                ++i;
            }
            return cnt;
        }
        throw new IOException("Comm port is not valid or not open");
    }

    void clearInput() throws IOException {
        if (this.commPort.bytesAvailable() > 0) {
            int len = this.commPort.bytesAvailable();
            byte[] buf = new byte[len];
            this.readBytes(buf, len);
            if (logger.isDebugEnabled()) {
                logger.debug("Clear input: {}", (Object)ModbusUtil.toHex(buf, 0, len));
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.commPort.close();
    }

    private void waitBetweenFrames() {
        this.waitBetweenFrames(0, 0L);
    }

    void waitBetweenFrames(int transDelayMS, long lastTransactionTimestamp) {
        if (transDelayMS > 0) {
            ModbusUtil.sleep(transDelayMS);
        } else {
            long gapSinceLastMessage;
            int delay = (int)(4.0 * (double)(this.commPort.getNumDataBits() + this.commPort.getNumStopBits()) * 1000.0 / (double)this.commPort.getBaudRate());
            if (delay > 2) {
                delay = 2;
            }
            if ((long)delay > (gapSinceLastMessage = System.currentTimeMillis() - lastTransactionTimestamp)) {
                ModbusUtil.sleep((long)delay - gapSinceLastMessage);
            }
        }
    }
}

