/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.net.AbstractUDPTerminal;
import com.ghgande.j2mod.modbus.net.UDPMasterConnection;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusUDPTransaction
extends ModbusTransaction {
    private static final Logger logger = LoggerFactory.getLogger(ModbusUDPTransaction.class);
    private AbstractUDPTerminal terminal;
    private final Object MUTEX = new Object();

    public ModbusUDPTransaction() {
    }

    public ModbusUDPTransaction(ModbusRequest request) {
        this.setRequest(request);
    }

    public ModbusUDPTransaction(AbstractUDPTerminal terminal) {
        this.setTerminal(terminal);
    }

    public ModbusUDPTransaction(UDPMasterConnection con) {
        this.setTerminal(con.getTerminal());
    }

    public void setTerminal(AbstractUDPTerminal terminal) {
        this.terminal = terminal;
        if (terminal.isActive()) {
            this.transport = terminal.getTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ModbusIOException, ModbusSlaveException, ModbusException {
        this.assertExecutable();
        if (!this.terminal.isActive()) {
            try {
                this.terminal.activate();
                this.transport = this.terminal.getTransport();
            }
            catch (Exception ex) {
                logger.debug("Terminal activation failed.", (Throwable)ex);
                throw new ModbusIOException("Activation failed");
            }
        }
        int retryCount = 0;
        while (retryCount <= this.retries) {
            try {
                Object object = this.MUTEX;
                synchronized (object) {
                    this.transport.writeRequest(this.request);
                    this.response = this.transport.readResponse();
                    break;
                }
            }
            catch (ModbusIOException ex) {
                if (++retryCount > this.retries) {
                    logger.error("Cannot send UDP message", (Throwable)ex);
                    continue;
                }
                ModbusUtil.sleep(this.getRandomSleepTime(retryCount));
            }
        }
        if (this.response instanceof ExceptionResponse) {
            throw new ModbusSlaveException(((ExceptionResponse)this.response).getExceptionCode());
        }
        this.incrementTransactionID();
    }

    private void assertExecutable() throws ModbusException {
        if (this.request == null || this.terminal == null) {
            throw new ModbusException("Assertion failed, transaction not executable");
        }
    }

    private void incrementTransactionID() {
        if (this.isCheckingValidity()) {
            transactionID = transactionID >= Short.MAX_VALUE ? 0 : ++transactionID;
        }
        this.request.setTransactionID(this.getTransactionID());
    }
}

