/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ReportSlaveIDResponse
extends ModbusResponse {
    int m_length;
    byte[] m_data;
    int m_status;
    int m_slaveId;

    public ReportSlaveIDResponse() {
        this.setFunctionCode(17);
    }

    public int getSlaveID() {
        return this.m_slaveId;
    }

    public void setSlaveID(int unitID) {
        this.m_slaveId = unitID;
    }

    public boolean getStatus() {
        return this.m_status != 0;
    }

    public void setStatus(boolean b) {
        this.m_status = b ? 255 : 0;
    }

    public byte[] getData() {
        byte[] result = new byte[this.m_length - 2];
        System.arraycopy(this.m_data, 0, result, 0, this.m_length - 2);
        return result;
    }

    public void setData(byte[] data) {
        if (data == null) {
            this.m_length = 2;
            this.m_data = new byte[0];
            return;
        }
        if (data.length > 249) {
            throw new IllegalArgumentException("data length limit exceeded");
        }
        this.m_length = data.length + 2;
        this.m_data = new byte[data.length];
        System.arraycopy(data, 0, this.m_data, 0, data.length);
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_length = din.readUnsignedByte();
        if (this.m_length < 2 || this.m_length > 255) {
            return;
        }
        this.m_slaveId = din.readUnsignedByte();
        this.m_status = din.readUnsignedByte();
        this.m_data = new byte[this.m_length - 2];
        if (this.m_length > 2) {
            din.readFully(this.m_data, 0, this.m_length - 2);
        }
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[3 + this.m_length];
        int offset = 0;
        result[offset++] = (byte)(this.m_length + 2);
        result[offset++] = (byte)this.m_slaveId;
        result[offset++] = (byte)this.m_status;
        if (this.m_length > 0) {
            System.arraycopy(this.m_data, 0, result, offset, this.m_length - 2);
        }
        return result;
    }
}

