/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.AbstractModbusTransport;
import com.ghgande.j2mod.modbus.net.AbstractModbusListener;
import com.ghgande.j2mod.modbus.net.TCPSlaveConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPConnectionHandler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TCPConnectionHandler.class);
    private TCPSlaveConnection connection;
    private AbstractModbusTransport transport;
    private AbstractModbusListener listener;

    public TCPConnectionHandler(AbstractModbusListener listener, TCPSlaveConnection connection) {
        this.listener = listener;
        this.connection = connection;
        this.transport = this.connection.getModbusTransport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            do {
                this.listener.handleRequest(this.transport, this.listener);
            } while (!Thread.currentThread().isInterrupted());
        }
        catch (ModbusIOException ex) {
            if (!ex.isEOF()) {
                logger.debug(ex.getMessage());
            }
        }
        finally {
            this.connection.close();
        }
    }
}

