/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.util;

import com.ghgande.j2mod.modbus.util.ModbusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitVector {
    private static final Logger logger = LoggerFactory.getLogger(BitVector.class);
    private static final int[] ODD_OFFSETS = new int[]{-1, -3, -5, -7};
    private static final int[] STRAIGHT_OFFSETS = new int[]{7, 5, 3, 1};
    private int size;
    private byte[] data;
    private boolean MSBAccess = false;

    public BitVector(int size) {
        this.size = size;
        size = size % 8 > 0 ? size / 8 + 1 : (size /= 8);
        this.data = new byte[size];
    }

    public static BitVector createBitVector(byte[] data, int size) {
        BitVector bv = new BitVector(data.length * 8);
        bv.setBytes(data);
        bv.size = size;
        return bv;
    }

    public static BitVector createBitVector(byte[] data) {
        BitVector bv = new BitVector(data.length * 8);
        bv.setBytes(data);
        return bv;
    }

    public static void main(String[] args) {
        BitVector test = new BitVector(24);
        logger.debug(test.isLSBAccess() + "");
        test.setBit(7, true);
        logger.debug(test.getBit(7) + "");
        test.toggleAccess(true);
        logger.debug(test.getBit(7) + "");
        test.toggleAccess(true);
        test.setBit(6, true);
        test.setBit(3, true);
        test.setBit(2, true);
        test.setBit(0, true);
        test.setBit(8, true);
        test.setBit(10, true);
        logger.debug(test.toString());
        test.toggleAccess(true);
        logger.debug(test.toString());
        test.toggleAccess(true);
        logger.debug(test.toString());
        logger.debug(ModbusUtil.toHex(test.getBytes()));
    }

    public void toggleAccess(boolean b) {
        this.MSBAccess = !this.MSBAccess;
    }

    public boolean isLSBAccess() {
        return !this.MSBAccess;
    }

    public boolean isMSBAccess() {
        return this.MSBAccess;
    }

    public final synchronized byte[] getBytes() {
        byte[] dest = new byte[this.data.length];
        System.arraycopy(this.data, 0, dest, 0, dest.length);
        return dest;
    }

    public void setBytes(byte[] data) {
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public void setBytes(byte[] data, int size) {
        System.arraycopy(data, 0, this.data, 0, data.length);
        this.size = size;
    }

    public boolean getBit(int index) throws IndexOutOfBoundsException {
        index = this.translateIndex(index);
        logger.debug("Get bit #{}", (Object)index);
        return (this.data[this.byteIndex(index)] & 1 << this.bitIndex(index)) != 0;
    }

    public void setBit(int index, boolean b) throws IndexOutOfBoundsException {
        index = this.translateIndex(index);
        logger.debug("Set bit #{}", (Object)index);
        int value = b ? 1 : 0;
        int byteNum = this.byteIndex(index);
        int bitNum = this.bitIndex(index);
        this.data[byteNum] = (byte)(this.data[byteNum] & ~(1 << bitNum) | (value & 1) << bitNum);
    }

    public int size() {
        return this.size;
    }

    public void forceSize(int size) {
        if (size > this.data.length * 8) {
            throw new IllegalArgumentException("Size exceeds byte[] store");
        }
        this.size = size;
    }

    public int byteSize() {
        return this.data.length;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            int numberOfBitsToPrint = 8;
            int remainingBits = this.size - i * 8;
            if (remainingBits < 8) {
                numberOfBitsToPrint = remainingBits;
            }
            sbuf.append(String.format("%" + numberOfBitsToPrint + "s", Integer.toBinaryString(this.data[i] & 0xFF)).replace(' ', '0'));
            sbuf.append(" ");
        }
        return sbuf.toString();
    }

    private int byteIndex(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.data.length * 8) {
            throw new IndexOutOfBoundsException();
        }
        return index / 8;
    }

    private int bitIndex(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.data.length * 8) {
            throw new IndexOutOfBoundsException();
        }
        return index % 8;
    }

    private int translateIndex(int idx) {
        if (this.MSBAccess) {
            int mod4 = idx % 4;
            int div4 = idx / 4;
            if (div4 % 2 != 0) {
                return idx + ODD_OFFSETS[mod4];
            }
            return idx + STRAIGHT_OFFSETS[mod4];
        }
        return idx;
    }
}

