/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.winium;

import java.net.URL;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.winium.DesktopOptions;
import org.openqa.selenium.winium.SilverlightOptions;
import org.openqa.selenium.winium.StoreAppsOptions;
import org.openqa.selenium.winium.WiniumDriverCommandExecutor;
import org.openqa.selenium.winium.WiniumDriverService;
import org.openqa.selenium.winium.WiniumOptions;

public class WiniumDriver
extends RemoteWebDriver {
    public WiniumDriver(WiniumOptions options) {
        this(WiniumDriver.createDefaultService(options.getClass()), options);
    }

    public WiniumDriver(WiniumDriverService service, WiniumOptions options) {
        super((CommandExecutor)new WiniumDriverCommandExecutor(service), options.toCapabilities());
    }

    public WiniumDriver(URL remoteAddress, WiniumOptions options) {
        super((CommandExecutor)new WiniumDriverCommandExecutor(remoteAddress), options.toCapabilities());
    }

    private static WiniumDriverService createDefaultService(Class<? extends WiniumOptions> optionsType) {
        if (optionsType == DesktopOptions.class) {
            return WiniumDriverService.createDesktopService();
        }
        if (optionsType == StoreAppsOptions.class) {
            return WiniumDriverService.createStoreAppsService();
        }
        if (optionsType == SilverlightOptions.class) {
            return WiniumDriverService.createSilverlightService();
        }
        throw new IllegalArgumentException("Option type must be type of DesktopOptions, StoreAppsOptions or SilverlightOptions");
    }
}

