/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class AutoFocusManager {
    private final Camera mCamera;
    @Nullable
    private final FocusMoveCallback mCallback;
    @Nullable
    private FocusManager mFocusManager;
    private final Handler mHandler;

    public AutoFocusManager(Camera camera, @Nullable FocusMoveCallback focusMoveCallback) {
        AutoFocusManager autoFocusManager = this;
        this.mCamera = camera;
        autoFocusManager.mCallback = focusMoveCallback;
        autoFocusManager.mHandler = new Handler(Looper.myLooper());
    }

    private boolean isCameraFocusContinuous() {
        String string = ((AutoFocusManager)((Object)string)).mCamera.getParameters().getFocusMode();
        return "continuous-picture".equals(string) || "continuous-video".equals(string) || "edof".equals(string);
    }

    private boolean isCameraFocusManual() {
        String string = ((AutoFocusManager)((Object)string)).mCamera.getParameters().getFocusMode();
        return "auto".equals(string) || "macro".equals(string);
    }

    public void start() {
        AutoFocusManager autoFocusManager;
        FocusManager focusManager = autoFocusManager.mFocusManager;
        if (focusManager != null) {
            focusManager.stop();
            autoFocusManager.mFocusManager = null;
        }
        if (autoFocusManager.isCameraFocusContinuous()) {
            AutoFocusManagerImpl autoFocusManagerImpl;
            focusManager = autoFocusManagerImpl;
            AutoFocusManager autoFocusManager2 = autoFocusManager;
            AutoFocusManager autoFocusManager3 = autoFocusManager;
            autoFocusManager = autoFocusManager3.mCamera;
            FocusMoveCallback focusMoveCallback = autoFocusManager3.mCallback;
            Handler handler = autoFocusManager3.mHandler;
            ((AutoFocusManagerImpl)focusManager)((Camera)autoFocusManager, focusMoveCallback, handler);
            autoFocusManager2.mFocusManager = focusManager;
            autoFocusManagerImpl.start();
        } else if (autoFocusManager.isCameraFocusManual()) {
            ManualFocusManagerImpl manualFocusManagerImpl;
            focusManager = manualFocusManagerImpl;
            AutoFocusManager autoFocusManager4 = autoFocusManager;
            AutoFocusManager autoFocusManager5 = autoFocusManager;
            autoFocusManager = autoFocusManager5.mCamera;
            FocusMoveCallback focusMoveCallback = autoFocusManager5.mCallback;
            Handler handler = autoFocusManager5.mHandler;
            ((ManualFocusManagerImpl)focusManager)((Camera)autoFocusManager, focusMoveCallback, handler);
            autoFocusManager4.mFocusManager = focusManager;
            manualFocusManagerImpl.start();
        } else {
            Log.d((String)"AutoFocusManager", (String)"Focus is fixed. Ignore");
        }
    }

    public void stop() {
        FocusManager focusManager = this.mFocusManager;
        if (focusManager != null) {
            focusManager.stop();
            this.mFocusManager = null;
        }
    }

    public void requestFocus() {
        FocusManager focusManager = ((AutoFocusManager)((Object)focusManager)).mFocusManager;
        if (focusManager != null) {
            focusManager.requestFocus();
        }
    }

    private static class AutoFocusManagerImpl
    implements FocusManager {
        private final Camera mCamera;
        @Nullable
        private final FocusMoveCallback mCallback;
        private final Handler mHandler;
        private boolean mCameraMoving;
        private final Runnable mResetFocusRunnable;

        public AutoFocusManagerImpl(Camera camera2, @Nullable FocusMoveCallback focusMoveCallback, Handler handler) {
            AutoFocusManagerImpl autoFocusManagerImpl = this;
            autoFocusManagerImpl.mResetFocusRunnable = () -> {
                try {
                    AutoFocusManagerImpl autoFocusManagerImpl = this;
                    autoFocusManagerImpl.resumeAutoFocus();
                    autoFocusManagerImpl.restartCounter(1000);
                }
                catch (Exception exception) {}
            };
            this.mCamera = camera2;
            this.mCallback = focusMoveCallback;
            this.mHandler = handler;
            if (focusMoveCallback != null) {
                camera2.setAutoFocusMoveCallback((bl, camera) -> {
                    this.mCallback.onAutoFocusMoving(bl, camera);
                    this.mCameraMoving = bl;
                });
            }
        }

        private void resumeAutoFocus() {
            this.cancelAutoFocusSafe();
        }

        private void restartCounter(int n) {
            ((AutoFocusManagerImpl)((Object)runnable)).mHandler.removeCallbacks(((AutoFocusManagerImpl)((Object)runnable)).mResetFocusRunnable);
            if (n == 0) {
                ((AutoFocusManagerImpl)((Object)runnable)).mHandler.post(((AutoFocusManagerImpl)((Object)runnable)).mResetFocusRunnable);
            } else {
                Runnable runnable = ((AutoFocusManagerImpl)((Object)runnable)).mResetFocusRunnable;
                long l = n;
                ((AutoFocusManagerImpl)((Object)runnable)).mHandler.postDelayed(runnable, l);
            }
        }

        private void cancelAutoFocusSafe() {
            try {
                this.mCamera.cancelAutoFocus();
            }
            catch (RuntimeException runtimeException) {}
        }

        @Override
        public void start() {
            AutoFocusManagerImpl autoFocusManagerImpl = this;
            autoFocusManagerImpl.resumeAutoFocus();
            autoFocusManagerImpl.restartCounter(1000);
        }

        @Override
        public void stop() {
            this.mHandler.removeCallbacks(this.mResetFocusRunnable);
        }

        @Override
        public void requestFocus() {
            if (!this.mCameraMoving) {
                AutoFocusManagerImpl autoFocusManagerImpl = this;
                autoFocusManagerImpl.cancelAutoFocusSafe();
                autoFocusManagerImpl.restartCounter(1000);
            }
        }
    }

    private static class ManualFocusManagerImpl
    implements FocusManager {
        private static boolean sFocusCompleteWorking;
        private final Camera mCamera;
        @Nullable
        private final FocusMoveCallback mCallback;
        private final Handler mHandler;
        private boolean mIsFocusMoving;
        private final Runnable mRequestFocusRunnable;
        private final Camera.AutoFocusCallback mAutoFocusCallback;

        public ManualFocusManagerImpl(Camera camera2, @Nullable FocusMoveCallback focusMoveCallback, Handler handler) {
            Camera.AutoFocusCallback autoFocusCallback;
            Runnable runnable;
            Object object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    block5: {
                        1 v0 = manualFocusManagerImpl2;
                        1 v1 = v0;
                        ManualFocusManagerImpl manualFocusManagerImpl = v0.this;
                        manualFocusManagerImpl.mCamera.autoFocus(manualFocusManagerImpl.mAutoFocusCallback);
                        manualFocusManagerImpl = v1.this;
                        manualFocusManagerImpl.mIsFocusMoving = true;
                        FocusMoveCallback focusMoveCallback = manualFocusManagerImpl.mCallback;
                        if (focusMoveCallback == null) break block5;
                        boolean bl = true;
                        try {
                            focusMoveCallback.onAutoFocusMoving(bl, manualFocusManagerImpl.mCamera);
                        }
                        catch (Exception exception) {
                            ManualFocusManagerImpl manualFocusManagerImpl2 = manualFocusManagerImpl2.this;
                            manualFocusManagerImpl2.mIsFocusMoving = false;
                            FocusMoveCallback focusMoveCallback2 = manualFocusManagerImpl2.mCallback;
                            if (focusMoveCallback2 == null) break block5;
                            focusMoveCallback2.onAutoFocusMoving(false, manualFocusManagerImpl2.mCamera);
                        }
                    }
                }
            };
            this.mRequestFocusRunnable = object;
            object = autoFocusCallback;
            autoFocusCallback = new Camera.AutoFocusCallback(){

                /*
                 * WARNING - void declaration
                 */
                public void onAutoFocus(boolean bl, Camera camera) {
                    void var1_4;
                    ManualFocusManagerImpl manualFocusManagerImpl;
                    FocusMoveCallback focusMoveCallback = mCallback;
                    if (focusMoveCallback != null) {
                        void var2_5;
                        focusMoveCallback.onAutoFocusComplete(bl, (Camera)var2_5);
                    }
                    manualFocusManagerImpl = manualFocusManagerImpl.this;
                    mIsFocusMoving = false;
                    if (!sFocusCompleteWorking) {
                        sFocusCompleteWorking = true;
                    }
                    if (bl) {
                        int n = 3000;
                    } else {
                        int n = 500;
                    }
                    manualFocusManagerImpl.restartCounter((int)var1_4);
                }
            };
            this.mAutoFocusCallback = object;
            this.mCamera = camera2;
            this.mCallback = focusMoveCallback;
            this.mHandler = handler;
            if (focusMoveCallback != null) {
                camera2.setAutoFocusMoveCallback((bl, camera) -> this.mCallback.onAutoFocusMoving(bl, camera));
            }
        }

        private void restartCounter(int n) {
            ((ManualFocusManagerImpl)((Object)runnable)).mHandler.removeCallbacks(((ManualFocusManagerImpl)((Object)runnable)).mRequestFocusRunnable);
            if (n == 0) {
                ((ManualFocusManagerImpl)((Object)runnable)).mHandler.post(((ManualFocusManagerImpl)((Object)runnable)).mRequestFocusRunnable);
            } else {
                Runnable runnable = ((ManualFocusManagerImpl)((Object)runnable)).mRequestFocusRunnable;
                long l = n;
                ((ManualFocusManagerImpl)((Object)runnable)).mHandler.postDelayed(runnable, l);
            }
        }

        private void cancelAutoFocusSafe() {
            try {
                this.mCamera.cancelAutoFocus();
            }
            catch (RuntimeException runtimeException) {}
        }

        @Override
        public void start() {
            ManualFocusManagerImpl manualFocusManagerImpl = this;
            manualFocusManagerImpl.cancelAutoFocusSafe();
            manualFocusManagerImpl.restartCounter(500);
        }

        @Override
        public void stop() {
            ManualFocusManagerImpl manualFocusManagerImpl = this;
            manualFocusManagerImpl.mHandler.removeCallbacks(this.mRequestFocusRunnable);
            manualFocusManagerImpl.cancelAutoFocusSafe();
        }

        @Override
        public void requestFocus() {
            if (!this.mIsFocusMoving || !sFocusCompleteWorking) {
                ManualFocusManagerImpl manualFocusManagerImpl = this;
                manualFocusManagerImpl.cancelAutoFocusSafe();
                manualFocusManagerImpl.restartCounter(0);
            }
        }
    }

    private static interface FocusManager {
        public void start();

        public void stop();

        public void requestFocus();
    }

    public static interface FocusMoveCallback {
        public void onAutoFocusMoving(boolean var1, Camera var2);

        public void onAutoFocusComplete(boolean var1, Camera var2);
    }
}

