/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera;

import android.hardware.Camera;
import androidx.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class CameraConfigurationUtils {
    private static final List<String> FOCUS_LIST = Arrays.asList("continuous-picture", "auto", "macro", "edof");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void setFlashLight(Camera camera, boolean bl) {
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedFlashModes();
        if (list != null) {
            if (bl) {
                if (list.contains("torch")) {
                    parameters.setFlashMode("torch");
                } else {
                    if (!list.contains("on")) return;
                    parameters.setFlashMode("on");
                }
            } else {
                parameters.setFlashMode("off");
            }
        }
        CameraConfigurationUtils.setBestExposure(parameters, bl);
        camera.setParameters(parameters);
    }

    public static void initAutoFocus(Camera.Parameters parameters) {
        CameraConfigurationUtils.initAutoFocus(parameters, true);
    }

    public static void initAutoFocus(Camera.Parameters parameters, boolean bl) {
        ArrayList<String> arrayList;
        List list = parameters.getSupportedFocusModes();
        if (list == null) {
            return;
        }
        Object object = arrayList;
        arrayList = new ArrayList<String>(FOCUS_LIST);
        if (!bl) {
            ArrayList<String> arrayList2 = object;
            arrayList2.remove("continuous-picture");
            arrayList2.add("continuous-picture");
        }
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (!list.contains(string)) continue;
            parameters.setFocusMode(string);
            break;
        }
    }

    public static void initWhiteBalance(Camera.Parameters parameters) {
        List list = parameters.getSupportedWhiteBalance();
        if (list != null && list.contains("auto")) {
            parameters.setWhiteBalance("auto");
        }
    }

    public static void setBestExposure(Camera.Parameters parameters, boolean bl) {
    }

    public static void setMetering(Camera.Parameters parameters) {
    }
}

