/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera;

import android.hardware.Camera;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import paycardscanner.camera.BlockingOperationException;
import paycardscanner.camera.OrientationHelper;
import paycardscanner.utils.Size;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class CameraUtils {
    public static final NativeSupportedSize CAMERA_RESOLUTION = NativeSupportedSize.RESOLUTION_1280_X_720;
    private static NativeSupportedSize sBestCameraPreviewSize;

    public static boolean isCameraSupported() throws BlockingOperationException {
        NativeSupportedSize nativeSupportedSize = sBestCameraPreviewSize;
        if (nativeSupportedSize != null) {
            return nativeSupportedSize != NativeSupportedSize.RESOLUTION_NO_CAMERA;
        }
        throw new BlockingOperationException();
    }

    @NonNull
    public static NativeSupportedSize findBestCameraSupportedSize(Iterable<Camera.Size> object) {
        NativeSupportedSize nativeSupportedSize = NativeSupportedSize.RESOLUTION_NO_CAMERA;
        if (object == null) {
            return nativeSupportedSize;
        }
        object = object.iterator();
        block0: while (object.hasNext()) {
            Camera.Size size = (Camera.Size)object.next();
            for (NativeSupportedSize nativeSupportedSize2 : NativeSupportedSize.values()) {
                Size size2 = nativeSupportedSize2.size;
                if (size.width != size2.width || size.height != size2.height) continue;
                if (nativeSupportedSize2.compareTo(nativeSupportedSize) >= 0) continue block0;
                nativeSupportedSize = nativeSupportedSize2;
                continue block0;
            }
        }
        return nativeSupportedSize;
    }

    @Nullable
    public static Camera.CameraInfo getBackCameraInfo() {
        Camera.CameraInfo cameraInfo;
        int n = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < n; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo2);
            if (cameraInfo2.facing != 0) continue;
            return cameraInfo2;
        }
        return null;
    }

    public static int getBackCameraSensorOrientation() {
        Camera.CameraInfo cameraInfo = CameraUtils.getBackCameraInfo();
        return cameraInfo == null ? 0 : cameraInfo.orientation;
    }

    public static int getBackCameraDataRotation(Display display) {
        return CameraUtils.getCameraDataRotation(display, CameraUtils.getBackCameraInfo());
    }

    private static int getCameraDataRotation(Display display, @Nullable Camera.CameraInfo cameraInfo) {
        int n = OrientationHelper.getDisplayRotationDegrees(display);
        if (cameraInfo == null) {
            return 0;
        }
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        int n2 = cameraInfo2.orientation;
        boolean bl = cameraInfo2.facing == 1;
        return OrientationHelper.getCameraRotationToNatural(n, n2, bl);
    }

    public static final class NativeSupportedSize
    extends Enum<NativeSupportedSize> {
        public static final /* enum */ NativeSupportedSize RESOLUTION_1280_X_720;
        public static final /* enum */ NativeSupportedSize RESOLUTION_NO_CAMERA;
        private static final /* synthetic */ NativeSupportedSize[] $VALUES;
        public final Size size;

        public static NativeSupportedSize[] values() {
            return (NativeSupportedSize[])$VALUES.clone();
        }

        public static NativeSupportedSize valueOf(String string) {
            return Enum.valueOf(NativeSupportedSize.class, string);
        }

        private NativeSupportedSize(int n2, int n3) {
            Size size;
            Object object = size;
            size = new Size(n2, n3);
            v1.size = object;
        }

        static {
            NativeSupportedSize nativeSupportedSize;
            NativeSupportedSize nativeSupportedSize2;
            NativeSupportedSize nativeSupportedSize3 = nativeSupportedSize2;
            RESOLUTION_1280_X_720 = new NativeSupportedSize(1280, 720);
            NativeSupportedSize nativeSupportedSize4 = nativeSupportedSize;
            RESOLUTION_NO_CAMERA = new NativeSupportedSize(-1, -1);
            $VALUES = new NativeSupportedSize[]{nativeSupportedSize3, nativeSupportedSize4};
        }
    }
}

