/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import androidx.annotation.MainThread;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paycardscanner.camera.CameraUtils;
import paycardscanner.camera.CardScanManager;
import paycardscanner.camera.IScanManager;
import paycardscanner.camera.RenderThread;
import paycardscanner.camera.ScanManagerHandler;
import paycardscanner.camera.WindowRotationListener;
import paycardscanner.camera.widget.PreviewLayout;
import paycardscanner.ndk.DisplayConfigurationImpl;
import paycardscanner.ndk.RecognitionCore;
import paycardscanner.ndk.RecognitionResult;
import paycardscanner.ndk.RecognitionStatusListener;
import paycardscanner.ndk.TorchStatusListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\r\u0018\u0000 F2\u00020\u0001:\u0002EFB'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010#\u001a\u00020$H\u0016J\u001a\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0017J\u001a\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0017J\u0014\u0010,\u001a\u00020$2\n\u0010-\u001a\u00060.R\u00020/H\u0017J\u0012\u00100\u001a\u00020$2\b\u00101\u001a\u0004\u0018\u00010)H\u0017J\u0010\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\u0003H\u0017J\u0014\u00104\u001a\u00020$2\n\u00105\u001a\u000606j\u0002`7H\u0017J\b\u00108\u001a\u00020$H\u0016J\u0010\u00109\u001a\u00020$2\u0006\u00105\u001a\u00020:H\u0017J\b\u0010;\u001a\u00020$H\u0016J\b\u0010<\u001a\u00020$H\u0002J\b\u0010=\u001a\u00020$H\u0016J\b\u0010>\u001a\u00020$H\u0016J\u0010\u0010?\u001a\u00020$2\u0006\u0010@\u001a\u00020'H\u0016J\b\u0010A\u001a\u00020$H\u0002J\b\u0010B\u001a\u00020$H\u0002J\b\u0010C\u001a\u00020$H\u0016J\b\u0010D\u001a\u00020$H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lpaycardscanner/camera/CardScanManager;", "Lpaycardscanner/camera/IScanManager;", "recognitionMode", "", "context", "Landroid/content/Context;", "previewLayout", "Lpaycardscanner/camera/widget/PreviewLayout;", "callbacks", "Lpaycardscanner/camera/CardScanManager$Callbacks;", "(ILandroid/content/Context;Lpaycardscanner/camera/widget/PreviewLayout;Lpaycardscanner/camera/CardScanManager$Callbacks;)V", "display", "Landroid/view/Display;", "getDisplay", "()Landroid/view/Display;", "displayConfiguration", "Lpaycardscanner/ndk/DisplayConfigurationImpl;", "mShakeEventListener", "Landroid/hardware/SensorEventListener;", "recognitionCore", "Lpaycardscanner/ndk/RecognitionCore;", "recognitionStatusListener", "Lpaycardscanner/ndk/RecognitionStatusListener;", "renderThread", "Lpaycardscanner/camera/RenderThread;", "scanManagerHandler", "Lpaycardscanner/camera/ScanManagerHandler;", "surfaceHolder", "Landroid/view/SurfaceHolder;", "surfaceView", "Landroid/view/SurfaceView;", "getSurfaceView", "()Landroid/view/SurfaceView;", "windowRotationListener", "Lpaycardscanner/camera/WindowRotationListener;", "freezeCameraPreview", "", "onAutoFocusComplete", "isSuccess", "", "focusMode", "", "onAutoFocusMoving", "isStart", "onCameraOpened", "parameters", "Landroid/hardware/Camera$Parameters;", "Landroid/hardware/Camera;", "onFpsReport", "fpsReport", "onFrameProcessed", "newBorders", "onOpenCameraError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onPause", "onRenderThreadError", "", "onResume", "refreshDisplayOrientation", "resetResult", "resumeScan", "setRecognitionCoreIdle", "idle", "startShakeDetector", "stopShakeDetector", "toggleFlash", "unfreezeCameraPreview", "Callbacks", "Companion", "sdk_release"})
public final class CardScanManager
implements IScanManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int DEFAULT_RECOGNITION_MODE = 15;
    private static final boolean DBG;
    @NotNull
    private static final String TAG = "ScanManager";
    private final int recognitionMode;
    @NotNull
    private final Context context;
    @NotNull
    private final PreviewLayout previewLayout;
    @NotNull
    private final Callbacks callbacks;
    @NotNull
    private final RecognitionCore recognitionCore;
    @NotNull
    private final ScanManagerHandler scanManagerHandler;
    @Nullable
    private RenderThread renderThread;
    @Nullable
    private SurfaceHolder surfaceHolder;
    @NotNull
    private final WindowRotationListener windowRotationListener;
    @NotNull
    private final DisplayConfigurationImpl displayConfiguration;
    @NotNull
    private final RecognitionStatusListener recognitionStatusListener;
    @NotNull
    private final SensorEventListener mShakeEventListener;

    public CardScanManager(int n, @NotNull Context object, @NotNull PreviewLayout previewLayout, @NotNull Callbacks callbacks) {
        DisplayConfigurationImpl displayConfigurationImpl;
        RecognitionCore recognitionCore;
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)previewLayout), (String)"previewLayout");
        Intrinsics.checkNotNullParameter((Object)callbacks, (String)"callbacks");
        this.recognitionMode = n;
        this.context = object;
        this.previewLayout = previewLayout;
        this.callbacks = callbacks;
        RecognitionCore recognitionCore2 = RecognitionCore.getInstance((Context)object);
        RecognitionCore recognitionCore3 = recognitionCore = recognitionCore2;
        Intrinsics.checkNotNullExpressionValue((Object)recognitionCore3, (String)"getInstance(context)");
        this.recognitionCore = recognitionCore3;
        this.scanManagerHandler = new ScanManagerHandler(this);
        this.recognitionStatusListener = new RecognitionStatusListener(this){
            private long recognitionCompleteTs;
            final /* synthetic */ CardScanManager this$0;
            {
                this.this$0 = cardScanManager;
            }

            public void onRecognitionComplete(@NotNull RecognitionResult recognitionResult) {
                Intrinsics.checkNotNullParameter((Object)recognitionResult, (String)"result");
                CardScanManager.access$getPreviewLayout$p(this.this$0).setSuccessRecognitionState();
                if (recognitionResult.isFirst()) {
                    Object object = CardScanManager.access$getRenderThread$p(this.this$0);
                    if (object != null && (object = ((RenderThread)object).getHandler()) != null) {
                        ((RenderThread.RenderHandler)((Object)object)).sendPauseProcessFrames();
                    }
                    if (CardScanManager.access$getDBG$cp()) {
                        this.recognitionCompleteTs = System.nanoTime();
                    }
                }
                if (recognitionResult.isFinal()) {
                    long l = System.nanoTime();
                    if (CardScanManager.access$getDBG$cp()) {
                        String string = String.format(Locale.US, "Final result received after %.3f ms", Arrays.copyOf(new Object[]{Float.valueOf((float)(l - this.recognitionCompleteTs) / 1000000.0f)}, 1));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, format, *args)");
                        Log.v((String)"ScanManager", (String)string);
                    }
                    this.this$0.freezeCameraPreview();
                }
                CardScanManager.access$getCallbacks$p(this.this$0).onRecognitionComplete(recognitionResult);
            }

            public void onCardImageReceived(@NotNull Bitmap bitmap) {
                Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                if (CardScanManager.access$getDBG$cp()) {
                    long l = System.nanoTime();
                    String string = String.format(Locale.US, "Card image received after %.3f ms", Arrays.copyOf(new Object[]{Float.valueOf((float)(l - this.recognitionCompleteTs) / 1000000.0f)}, 1));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, format, *args)");
                    Log.v((String)"ScanManager", (String)string);
                }
                CardScanManager.access$getCallbacks$p(this.this$0).onCardImageReceived(bitmap);
            }
        };
        this.mShakeEventListener = new SensorEventListener(this){
            private final double SHAKE_THRESHOLD;
            private long lastUpdate;
            @NotNull
            private final double[] gravity;
            final /* synthetic */ CardScanManager this$0;
            {
                this.this$0 = cardScanManager;
                this.SHAKE_THRESHOLD = 3.3;
                this.gravity = new double[3];
            }

            public void onSensorChanged(@NotNull SensorEvent object) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"event");
                long l = System.currentTimeMillis();
                long l2 = l - this.lastUpdate;
                if (500L < l2) {
                    double d;
                    double d2;
                    double d3;
                    mShakeEventListener.1 v0 = this;
                    v0.lastUpdate = l;
                    double[] dArray = v0.gravity;
                    double d4 = 0.8f;
                    float f = 1.0f - 0.8f;
                    object = object.values;
                    float f2 = object.values[0];
                    dArray[0] = d3 = d4 * dArray[0] + (double)(f * f2);
                    SensorEvent sensorEvent = object[1];
                    dArray[1] = d2 = d4 * dArray[1] + (double)(f * sensorEvent);
                    SensorEvent sensorEvent2 = object[2];
                    v0.gravity[2] = d = d4 * dArray[2] + (double)(f * sensorEvent2);
                    double d5 = (double)f2 - d3;
                    double d6 = (double)sensorEvent - d2;
                    d3 = (double)sensorEvent2 - d;
                    double d7 = d6;
                    double d8 = d3;
                    d6 = Math.sqrt(d5 * d5 + d7 * d7 + d8 * d8);
                    if (v0.SHAKE_THRESHOLD < d6 && CardScanManager.access$getRenderThread$p(this.this$0) != null) {
                        if (CardScanManager.access$getDBG$cp()) {
                            Log.d((String)"ScanManager", (String)"shake focus request");
                        }
                        RenderThread renderThread = CardScanManager.access$getRenderThread$p(this.this$0);
                        Intrinsics.checkNotNull((Object)renderThread);
                        renderThread.getHandler().sendRequestFocus();
                    }
                }
            }

            public void onAccuracyChanged(@NotNull Sensor sensor, int n) {
                Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
            }
        };
        recognitionCore = this.getDisplay();
        Object object2 = object = displayConfigurationImpl;
        this.displayConfiguration = object2;
        ((DisplayConfigurationImpl)object).setCameraParameters(CameraUtils.getBackCameraSensorOrientation());
        displayConfigurationImpl.setDisplayParameters((Display)recognitionCore);
        recognitionCore2.setDisplayConfiguration(displayConfigurationImpl);
        this.getSurfaceView().getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(@NotNull SurfaceHolder surfaceHolder) {
                Intrinsics.checkNotNullParameter((Object)surfaceHolder, (String)"holder");
                if (DBG) {
                    Log.d((String)CardScanManager.TAG, (String)("SurfaceView  surfaceCreated holder=" + surfaceHolder + " (static=" + surfaceHolder + ")"));
                }
                if (surfaceHolder == null) {
                    1 v0 = object;
                    surfaceHolder = surfaceHolder;
                    if (renderThread != null) {
                        Object object = renderThread;
                        if (object != null && (object = ((RenderThread)object).getHandler()) != null) {
                            ((RenderThread.RenderHandler)((Object)object)).sendSurfaceAvailable(surfaceHolder, true);
                        }
                    } else if (DBG) {
                        Log.d((String)CardScanManager.TAG, (String)"render thread not running");
                    }
                    return;
                }
                throw new RuntimeException("sSurfaceHolder is already set");
            }

            public void surfaceChanged(@NotNull SurfaceHolder surfaceHolder, int n, int n2, int n3) {
                Intrinsics.checkNotNullParameter((Object)surfaceHolder, (String)"holder");
                if (DBG) {
                    Log.d((String)CardScanManager.TAG, (String)("SurfaceView surfaceChanged fmt=" + n + " size=" + n2 + "x" + n3 + " holder=" + surfaceHolder));
                }
                if (renderThread != null) {
                    RenderThread renderThread = renderThread;
                    Intrinsics.checkNotNull((Object)renderThread);
                    renderThread.getHandler().sendSurfaceChanged(n, n2, n3);
                } else if (DBG) {
                    Log.d((String)CardScanManager.TAG, (String)"Ignoring surfaceChanged");
                }
            }

            public void surfaceDestroyed(@NotNull SurfaceHolder surfaceHolder) {
                Intrinsics.checkNotNullParameter((Object)surfaceHolder, (String)"holder");
                if (renderThread != null) {
                    RenderThread renderThread = renderThread;
                    Intrinsics.checkNotNull((Object)renderThread);
                    renderThread.getHandler().sendSurfaceDestroyed();
                }
                if (DBG) {
                    Log.d((String)CardScanManager.TAG, (String)("SurfaceView surfaceDestroyed holder=" + surfaceHolder));
                }
                surfaceHolder = null;
            }
        });
        this.windowRotationListener = new WindowRotationListener();
    }

    public /* synthetic */ CardScanManager(int n, Context context, PreviewLayout previewLayout, Callbacks callbacks, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 15;
        }
        this(n, context, previewLayout, callbacks);
    }

    private final SurfaceView getSurfaceView() {
        return this.previewLayout.getSurfaceView();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Display getDisplay() {
        CardScanManager cardScanManager;
        if (Build.VERSION.SDK_INT >= 30) {
            cardScanManager = cardScanManager.context.getDisplay();
            if (cardScanManager == null) throw new IllegalArgumentException("Required value was null.".toString());
            Intrinsics.checkNotNullExpressionValue((Object)cardScanManager, (String)"requireNotNull(context.display)");
            return cardScanManager;
        } else {
            Object object = cardScanManager.context.getSystemService("window");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
            cardScanManager = ((WindowManager)object).getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)cardScanManager, (String)"context.getSystemService\u2026owManager).defaultDisplay");
        }
        return cardScanManager;
    }

    private final void startShakeDetector() {
        Object object = this.context.getSystemService("sensor");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.SensorManager");
        SensorManager sensorManager = (SensorManager)object;
        Sensor sensor = sensorManager.getDefaultSensor(1);
        if (sensor != null) {
            sensorManager.registerListener(this.mShakeEventListener, sensor, 1);
        }
    }

    private final void stopShakeDetector() {
        Object object = this.context.getSystemService("sensor");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.SensorManager");
        ((SensorManager)object).unregisterListener(this.mShakeEventListener);
    }

    private final void refreshDisplayOrientation() {
        if (DBG) {
            Log.d((String)TAG, (String)"refreshDisplayOrientation()");
        }
        CardScanManager cardScanManager = this;
        cardScanManager.displayConfiguration.setDisplayParameters(this.getDisplay());
        cardScanManager.recognitionCore.setDisplayConfiguration(this.displayConfiguration);
        Object object = cardScanManager.renderThread;
        if (object != null && (object = ((RenderThread)object).getHandler()) != null) {
            ((RenderThread.RenderHandler)((Object)object)).sendOrientationChanged(CameraUtils.getBackCameraDataRotation(this.getDisplay()));
        }
    }

    private static final void onResume$lambda-0(CardScanManager cardScanManager, boolean bl) {
        CardScanManager cardScanManager2 = cardScanManager;
        Intrinsics.checkNotNullParameter((Object)cardScanManager2, (String)"this$0");
        cardScanManager2.callbacks.onTorchStatusChanged(bl);
    }

    private static final void onResume$lambda-6(CardScanManager cardScanManager) {
        CardScanManager cardScanManager2 = cardScanManager;
        Intrinsics.checkNotNullParameter((Object)cardScanManager2, (String)"this$0");
        cardScanManager2.refreshDisplayOrientation();
    }

    public static final /* synthetic */ PreviewLayout access$getPreviewLayout$p(CardScanManager cardScanManager) {
        return cardScanManager.previewLayout;
    }

    public static final /* synthetic */ Callbacks access$getCallbacks$p(CardScanManager cardScanManager) {
        return cardScanManager.callbacks;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void onResume() {
        var1_1 = CardScanManager.DBG;
        if (var1_1) {
            Log.d((String)"ScanManager", (String)"onResume()");
        }
        var2_3 = v0;
        v1 = this;
        var3_4 = v1.context;
        var4_5 = v1.scanManagerHandler;
        var5_6 = (TorchStatusListener)LambdaMetafactory.metafactory(null, null, null, (Z)V, onResume$lambda-0(paycardscanner.camera.CardScanManager boolean ), (Z)V)((CardScanManager)v1);
        new RenderThread((Context)var3_4, var4_5, var5_6).setName("Camera thread");
        var2_3.start();
        var2_3.waitUntilReady();
        this.renderThread = var2_3;
        var2_3 = this.surfaceHolder;
        if (var2_3 == null) ** GOTO lbl-1000
        if (var1_1) {
            Log.d((String)"ScanManager", (String)"Sending previous surface");
        }
        if ((var3_4 = this.renderThread) != null && (var3_4 = var3_4.getHandler()) != null) {
            var3_4.sendSurfaceAvailable((SurfaceHolder)var2_3, false);
            var2_3 = Unit.INSTANCE;
        } else lbl-1000:
        // 2 sources

        {
            var2_3 = null;
        }
        if (var2_3 == null && var1_1) {
            Log.d((String)"ScanManager", (String)"No previous surface");
        }
        v2 = this;
        v2.displayConfiguration.setCameraParameters(CameraUtils.getBackCameraSensorOrientation());
        v3 = v2.recognitionCore;
        v3.setRecognitionMode(this.recognitionMode);
        v3.setStatusListener(this.recognitionStatusListener);
        v3.resetResult();
        var1_2 /* !! */  = v2.renderThread;
        var1_2 /* !! */  = var1_2 /* !! */  != null ? var1_2 /* !! */ .getHandler() : null;
        if (var1_2 /* !! */  != null) {
            v4 = this;
            v5 = var1_2 /* !! */ ;
            v5.sendOrientationChanged(CameraUtils.getBackCameraDataRotation(this.getDisplay()));
            v5.sendUnfreeze();
            v4.startShakeDetector();
            v6 = this;
            this = v6.context;
            var1_2 /* !! */  = v6.getDisplay();
            var2_3 = (WindowRotationListener.RotationListener)LambdaMetafactory.metafactory(null, null, null, ()V, onResume$lambda-6(paycardscanner.camera.CardScanManager ), ()V)((CardScanManager)v6);
            v4.windowRotationListener.register((Context)this, (Display)var1_2 /* !! */ , (WindowRotationListener.RotationListener)var2_3);
            v4.previewLayout.setIdleRecognitionState();
            v4.setRecognitionCoreIdle(false);
            return;
        }
        throw new IllegalArgumentException("Required value was null.".toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onPause() {
        if (DBG) {
            Log.d((String)TAG, (String)"onPause()");
        }
        CardScanManager cardScanManager = this;
        cardScanManager.setRecognitionCoreIdle(true);
        cardScanManager.stopShakeDetector();
        cardScanManager.recognitionCore.setStatusListener(null);
        Object object = cardScanManager.renderThread;
        if (object != null) {
            block6: {
                RenderThread renderThread = object;
                renderThread.getHandler().sendShutdown();
                try {
                    // empty try
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    break block6;
                }
                {
                    renderThread.join();
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
            }
            object = Result.exceptionOrNull-impl((Object)object);
            if (object != null && object instanceof InterruptedException) {
                this.callbacks.onOpenCameraError((Exception)object);
            }
            this.renderThread = null;
        }
        this.windowRotationListener.unregister();
    }

    @Override
    public void resumeScan() {
        this.setRecognitionCoreIdle(false);
    }

    @Override
    public void toggleFlash() {
        Object object = ((CardScanManager)object).renderThread;
        if (object != null && (object = ((RenderThread)object).getHandler()) != null) {
            ((RenderThread.RenderHandler)((Object)object)).sendToggleFlash();
        }
    }

    @Override
    public void resetResult() {
        if (DBG) {
            Log.d((String)TAG, (String)"resetResult()");
        }
        CardScanManager cardScanManager = this;
        cardScanManager.recognitionCore.resetResult();
        Object object = cardScanManager.renderThread;
        if (object != null && (object = ((RenderThread)object).getHandler()) != null) {
            ((RenderThread.RenderHandler)((Object)object)).sendResumeProcessFrames();
        }
        this.unfreezeCameraPreview();
    }

    @Override
    public void setRecognitionCoreIdle(boolean bl) {
        Object object;
        if (DBG) {
            Log.d((String)TAG, (String)("setRecognitionCoreIdle() called with: idle = [" + bl + "]"));
        }
        ((CardScanManager)object).recognitionCore.setIdle(bl);
        if (bl) {
            object = ((CardScanManager)object).renderThread;
            if (object != null && (object = ((RenderThread)object).getHandler()) != null) {
                ((RenderThread.RenderHandler)((Object)object)).sendPauseCamera();
            }
        } else {
            object = ((CardScanManager)object).renderThread;
            if (object != null && (object = ((RenderThread)object).getHandler()) != null) {
                ((RenderThread.RenderHandler)((Object)object)).sendResumeCamera();
            }
        }
    }

    @Override
    @MainThread
    public void onCameraOpened(@NotNull Camera.Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.callbacks.onCameraOpened(parameters);
    }

    @Override
    @MainThread
    public void onOpenCameraError(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"e");
        if (DBG) {
            Log.d((String)TAG, (String)("onOpenCameraError() called with: e = [" + exception + "]"));
        }
        this.callbacks.onOpenCameraError(exception);
        this.renderThread = null;
    }

    @Override
    @MainThread
    public void onRenderThreadError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"e");
        if (DBG) {
            Log.d((String)TAG, (String)("onRenderThreadError() called with: e = [" + throwable + "]"));
        }
        this.callbacks.onOpenCameraError((Exception)throwable);
        this.renderThread = null;
    }

    @Override
    @MainThread
    public void onFrameProcessed(int n) {
    }

    @Override
    @MainThread
    public void onFpsReport(@Nullable String string) {
        this.callbacks.onFpsReport(string);
    }

    @Override
    @MainThread
    public void onAutoFocusMoving(boolean bl, @Nullable String string) {
        this.callbacks.onAutoFocusMoving(bl, string);
    }

    @Override
    @MainThread
    public void onAutoFocusComplete(boolean bl, @Nullable String string) {
        this.callbacks.onAutoFocusComplete(bl, string);
    }

    @Override
    public void freezeCameraPreview() {
        if (DBG) {
            Log.d((String)TAG, (String)"freezeCameraPreview() called with: ");
        }
        if ((this = ((CardScanManager)this).renderThread) != null && (this = ((RenderThread)this).getHandler()) != null) {
            ((RenderThread.RenderHandler)((Object)this)).sendFreeze();
        }
    }

    @Override
    public void unfreezeCameraPreview() {
        if (DBG) {
            Log.d((String)TAG, (String)"unfreezeCameraPreview() called with: ");
        }
        if ((this = ((CardScanManager)this).renderThread) != null && (this = ((RenderThread)this).getHandler()) != null) {
            ((RenderThread.RenderHandler)((Object)this)).sendUnfreeze();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\u001a\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\u0016\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0018\u00010\fR\u00020\rH&J\u0012\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&J\u0012\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H&J\u0018\u0010\u0013\u001a\u00020\u00032\u000e\u0010\u0014\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016H&J\u0012\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H&J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0005H&\u00a8\u0006\u001c"}, d2={"Lpaycardscanner/camera/CardScanManager$Callbacks;", "", "onAutoFocusComplete", "", "success", "", "cameraFocusMode", "", "onAutoFocusMoving", "start", "onCameraOpened", "cameraParameters", "Landroid/hardware/Camera$Parameters;", "Landroid/hardware/Camera;", "onCardImageReceived", "bitmap", "Landroid/graphics/Bitmap;", "onFpsReport", "report", "onOpenCameraError", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onRecognitionComplete", "result", "Lpaycardscanner/ndk/RecognitionResult;", "onTorchStatusChanged", "turnTorchOn", "sdk_release"})
    public static interface Callbacks {
        public void onCameraOpened(@Nullable Camera.Parameters var1);

        public void onOpenCameraError(@Nullable Exception var1);

        public void onRecognitionComplete(@Nullable RecognitionResult var1);

        public void onCardImageReceived(@Nullable Bitmap var1);

        public void onFpsReport(@Nullable String var1);

        public void onAutoFocusMoving(boolean var1, @Nullable String var2);

        public void onAutoFocusComplete(boolean var1, @Nullable String var2);

        public void onTorchStatusChanged(boolean var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lpaycardscanner/camera/CardScanManager$Companion;", "", "()V", "DBG", "", "DEFAULT_RECOGNITION_MODE", "", "TAG", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

