/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera;

import android.content.Context;
import androidx.annotation.RestrictTo;
import java.util.concurrent.atomic.AtomicBoolean;
import paycardscanner.camera.RecognitionAvailabilityChecker;
import paycardscanner.ndk.RecognitionCore;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class RecognitionCoreUtils {
    private static AtomicBoolean deployRecognitionCoreActive = new AtomicBoolean();

    public static boolean isRecognitionCoreDeployRequired(Context context) {
        return RecognitionAvailabilityChecker.isDeviceHasCamera(context) && !RecognitionCore.isInitialized();
        {
        }
    }

    public static void deployRecognitionCoreSync(Context context) {
        if (!RecognitionCoreUtils.isRecognitionCoreDeployRequired(context)) {
            return;
        }
        try {
            RecognitionCore.deploy(context);
        }
        catch (Throwable throwable) {}
    }
}

