/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import paycardscanner.camera.CameraUtils;
import paycardscanner.camera.IScanManager;
import paycardscanner.camera.OrientationHelper;
import paycardscanner.camera.RenderThread;
import paycardscanner.camera.ScanManagerHandler;
import paycardscanner.camera.WindowRotationListener;
import paycardscanner.camera.widget.CameraPreviewLayout;
import paycardscanner.camera.widget.CardDetectionStateView;
import paycardscanner.ndk.DisplayConfiguration;
import paycardscanner.ndk.DisplayConfigurationImpl;
import paycardscanner.ndk.RecognitionCore;
import paycardscanner.ndk.RecognitionResult;
import paycardscanner.ndk.RecognitionStatusListener;
import paycardscanner.utils.Size;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ScanManager
implements IScanManager {
    private static SurfaceHolder sSurfaceHolder;
    private final int mRecognitionMode;
    private final Context mAppContext;
    private final Callbacks mCallbacks;
    private RecognitionCore mRecognitionCore;
    private CameraPreviewLayout mPreviewLayout;
    private ScanManagerHandler mHandler;
    @Nullable
    private RenderThread mRenderThread;
    private final WindowRotationListener mWindowRotationListener;
    private final DisplayConfigurationImpl mDisplayConfiguration;
    private final RecognitionStatusListener mRecognitionStatusListener;
    private final SensorEventListener mShakeEventListener;

    public ScanManager(int n, Context object, CameraPreviewLayout cameraPreviewLayout, Callbacks callbacks) throws RuntimeException {
        DisplayConfigurationImpl displayConfigurationImpl;
        Context context;
        SensorEventListener sensorEventListener;
        RecognitionStatusListener recognitionStatusListener2;
        Object object2 = recognitionStatusListener2;
        recognitionStatusListener2 = new RecognitionStatusListener(){

            @Override
            public void onRecognitionComplete(RecognitionResult recognitionResult) {
                ScanManager.this.getCardDetectionStateView().setRecognitionResult(recognitionResult);
                if (recognitionResult.isFirst()) {
                    RenderThread renderThread = ScanManager.this.mRenderThread;
                    if (renderThread != null) {
                        renderThread.getHandler().sendPauseProcessFrames();
                    }
                    ScanManager.this.getCardDetectionStateView().setDetectionState(15);
                }
                if (recognitionResult.isFinal()) {
                    System.nanoTime();
                }
                ScanManager.this.mCallbacks.onRecognitionComplete(recognitionResult);
            }

            @Override
            public void onCardImageReceived(Bitmap bitmap) {
                ScanManager.this.mCallbacks.onCardImageReceived(bitmap);
            }
        };
        this.mRecognitionStatusListener = object2;
        object2 = sensorEventListener;
        sensorEventListener = new SensorEventListener(){
            long lastUpdate;
            public final double[] gravity = new double[3];

            public void onSensorChanged(SensorEvent object) {
                long l = System.currentTimeMillis();
                long l2 = l - this.lastUpdate;
                if (500L < l2) {
                    double d;
                    double d2;
                    double d3;
                    3 v0 = this;
                    v0.lastUpdate = l;
                    double[] dArray = v0.gravity;
                    object = object.values;
                    float f = object.values[0];
                    dArray[0] = d3 = v0.gravity[0] * (double)0.8f + (double)(f * 0.19999999f);
                    SensorEvent sensorEvent = object[1];
                    dArray[1] = d2 = v0.gravity[1] * (double)0.8f + (double)(sensorEvent * 0.19999999f);
                    SensorEvent sensorEvent2 = object[2];
                    dArray[2] = d = v0.gravity[2] * (double)0.8f + (double)(sensorEvent2 * 0.19999999f);
                    double d4 = (double)f - d3;
                    double d5 = (double)sensorEvent - d2;
                    double d6 = (double)sensorEvent2 - d;
                    double d7 = d5;
                    double d8 = d6;
                    d5 = Math.sqrt(d4 * d4 + d7 * d7 + d8 * d8);
                    if (3.3 < d5 && (this = ScanManager.this.mRenderThread) != null) {
                        ((RenderThread)this).getHandler().sendRequestFocus();
                    }
                }
            }

            public void onAccuracyChanged(Sensor sensor, int n) {
            }
        };
        this.mShakeEventListener = object2;
        if (n == 0) {
            n = 15;
        }
        ScanManager scanManager = this;
        this.mRecognitionMode = n;
        this.mAppContext = context = object.getApplicationContext();
        this.mCallbacks = callbacks;
        scanManager.mPreviewLayout = cameraPreviewLayout;
        scanManager.mRecognitionCore = RecognitionCore.getInstance(context);
        scanManager.mHandler = new ScanManagerHandler(this);
        context = scanManager.getDisplay();
        Object object3 = object = displayConfigurationImpl;
        this.mDisplayConfiguration = object3;
        ((DisplayConfigurationImpl)object).setCameraParameters(CameraUtils.getBackCameraSensorOrientation());
        displayConfigurationImpl.setDisplayParameters((Display)context);
        scanManager.mRecognitionCore.setDisplayConfiguration((DisplayConfiguration)object);
        scanManager.getSurfaceView().getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder surfaceHolder) {
                if (sSurfaceHolder == null) {
                    sSurfaceHolder = surfaceHolder;
                    RenderThread renderThread = renderThread.ScanManager.this.mRenderThread;
                    if (renderThread != null) {
                        renderThread.getHandler().sendSurfaceAvailable(surfaceHolder, true);
                    }
                    return;
                }
                throw new RuntimeException("sSurfaceHolder is already set");
            }

            public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
                RenderThread renderThread = renderThread.ScanManager.this.mRenderThread;
                if (renderThread != null) {
                    renderThread.getHandler().sendSurfaceChanged(n, n2, n3);
                }
            }

            public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                RenderThread renderThread = renderThread.ScanManager.this.mRenderThread;
                if (renderThread != null) {
                    renderThread.getHandler().sendSurfaceDestroyed();
                }
                sSurfaceHolder = null;
            }
        });
        scanManager.mWindowRotationListener = new WindowRotationListener();
    }

    private SurfaceView getSurfaceView() {
        return this.mPreviewLayout.getSurfaceView();
    }

    private CardDetectionStateView getCardDetectionStateView() {
        return this.mPreviewLayout.getDetectionStateOverlay();
    }

    private Display getDisplay() {
        return ((WindowManager)this.mAppContext.getSystemService("window")).getDefaultDisplay();
    }

    private void refreshDisplayOrientation() {
        ScanManager scanManager = this;
        Display display = scanManager.getDisplay();
        scanManager.mDisplayConfiguration.setDisplayParameters(display);
        scanManager.mRecognitionCore.setDisplayConfiguration(this.mDisplayConfiguration);
        if (scanManager.mRenderThread != null) {
            int n = CameraUtils.getBackCameraDataRotation(display);
            this.mRenderThread.getHandler().sendOrientationChanged(n);
        }
    }

    private void setupCardDetectionCameraParameters(int n, int n2) {
        ScanManager scanManager = this;
        Size size = CameraUtils.CAMERA_RESOLUTION.size;
        int n3 = size.height;
        Rect rect = OrientationHelper.rotateRect(scanManager.mRecognitionCore.getCardFrameRect(), n3, size.width, 90, null);
        scanManager.mPreviewLayout.setCameraParameters(n, n2, CameraUtils.getBackCameraDataRotation(this.getDisplay()), rect);
    }

    private void startShakeDetector() {
        SensorManager sensorManager = (SensorManager)this.mAppContext.getSystemService("sensor");
        Sensor sensor = sensorManager.getDefaultSensor(1);
        if (sensor != null) {
            sensorManager.registerListener(this.mShakeEventListener, sensor, 1);
        }
    }

    private void stopShakeDetector() {
        ((SensorManager)this.mAppContext.getSystemService("sensor")).unregisterListener(this.mShakeEventListener);
    }

    @Override
    public void onResume() {
        ScanManager scanManager = scanManager5;
        ScanManager scanManager2 = scanManager5;
        Object object = scanManager2.mAppContext;
        Object object2 = scanManager2.mHandler;
        scanManager5.mRenderThread = new RenderThread((Context)object, (ScanManagerHandler)((Object)object2), scanManager2.mCallbacks::onTorchStatusChanged);
        scanManager5.mRenderThread.setName("Camera thread");
        scanManager.mRenderThread.start();
        scanManager.mRenderThread.waitUntilReady();
        object = scanManager.mRenderThread.getHandler();
        object2 = sSurfaceHolder;
        if (object2 != null) {
            ((RenderThread.RenderHandler)((Object)object)).sendSurfaceAvailable((SurfaceHolder)object2, false);
        }
        ScanManager scanManager3 = scanManager5;
        scanManager3.mDisplayConfiguration.setCameraParameters(CameraUtils.getBackCameraSensorOrientation());
        scanManager3.mRecognitionCore.setRecognitionMode(scanManager5.mRecognitionMode);
        scanManager3.mRecognitionCore.setStatusListener(scanManager5.mRecognitionStatusListener);
        scanManager3.mRecognitionCore.resetResult();
        RenderThread.RenderHandler renderHandler = scanManager3.mRenderThread.getHandler();
        renderHandler.sendOrientationChanged(CameraUtils.getBackCameraDataRotation(scanManager5.getDisplay()));
        renderHandler.sendUnfreeze();
        scanManager3.mPreviewLayout.setOnWindowFocusChangedListener((view, bl) -> this.setRecognitionCoreIdle(bl ^ true));
        scanManager3.startShakeDetector();
        ScanManager scanManager4 = scanManager5;
        ScanManager scanManager5 = scanManager4.mAppContext;
        object = scanManager4.getDisplay();
        object2 = () -> this.refreshDisplayOrientation();
        scanManager3.mWindowRotationListener.register((Context)scanManager5, (Display)object, (WindowRotationListener.RotationListener)object2);
        scanManager3.getCardDetectionStateView().setRecognitionResult(RecognitionResult.empty());
        scanManager3.setRecognitionCoreIdle(false);
    }

    @Override
    public void onPause() {
        ScanManager scanManager = this;
        scanManager.setRecognitionCoreIdle(true);
        scanManager.stopShakeDetector();
        scanManager.mPreviewLayout.setOnWindowFocusChangedListener(null);
        scanManager.mRecognitionCore.setStatusListener(null);
        RenderThread renderThread = scanManager.mRenderThread;
        if (renderThread != null) {
            block3: {
                renderThread.getHandler().sendShutdown();
                try {
                    this.mRenderThread.join();
                }
                catch (InterruptedException interruptedException) {
                    Callbacks callbacks = this.mCallbacks;
                    if (callbacks == null) break block3;
                    callbacks.onOpenCameraError(interruptedException);
                }
            }
            this.mRenderThread = null;
        }
        this.mWindowRotationListener.unregister();
    }

    @Override
    public void resumeScan() {
        this.setRecognitionCoreIdle(false);
    }

    @Override
    public void toggleFlash() {
        RenderThread renderThread = ((ScanManager)((Object)renderThread)).mRenderThread;
        if (renderThread == null) {
            return;
        }
        renderThread.getHandler().sendToggleFlash();
    }

    @Override
    public void resetResult() {
        ScanManager scanManager = this;
        scanManager.mRecognitionCore.resetResult();
        RenderThread renderThread = scanManager.mRenderThread;
        if (renderThread != null) {
            renderThread.getHandler().sendResumeProcessFrames();
        }
        this.unfreezeCameraPreview();
    }

    @Override
    public void setRecognitionCoreIdle(boolean bl) {
        ScanManager scanManager = renderThread;
        scanManager.mRecognitionCore.setIdle(bl);
        RenderThread renderThread = scanManager.mRenderThread;
        if (renderThread != null) {
            if (bl) {
                renderThread.getHandler().sendPauseCamera();
            } else {
                renderThread.getHandler().sendResumeCamera();
            }
        }
    }

    @Override
    @MainThread
    public void onCameraOpened(Camera.Parameters parameters) {
        ScanManager scanManager = this;
        Camera.Size size = parameters.getPreviewSize();
        int n = size.width;
        scanManager.setupCardDetectionCameraParameters(n, size.height);
        Callbacks callbacks = scanManager.mCallbacks;
        if (callbacks != null) {
            callbacks.onCameraOpened(parameters);
        }
    }

    @Override
    @MainThread
    public void onOpenCameraError(Exception exception) {
        Callbacks callbacks = this.mCallbacks;
        if (callbacks != null) {
            callbacks.onOpenCameraError(exception);
        }
        this.mRenderThread = null;
    }

    @Override
    @MainThread
    public void onRenderThreadError(Throwable throwable) {
        Callbacks callbacks = this.mCallbacks;
        if (callbacks != null) {
            callbacks.onOpenCameraError((Exception)throwable);
        }
        this.mRenderThread = null;
    }

    @Override
    @MainThread
    public void onFrameProcessed(int n) {
        if (this.mCallbacks != null) {
            this.mPreviewLayout.getDetectionStateOverlay().setDetectionState(n);
        }
    }

    @Override
    @MainThread
    public void onFpsReport(String string) {
        Callbacks callbacks = ((ScanManager)((Object)callbacks)).mCallbacks;
        if (callbacks != null) {
            callbacks.onFpsReport(string);
        }
    }

    @Override
    @MainThread
    public void onAutoFocusMoving(boolean bl, String string) {
        Callbacks callbacks = ((ScanManager)((Object)callbacks)).mCallbacks;
        if (callbacks != null) {
            callbacks.onAutoFocusMoving(bl, string);
        }
    }

    @Override
    @MainThread
    public void onAutoFocusComplete(boolean bl, String string) {
        Callbacks callbacks = ((ScanManager)((Object)callbacks)).mCallbacks;
        if (callbacks != null) {
            callbacks.onAutoFocusComplete(bl, string);
        }
    }

    @Override
    public void freezeCameraPreview() {
        RenderThread renderThread = ((ScanManager)((Object)renderThread)).mRenderThread;
        if (renderThread != null) {
            renderThread.getHandler().sendFreeze();
        }
    }

    @Override
    public void unfreezeCameraPreview() {
        RenderThread renderThread = ((ScanManager)((Object)renderThread)).mRenderThread;
        if (renderThread != null) {
            renderThread.getHandler().sendUnfreeze();
        }
    }

    public static interface Callbacks {
        public void onCameraOpened(Camera.Parameters var1);

        public void onOpenCameraError(Exception var1);

        public void onRecognitionComplete(RecognitionResult var1);

        public void onCardImageReceived(Bitmap var1);

        public void onFpsReport(String var1);

        public void onAutoFocusMoving(boolean var1, String var2);

        public void onAutoFocusComplete(boolean var1, String var2);

        public void onTorchStatusChanged(boolean var1);
    }
}

