/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import androidx.annotation.RestrictTo;
import java.lang.ref.WeakReference;
import paycardscanner.camera.IScanManager;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ScanManagerHandler
extends Handler {
    private WeakReference<IScanManager> mWeakScanManager;

    public ScanManagerHandler(IScanManager iScanManager) {
        WeakReference<IScanManager> weakReference;
        Object object = weakReference;
        weakReference = new WeakReference<IScanManager>(iScanManager);
        v1.mWeakScanManager = object;
    }

    public void sendOpenCameraError(Exception exception) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(1, exception));
    }

    public void sendRenderThreadError(Throwable throwable) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(2, throwable));
    }

    public void sendCameraOpened(Camera.Parameters parameters) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(3, parameters));
    }

    public void sendFrameProcessed(int n) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(4, n, 0));
    }

    public void sendAutoFocusMoving(boolean bl, String string) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(6, bl ? 1 : 0, 0, string));
    }

    public void sendAutoFocusComplete(boolean bl, String string) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(7, bl ? 1 : 0, 0, string));
    }

    public void handleMessage(Message message) {
        IScanManager iScanManager = (IScanManager)((ScanManagerHandler)((Object)iScanManager)).mWeakScanManager.get();
        if (iScanManager == null) {
            return;
        }
        switch (message.what) {
            default: {
                throw new RuntimeException("Unknown message " + message.what);
            }
            case 7: {
                boolean bl = message.arg1 != 0;
                iScanManager.onAutoFocusComplete(bl, (String)message.obj);
                break;
            }
            case 6: {
                boolean bl = message.arg1 != 0;
                iScanManager.onAutoFocusMoving(bl, (String)message.obj);
                break;
            }
            case 5: {
                iScanManager.onFpsReport((String)message.obj);
                break;
            }
            case 4: {
                iScanManager.onFrameProcessed(message.arg1);
                break;
            }
            case 3: {
                iScanManager.onCameraOpened((Camera.Parameters)message.obj);
                break;
            }
            case 2: {
                iScanManager.onRenderThreadError((Throwable)message.obj);
                break;
            }
            case 1: {
                iScanManager.onOpenCameraError((Exception)message.obj);
            }
        }
    }
}

