/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera;

import android.hardware.Camera;
import androidx.annotation.RestrictTo;
import paycardscanner.camera.CameraConfigurationUtils;
import paycardscanner.ndk.RecognitionCore;
import paycardscanner.ndk.TorchStatusListener;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TorchManager {
    private final Camera mCamera;
    private boolean mPaused;
    private boolean mTorchTurnedOn;
    private final RecognitionCore mRecognitionCore;
    private final TorchStatusListener mTorchStatusListener;
    private final TorchStatusListener mRecognitionCoreTorchStatusListener;

    public TorchManager(RecognitionCore recognitionCore, Camera camera, TorchStatusListener torchStatusListener) {
        TorchStatusListener torchStatusListener2;
        TorchStatusListener torchStatusListener3 = torchStatusListener2;
        torchStatusListener2 = new TorchStatusListener(){

            @Override
            public void onTorchStatusChanged(boolean bl) {
                TorchManager torchManager = TorchManager.this;
                Camera camera = torchManager.mCamera;
                if (camera == null) {
                    return;
                }
                if (bl) {
                    torchManager.mTorchTurnedOn = true;
                    if (!torchManager.mPaused) {
                        CameraConfigurationUtils.setFlashLight(camera, true);
                    }
                } else {
                    torchManager.mTorchTurnedOn = false;
                    CameraConfigurationUtils.setFlashLight(camera, false);
                }
                if ((this = TorchManager.this.mTorchStatusListener) != null) {
                    this.onTorchStatusChanged(bl);
                }
            }
        };
        this.mRecognitionCoreTorchStatusListener = torchStatusListener3;
        this.mCamera = camera;
        this.mRecognitionCore = recognitionCore;
        this.mTorchStatusListener = torchStatusListener;
    }

    private boolean isTorchTurnedOn() {
        String string = ((TorchManager)((Object)string)).mCamera.getParameters().getFlashMode();
        return "torch".equals(string) || "on".equals(string);
    }

    public void pause() {
        TorchManager torchManager = this;
        CameraConfigurationUtils.setFlashLight(torchManager.mCamera, false);
        torchManager.mPaused = true;
        torchManager.mRecognitionCore.setTorchListener(null);
    }

    public void resume() {
        TorchManager torchManager = this;
        torchManager.mPaused = false;
        torchManager.mRecognitionCore.setTorchListener(this.mRecognitionCoreTorchStatusListener);
        torchManager.mRecognitionCore.setTorchStatus(this.mTorchTurnedOn);
    }

    public void destroy() {
        this.mRecognitionCore.setTorchListener(null);
    }

    public void toggleTorch() {
        if (this.mPaused) {
            return;
        }
        TorchManager torchManager = this;
        boolean bl = torchManager.isTorchTurnedOn() ^ true;
        torchManager.mRecognitionCore.setTorchStatus(bl);
        CameraConfigurationUtils.setFlashLight(torchManager.mCamera, bl);
    }
}

