/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class WindowRotationListener {
    private static boolean DBG = false;
    private static final Impl sImpl = Build.VERSION.SDK_INT >= 17 ? new ImplApi17() : new ImplDefault();

    public void register(Context context, Display display, RotationListener rotationListener) {
        sImpl.register(context, display, rotationListener);
    }

    public void unregister() {
        sImpl.unregister();
    }

    @TargetApi(value=17)
    private static class ImplApi17
    implements Impl,
    DisplayManager.DisplayListener {
        private RotationListener mListener;
        private final Handler mHandler;
        private DisplayManager mDisplayManager;
        private int mDisplayId;

        public ImplApi17() {
            Handler handler;
            ImplApi17 implApi17 = handler;
            handler = new Handler();
            v1.mHandler = implApi17;
        }

        @Override
        public void register(Context context, Display display, RotationListener rotationListener) {
            this.mListener = rotationListener;
            context = (DisplayManager)context.getSystemService("display");
            ImplApi17 implApi17 = this;
            implApi17.mDisplayManager = context;
            context.registerDisplayListener((DisplayManager.DisplayListener)implApi17, implApi17.mHandler);
            this.mDisplayId = display.getDisplayId();
        }

        @Override
        public void unregister() {
            DisplayManager displayManager = this.mDisplayManager;
            if (displayManager == null) {
                return;
            }
            ImplApi17 implApi17 = this;
            displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
            implApi17.mDisplayManager = null;
            implApi17.mListener = null;
        }

        public void onDisplayAdded(int n) {
            if (DBG) {
                Log.d((String)"WindowRotationListener", (String)("onDisplayAdded() called with: displayId = [" + n + "]"));
            }
        }

        public void onDisplayRemoved(int n) {
            if (DBG) {
                Log.d((String)"WindowRotationListener", (String)("onDisplayRemoved() called with: displayId = [" + n + "]"));
            }
        }

        public void onDisplayChanged(int n) {
            RotationListener rotationListener;
            if (DBG) {
                Log.d((String)"WindowRotationListener", (String)("onDisplayChanged() called with: displayId = [" + n + "]"));
            }
            if ((rotationListener = this.mListener) != null && n == this.mDisplayId) {
                rotationListener.onWindowRotationChanged();
            }
        }
    }

    private static class ImplDefault
    implements Impl {
        private Display mDisplay;
        private RotationListener mListener;
        private OrientationEventListener mOrientationListener;

        private ImplDefault() {
        }

        @Override
        public void register(Context context, Display object, RotationListener rotationListener) {
            1 v1;
            ImplDefault implDefault = this;
            implDefault.mDisplay = object;
            implDefault.mListener = rotationListener;
            object = v1;
            object(this, context);
            this.mOrientationListener = object;
            v1.enable();
        }

        @Override
        public void unregister() {
            OrientationEventListener orientationEventListener = this.mOrientationListener;
            if (orientationEventListener == null) {
                return;
            }
            ImplDefault implDefault = this;
            orientationEventListener.disable();
            implDefault.mOrientationListener = null;
            implDefault.mDisplay = null;
            implDefault.mListener = null;
        }
    }

    private static interface Impl {
        public void register(Context var1, Display var2, RotationListener var3);

        public void unregister();
    }

    public static interface RotationListener {
        public void onWindowRotationChanged();
    }
}

