/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera.gles;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.FloatBuffer;
import paycardscanner.camera.gles.GlUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class Drawable2d {
    private static final float[] RECTANGLE_COORDS;
    private static final float[] RECTANGLE_TEX_COORDS;
    private static final FloatBuffer RECTANGLE_BUF;
    private static final FloatBuffer RECTANGLE_TEX_BUF;
    private FloatBuffer mVertexArray = RECTANGLE_BUF;
    private FloatBuffer mTexCoordArray = RECTANGLE_TEX_BUF;
    private int mVertexCount;
    private int mCoordsPerVertex = 2;
    private int mVertexStride = 2 * 4;
    private int mTexCoordStride = 8;

    public Drawable2d() {
        this.mVertexCount = RECTANGLE_COORDS.length / 2;
    }

    static {
        float[] fArray = new float[8];
        float[] fArray2 = fArray;
        fArray[0] = -0.5f;
        fArray[1] = -0.5f;
        fArray[2] = 0.5f;
        fArray[3] = -0.5f;
        fArray[4] = -0.5f;
        fArray[5] = 0.5f;
        fArray[6] = 0.5f;
        fArray[7] = 0.5f;
        RECTANGLE_COORDS = fArray;
        RECTANGLE_TEX_COORDS = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        RECTANGLE_BUF = GlUtil.createFloatBuffer(fArray2);
        RECTANGLE_TEX_BUF = GlUtil.createFloatBuffer(RECTANGLE_TEX_COORDS);
    }

    public FloatBuffer getVertexArray() {
        return this.mVertexArray;
    }

    public FloatBuffer getTexCoordArray() {
        return this.mTexCoordArray;
    }

    public int getVertexCount() {
        return this.mVertexCount;
    }

    public int getVertexStride() {
        return this.mVertexStride;
    }

    public int getTexCoordStride() {
        return this.mTexCoordStride;
    }

    public int getCoordsPerVertex() {
        return this.mCoordsPerVertex;
    }

    @NonNull
    public String toString() {
        return "[Drawable2d: Rectangle]";
    }
}

