/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera.gles;

import android.graphics.SurfaceTexture;
import android.view.SurfaceHolder;
import androidx.annotation.RestrictTo;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class EglCore {
    private EGL10 mEgl;
    private EGLDisplay mEGLDisplay = EGL10.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL10.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;
    private int mGlVersion = -1;

    public EglCore(EGLContext eGLContext, int n) throws RuntimeException {
        this.mEgl = (EGL10)EGLContext.getEGL();
        eGLContext = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        this.mEGLDisplay = eGLContext;
        if (eGLContext != EGL10.EGL_NO_DISPLAY) {
            int[] nArray = new int[2];
            if (this.mEgl.eglInitialize((EGLDisplay)eGLContext, nArray)) {
                eGLContext = this.getConfig(n);
                if (eGLContext != null) {
                    EGLContext eGLContext2 = eGLContext;
                    EglCore eglCore = this;
                    int[] nArray2 = new int[3];
                    int[] nArray3 = nArray2;
                    nArray2[0] = 12440;
                    nArray2[1] = 2;
                    nArray2[2] = 12344;
                    eGLContext = eglCore.mEgl.eglCreateContext(this.mEGLDisplay, (EGLConfig)eGLContext, EGL10.EGL_NO_CONTEXT, nArray3);
                    eglCore.checkEglError("eglCreateContext");
                    this.mEGLConfig = eGLContext2;
                    this.mEGLContext = eGLContext;
                    this.mGlVersion = 2;
                    nArray3 = new int[1];
                    this.mEgl.eglQueryContext(this.mEGLDisplay, eGLContext, 12440, nArray3);
                    return;
                }
                throw new RuntimeException("Unable to find a suitable EGLConfig");
            }
            this.mEGLDisplay = null;
            throw new RuntimeException("unable to initialize EGL14");
        }
        throw new RuntimeException("unable to get EGL14 display");
    }

    private EGLConfig getConfig(int n) {
        int[] nArray;
        EGLConfig[] eGLConfigArray;
        int[] nArray2 = new int[13];
        int[] nArray3 = nArray2;
        nArray2[0] = 12324;
        nArray2[1] = 8;
        nArray2[2] = 12323;
        nArray2[3] = 8;
        nArray2[4] = 12322;
        nArray2[5] = 8;
        nArray2[6] = 12321;
        nArray2[7] = 8;
        nArray2[8] = 12352;
        nArray2[9] = 4;
        nArray2[10] = 12344;
        nArray2[11] = 0;
        nArray2[12] = 12344;
        if ((n & 1) != 0) {
            nArray3[10] = 12610;
            nArray3[11] = 1;
        }
        if (!this.mEgl.eglChooseConfig(this.mEGLDisplay, nArray3, eGLConfigArray = new EGLConfig[1], 1, nArray = new int[1])) {
            return null;
        }
        return eGLConfigArray[0];
    }

    private void checkEglError(String string) {
        int n = this.mEgl.eglGetError();
        if (n == 12288) {
            return;
        }
        throw new RuntimeException(string + ": EGL error: 0x" + Integer.toHexString(n));
    }

    public void release() {
        EGLDisplay eGLDisplay = this.mEGLDisplay;
        if (eGLDisplay != EGL10.EGL_NO_DISPLAY) {
            EglCore eglCore = this;
            EGLDisplay eGLDisplay2 = eGLDisplay;
            eGLDisplay = EGL10.EGL_NO_SURFACE;
            EGLContext eGLContext = EGL10.EGL_NO_CONTEXT;
            EGLDisplay eGLDisplay3 = eGLDisplay;
            eglCore.mEgl.eglMakeCurrent(eGLDisplay2, (EGLSurface)eGLDisplay3, (EGLSurface)eGLDisplay3, eGLContext);
            EglCore eglCore2 = this;
            eGLDisplay = eglCore2.mEGLDisplay;
            eglCore.mEgl.eglDestroyContext(eGLDisplay, eglCore2.mEGLContext);
            eglCore.mEgl.eglTerminate(this.mEGLDisplay);
        }
        EglCore eglCore = this;
        eglCore.mEGLDisplay = EGL10.EGL_NO_DISPLAY;
        eglCore.mEGLContext = EGL10.EGL_NO_CONTEXT;
        eglCore.mEGLConfig = null;
    }

    protected void finalize() throws Throwable {
        block3: {
            try {
                if (this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) break block3;
            }
            catch (Throwable throwable) {
                super.finalize();
                throw throwable;
            }
            this.release();
        }
        super.finalize();
    }

    public void releaseSurface(EGLSurface eGLSurface) {
        this.mEgl.eglDestroySurface(this.mEGLDisplay, eGLSurface);
    }

    public EGLSurface createWindowSurface(Object object) {
        if (!(object instanceof SurfaceHolder) && !(object instanceof SurfaceTexture)) {
            throw new RuntimeException("invalid surface: " + object);
        }
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 12344;
        EglCore eglCore = this;
        EGLDisplay eGLDisplay = eglCore.mEGLDisplay;
        object = this.mEgl.eglCreateWindowSurface(eGLDisplay, eglCore.mEGLConfig, object, nArray2);
        this.checkEglError("eglCreateWindowSurface");
        if (object != null) {
            return object;
        }
        throw new RuntimeException("surface was null");
    }

    public void makeCurrent(EGLSurface eGLSurface) {
        EglCore eglCore = eglCore2;
        EGLDisplay eGLDisplay = eglCore.mEGLDisplay;
        EglCore eglCore2 = eglCore2.mEGLContext;
        EGLSurface eGLSurface2 = eGLSurface;
        if (eglCore.mEgl.eglMakeCurrent(eGLDisplay, eGLSurface2, eGLSurface2, (EGLContext)eglCore2)) {
            return;
        }
        throw new RuntimeException("eglMakeCurrent failed");
    }

    public void makeNothingCurrent() {
        EGLSurface eGLSurface = EGL10.EGL_NO_SURFACE;
        if (this.mEgl.eglMakeCurrent(this.mEGLDisplay, eGLSurface, eGLSurface, EGL10.EGL_NO_CONTEXT)) {
            return;
        }
        throw new RuntimeException("eglMakeCurrent failed");
    }

    public boolean swapBuffers(EGLSurface eGLSurface) {
        return this.mEgl.eglSwapBuffers(this.mEGLDisplay, eGLSurface);
    }

    public int querySurface(EGLSurface eGLSurface, int n) {
        int[] nArray = new int[1];
        this.mEgl.eglQuerySurface(this.mEGLDisplay, eGLSurface, n, nArray);
        return nArray[0];
    }
}

