/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera.gles;

import android.opengl.GLES20;
import android.opengl.Matrix;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GlUtil {
    public static final float[] IDENTITY_MATRIX = new float[16];

    public static int createProgram(String string, String string2) {
        int n = GlUtil.loadShader(35633, string);
        if (n == 0) {
            return 0;
        }
        int n2 = GlUtil.loadShader(35632, string2);
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        GlUtil.checkGlError("glCreateProgram");
        GLES20.glAttachShader((int)n3, (int)n);
        GlUtil.checkGlError("glAttachShader");
        GLES20.glAttachShader((int)n3, (int)n2);
        GlUtil.checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)n3);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            GLES20.glDeleteProgram((int)n3);
            n3 = 0;
        }
        return n3;
    }

    public static int loadShader(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        GlUtil.checkGlError("glCreateShader type=" + n);
        GLES20.glShaderSource((int)n2, (String)string);
        GLES20.glCompileShader((int)n2);
        int[] nArray = new int[1];
        GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            GLES20.glDeleteShader((int)n2);
            n2 = 0;
        }
        return n2;
    }

    public static void checkGlError(String string) {
        int n = GLES20.glGetError();
        if (n == 0) {
            return;
        }
        string = string + ": glError 0x" + Integer.toHexString(n);
        throw new RuntimeException(string);
    }

    public static void checkLocation(int n, String string) {
        if (n >= 0) {
            return;
        }
        throw new RuntimeException("Unable to locate '" + string + "' in program");
    }

    public static FloatBuffer createFloatBuffer(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
    }
}

