/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import paycardscanner.camera.widget.CardRectCoordsMapper;
import paycardscanner.ndk.RecognitionResult;
import paycardscanner.sdk.R;
import paycardscanner.utils.CardUtils;
import paycardscanner.utils.Fonts;

public class CardDetectionStateView
extends View {
    private static int mainColor;
    static final /* synthetic */ boolean $assertionsDisabled;
    private volatile int mDetectionState;
    private volatile String mRecognitionResultDate;
    private volatile String mRecognitionResultCardNumber;
    private volatile String mRecognitionResultHolder;
    private CardRectCoordsMapper mCardFrame;
    private float mDisplayDensity;
    private Typeface mCardTypeface;
    private final Rect mCardRectInvalidation;
    private float mCornerPaddingLeft;
    private float mCornerPaddingTop;
    private float mCornerLineWidth;
    private float mCornerRadius;
    private Drawable mCardGradientDrawable;
    private BitmapDrawable mCornerTopLeftDrawable;
    private BitmapDrawable mCornerTopRightDrawable;
    private BitmapDrawable mCornerBottomLeftDrawable;
    private BitmapDrawable mCornerBottomRightDrawable;
    private BitmapDrawable mLineTopDrawable;
    private BitmapDrawable mLineLeftDrawable;
    private BitmapDrawable mLineRightDrawable;
    private BitmapDrawable mLineBottomDrawable;
    private Paint mBackgroundPaint;
    private Paint mCardNumberPaint;
    private Paint mCardDatePaint;
    private Paint mCardHolderPaint;

    public CardDetectionStateView(Context context) {
        this(context, null);
    }

    public CardDetectionStateView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CardDetectionStateView(Context context, AttributeSet attributeSet, int n) {
        Rect rect;
        CardDetectionStateView cardDetectionStateView = cardDetectionStateView2;
        super(context, attributeSet, n);
        CardDetectionStateView cardDetectionStateView2 = rect;
        rect = new Rect();
        cardDetectionStateView.mCardRectInvalidation = cardDetectionStateView2;
        cardDetectionStateView.init(context);
    }

    private void init(Context context) {
        Paint paint;
        Paint paint2;
        float f;
        CardDetectionStateView cardDetectionStateView = this;
        float f2 = this.getResources().getDisplayMetrics().density;
        float f3 = f = f2;
        CardDetectionStateView cardDetectionStateView2 = this;
        CardDetectionStateView cardDetectionStateView3 = this;
        cardDetectionStateView3.mDisplayDensity = f;
        cardDetectionStateView3.mCardFrame = new CardRectCoordsMapper();
        int n = context.getResources().getColor(R.color.paycardscanner_card_shadow_color);
        cardDetectionStateView2.mCornerPaddingTop = f *= 1.0f;
        cardDetectionStateView2.mCornerPaddingLeft = f;
        this.mCornerLineWidth = f3 * 5.0f;
        this.mCornerRadius = f2 * 8.0f;
        this.mCardGradientDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.paycardscanner_frame_rect_gradient);
        this.initCornerDrawables(context);
        this.initLineDrawables(context);
        Paint paint3 = paint2 = paint;
        paint3();
        this.mBackgroundPaint = paint3;
        paint.setColor(n);
        cardDetectionStateView.mCardTypeface = Fonts.getCardFont(context);
        cardDetectionStateView.mCardNumberPaint = cardDetectionStateView.createCardTextPaint();
        cardDetectionStateView.mCardDatePaint = cardDetectionStateView.createCardTextPaint();
        cardDetectionStateView.mCardHolderPaint = cardDetectionStateView.createCardTextPaint();
        if (cardDetectionStateView.isInEditMode()) {
            CardDetectionStateView cardDetectionStateView4 = this;
            cardDetectionStateView4.mDetectionState = 15;
            cardDetectionStateView4.mRecognitionResultCardNumber = CardUtils.prettyPrintCardNumber("1234123412341234");
            cardDetectionStateView4.mRecognitionResultDate = "12/22";
            cardDetectionStateView4.mRecognitionResultHolder = "VLAS ARTANOV";
        }
    }

    private Paint createCardTextPaint() {
        Paint paint;
        Paint paint2;
        Paint paint3 = paint2 = paint;
        paint2(193);
        paint3.setTypeface(this.mCardTypeface);
        paint3.setColor(-1);
        paint3.setShadowLayer(6.0f, 3.0f, 3.0f, -16777216);
        paint.setTextSize(this.mDisplayDensity * 12.0f);
        return paint;
    }

    private void initCornerDrawables(Context context) {
        BitmapDrawable bitmapDrawable;
        BitmapDrawable bitmapDrawable2;
        BitmapDrawable bitmapDrawable3;
        BitmapDrawable bitmapDrawable4;
        Matrix matrix;
        int n = mainColor;
        Drawable drawable2 = cardDetectionStateView4.getTintedDrawable(context, R.drawable.paycardscanner_ic_top_left_rounded_corner, n);
        Matrix matrix2 = matrix;
        CardDetectionStateView cardDetectionStateView = cardDetectionStateView4;
        CardDetectionStateView cardDetectionStateView2 = cardDetectionStateView4;
        CardDetectionStateView cardDetectionStateView3 = cardDetectionStateView4;
        matrix2();
        CardDetectionStateView cardDetectionStateView4 = cardDetectionStateView4.drawableToBitmap(drawable2);
        matrix2.setRotate(0.0f);
        drawable2 = bitmapDrawable4;
        CardDetectionStateView cardDetectionStateView5 = cardDetectionStateView4;
        Resources resources = context.getResources();
        int n2 = cardDetectionStateView5.getWidth();
        int n3 = cardDetectionStateView5.getHeight();
        bitmapDrawable4 = new BitmapDrawable(resources, Bitmap.createBitmap((Bitmap)cardDetectionStateView5, (int)0, (int)0, (int)n2, (int)n3, (Matrix)matrix2, (boolean)true));
        cardDetectionStateView3.mCornerTopLeftDrawable = drawable2;
        matrix2.setRotate(90.0f);
        drawable2 = bitmapDrawable3;
        CardDetectionStateView cardDetectionStateView6 = cardDetectionStateView4;
        resources = context.getResources();
        n2 = cardDetectionStateView6.getWidth();
        n3 = cardDetectionStateView6.getHeight();
        bitmapDrawable3 = new BitmapDrawable(resources, Bitmap.createBitmap((Bitmap)cardDetectionStateView6, (int)0, (int)0, (int)n2, (int)n3, (Matrix)matrix2, (boolean)true));
        cardDetectionStateView2.mCornerTopRightDrawable = drawable2;
        matrix2.setRotate(180.0f);
        drawable2 = bitmapDrawable2;
        CardDetectionStateView cardDetectionStateView7 = cardDetectionStateView4;
        resources = context.getResources();
        n2 = cardDetectionStateView7.getWidth();
        n3 = cardDetectionStateView7.getHeight();
        bitmapDrawable2 = new BitmapDrawable(resources, Bitmap.createBitmap((Bitmap)cardDetectionStateView7, (int)0, (int)0, (int)n2, (int)n3, (Matrix)matrix2, (boolean)true));
        cardDetectionStateView.mCornerBottomRightDrawable = drawable2;
        matrix.setRotate(270.0f);
        drawable2 = bitmapDrawable;
        CardDetectionStateView cardDetectionStateView8 = cardDetectionStateView4;
        cardDetectionStateView4 = context.getResources();
        int n4 = cardDetectionStateView8.getWidth();
        int n5 = cardDetectionStateView8.getHeight();
        bitmapDrawable = new BitmapDrawable((Resources)cardDetectionStateView4, Bitmap.createBitmap((Bitmap)cardDetectionStateView8, (int)0, (int)0, (int)n4, (int)n5, (Matrix)matrix2, (boolean)true));
        v12.mCornerBottomLeftDrawable = drawable2;
    }

    private void initLineDrawables(Context context) {
        Matrix matrix;
        GradientDrawable gradientDrawable;
        CardDetectionStateView cardDetectionStateView = cardDetectionStateView5;
        GradientDrawable gradientDrawable2 = gradientDrawable;
        new GradientDrawable().setShape(0);
        gradientDrawable2.setColor(mainColor);
        gradientDrawable2.setSize(2, 2);
        Matrix matrix2 = matrix;
        CardDetectionStateView cardDetectionStateView2 = cardDetectionStateView5;
        CardDetectionStateView cardDetectionStateView3 = cardDetectionStateView5;
        CardDetectionStateView cardDetectionStateView4 = cardDetectionStateView5;
        matrix2();
        CardDetectionStateView cardDetectionStateView5 = cardDetectionStateView5.drawableToBitmap((Drawable)gradientDrawable2);
        matrix2.setRotate(0.0f);
        CardDetectionStateView cardDetectionStateView6 = cardDetectionStateView5;
        gradientDrawable2 = context.getResources();
        int n = cardDetectionStateView6.getWidth();
        int n2 = cardDetectionStateView6.getHeight();
        cardDetectionStateView4.mLineTopDrawable = new BitmapDrawable((Resources)gradientDrawable2, Bitmap.createBitmap((Bitmap)cardDetectionStateView6, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true));
        matrix2.setRotate(90.0f);
        CardDetectionStateView cardDetectionStateView7 = cardDetectionStateView5;
        gradientDrawable2 = context.getResources();
        n = cardDetectionStateView7.getWidth();
        n2 = cardDetectionStateView7.getHeight();
        cardDetectionStateView3.mLineRightDrawable = new BitmapDrawable((Resources)gradientDrawable2, Bitmap.createBitmap((Bitmap)cardDetectionStateView7, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true));
        matrix2.setRotate(180.0f);
        CardDetectionStateView cardDetectionStateView8 = cardDetectionStateView5;
        gradientDrawable2 = context.getResources();
        n = cardDetectionStateView8.getWidth();
        n2 = cardDetectionStateView8.getHeight();
        cardDetectionStateView2.mLineBottomDrawable = new BitmapDrawable((Resources)gradientDrawable2, Bitmap.createBitmap((Bitmap)cardDetectionStateView8, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true));
        matrix.setRotate(270.0f);
        CardDetectionStateView cardDetectionStateView9 = cardDetectionStateView5;
        cardDetectionStateView5 = context.getResources();
        int n3 = cardDetectionStateView9.getWidth();
        int n4 = cardDetectionStateView9.getHeight();
        cardDetectionStateView.mLineLeftDrawable = new BitmapDrawable((Resources)cardDetectionStateView5, Bitmap.createBitmap((Bitmap)cardDetectionStateView9, (int)0, (int)0, (int)n3, (int)n4, (Matrix)matrix2, (boolean)true));
    }

    private void drawBackground(Canvas canvas) {
        Canvas canvas2 = canvas;
        Canvas canvas3 = canvas;
        Canvas canvas4 = canvas;
        CardDetectionStateView cardDetectionStateView = this;
        Canvas canvas5 = canvas;
        CardDetectionStateView cardDetectionStateView2 = this;
        canvas = cardDetectionStateView2.mCardFrame.getCardRect();
        float f = this.getWidth();
        float f2 = canvas.top;
        Paint paint = cardDetectionStateView2.mBackgroundPaint;
        canvas5.drawRect(0.0f, 0.0f, f, f2, paint);
        f = canvas.bottom;
        f2 = cardDetectionStateView.getWidth();
        float f3 = cardDetectionStateView.getHeight();
        Paint paint2 = cardDetectionStateView.mBackgroundPaint;
        canvas4.drawRect(0.0f, f, f2, f3, paint2);
        Canvas canvas6 = canvas;
        f = canvas6.top;
        f2 = canvas6.left;
        f3 = canvas6.bottom;
        paint2 = this.mBackgroundPaint;
        canvas3.drawRect(0.0f, f, f2, f3, paint2);
        Canvas canvas7 = canvas;
        float f4 = canvas7.right;
        float f5 = canvas7.top;
        f = this.getWidth();
        f2 = canvas.bottom;
        Paint paint3 = this.mBackgroundPaint;
        canvas2.drawRect(f4, f5, f, f2, paint3);
    }

    private void drawCorners(Canvas canvas) {
        int n = this.mDetectionState;
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mCardGradientDrawable.draw(canvas);
        cardDetectionStateView.mCornerTopLeftDrawable.draw(canvas);
        cardDetectionStateView.mCornerTopRightDrawable.draw(canvas);
        cardDetectionStateView.mCornerBottomLeftDrawable.draw(canvas);
        cardDetectionStateView.mCornerBottomRightDrawable.draw(canvas);
        if ((n & 1) != 0) {
            this.mLineTopDrawable.draw(canvas);
        }
        if ((n & 4) != 0) {
            this.mLineLeftDrawable.draw(canvas);
        }
        if ((n & 8) != 0) {
            this.mLineRightDrawable.draw(canvas);
        }
        if ((n & 2) != 0) {
            this.mLineBottomDrawable.draw(canvas);
        }
    }

    private void drawRecognitionResult(Canvas canvas) {
        CardDetectionStateView cardDetectionStateView = this;
        String string = cardDetectionStateView.mRecognitionResultDate;
        String string2 = cardDetectionStateView.mRecognitionResultCardNumber;
        String string3 = cardDetectionStateView.mRecognitionResultHolder;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            CardDetectionStateView cardDetectionStateView2 = this;
            float f = cardDetectionStateView2.mCardFrame.getCardNumberPos().x;
            float f2 = cardDetectionStateView2.mCardFrame.getCardNumberPos().y;
            Paint paint = cardDetectionStateView2.mCardNumberPaint;
            canvas.drawText(string2, f, f2, paint);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            CardDetectionStateView cardDetectionStateView3 = this;
            float f = cardDetectionStateView3.mCardFrame.getCardDatePos().x;
            float f3 = cardDetectionStateView3.mCardFrame.getCardDatePos().y;
            Paint paint = cardDetectionStateView3.mCardDatePaint;
            canvas.drawText(string, f, f3, paint);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            CardDetectionStateView cardDetectionStateView4 = this;
            float f = cardDetectionStateView4.mCardFrame.getCardHolderPos().x;
            float f4 = cardDetectionStateView4.mCardFrame.getCardHolderPos().y;
            string = cardDetectionStateView4.mCardHolderPaint;
            canvas.drawText(string3, f, f4, (Paint)string);
        }
    }

    private void refreshCardRectCoords() {
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.refreshCardRectInvalidation();
        cardDetectionStateView.refreshDrawableBounds();
        cardDetectionStateView.refreshTextSize();
    }

    private void refreshCardRectInvalidation() {
        CardDetectionStateView cardDetectionStateView = this;
        Rect rect = cardDetectionStateView.mCardFrame.getCardRect();
        int n = (int)(cardDetectionStateView.mCornerPaddingLeft + 0.5f) + (int)(this.mCornerLineWidth / 2.0f + 0.5f);
        Rect rect2 = cardDetectionStateView.mCardRectInvalidation;
        rect2.left = rect.left - n;
        rect2.top = rect.top - n;
        rect2.right = rect.right + n;
        cardDetectionStateView.mCardRectInvalidation.bottom = rect.bottom + n;
    }

    private void refreshDrawableBounds() {
        CardDetectionStateView cardDetectionStateView = this;
        Rect rect = cardDetectionStateView.mCardFrame.getCardRect();
        CardDetectionStateView cardDetectionStateView2 = this;
        cardDetectionStateView2.mCardGradientDrawable.setBounds(rect);
        int n = cardDetectionStateView2.mCornerTopLeftDrawable.getIntrinsicWidth();
        int n2 = cardDetectionStateView2.mCornerTopLeftDrawable.getIntrinsicHeight();
        int n3 = (int)(cardDetectionStateView2.mCornerLineWidth / 2.0f + 0.5f);
        float f = n3;
        int n4 = Math.round((float)rect.left - this.mCornerPaddingLeft - f);
        int n5 = Math.round((float)(rect.right - n) + this.mCornerPaddingLeft + f);
        int n6 = Math.round((float)rect.top - this.mCornerPaddingTop - f);
        int n7 = Math.round((float)(rect.bottom - n2) + this.mCornerPaddingTop + f);
        int n8 = n6;
        int n9 = n4 + n;
        cardDetectionStateView.mCornerTopLeftDrawable.setBounds(n4, n8, n9, n8 + n2);
        int n10 = n6;
        int n11 = n;
        n = n5 + n;
        cardDetectionStateView.mCornerTopRightDrawable.setBounds(n5, n10, n, n10 + n11);
        int n12 = n7;
        n2 = n12 + n2;
        cardDetectionStateView.mCornerBottomLeftDrawable.setBounds(n4, n12, n9, n2);
        cardDetectionStateView.mCornerBottomRightDrawable.setBounds(n5, n7, n, n2);
        n7 = (int)cardDetectionStateView.mCornerRadius;
        n9 = cardDetectionStateView.dpToPx(cardDetectionStateView.getContext(), 4.0f);
        n5 = n4 + n7;
        int n13 = n - n7;
        int n14 = n6 + n9;
        cardDetectionStateView.mLineTopDrawable.setBounds(n5, n6, n13, n14);
        int n15 = n7;
        n7 = n6 + n7;
        n6 = n2 - n15;
        cardDetectionStateView.mLineLeftDrawable.setBounds(n4, n7, n4 += n9, n6);
        cardDetectionStateView.mLineRightDrawable.setBounds(n - n9, n7, n, n6);
        cardDetectionStateView.mLineBottomDrawable.setBounds(n5, n2 - n9, n13, n2);
    }

    private void refreshTextSize() {
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mCardNumberPaint.setTextSize(this.mCardFrame.getCardNumberFontSize());
        cardDetectionStateView.mCardDatePaint.setTextSize(this.mCardFrame.getCardDateFontSize());
        cardDetectionStateView.mCardHolderPaint.setTextSize(this.mCardFrame.getCardHolderFontSize());
    }

    private int dpToPx(@NonNull Context context, float f) {
        return (int)(f * context.getResources().getDisplayMetrics().density);
    }

    static {
        $assertionsDisabled = CardDetectionStateView.class.desiredAssertionStatus() ^ true;
    }

    public void setMainColor(Context context, int n) {
        CardDetectionStateView cardDetectionStateView = this;
        mainColor = n;
        cardDetectionStateView.initCornerDrawables(context);
        cardDetectionStateView.initLineDrawables(context);
    }

    public Bitmap drawableToBitmap(Drawable drawable2) {
        Canvas canvas;
        CardDetectionStateView cardDetectionStateView;
        if (drawable2 instanceof BitmapDrawable && (cardDetectionStateView = (BitmapDrawable)drawable2).getBitmap() != null) {
            return cardDetectionStateView.getBitmap();
        }
        if (drawable2.getIntrinsicWidth() > 0 && drawable2.getIntrinsicHeight() > 0) {
            cardDetectionStateView = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else {
            cardDetectionStateView = Bitmap.Config.ARGB_8888;
            cardDetectionStateView = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)cardDetectionStateView);
        }
        Drawable drawable3 = drawable2;
        drawable2 = canvas;
        int n = new Canvas((Bitmap)cardDetectionStateView).getWidth();
        int n2 = drawable2.getHeight();
        drawable3.setBounds(0, 0, n, n2);
        drawable3.draw((Canvas)drawable2);
        return cardDetectionStateView;
    }

    public Drawable getTintedDrawable(@NonNull Context context, @DrawableRes int n, int n2) {
        Drawable drawable2 = DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)context, (int)n));
        DrawableCompat.setTint((Drawable)drawable2.mutate(), (int)n2);
        return drawable2;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        CardDetectionStateView cardDetectionStateView = this;
        super.onSizeChanged(n, n2, n3, n4);
        if (cardDetectionStateView.mCardFrame.setViewSize(n, n2)) {
            this.refreshCardRectCoords();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mCardGradientDrawable.getBounds().width() == 0) {
            return;
        }
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.drawBackground(canvas);
        cardDetectionStateView.drawCorners(canvas);
        cardDetectionStateView.drawRecognitionResult(canvas);
    }

    public synchronized void setDetectionState(int n) {
        if (this.mDetectionState != n) {
            CardDetectionStateView cardDetectionStateView = this;
            cardDetectionStateView.mDetectionState = n;
            Rect rect = cardDetectionStateView.mCardRectInvalidation;
            int n2 = rect.left;
            n = rect.top;
            int n3 = rect.right;
            int n4 = rect.bottom;
            cardDetectionStateView.postInvalidate(n2, n, n3, n4);
        }
    }

    public synchronized void setRecognitionResult(RecognitionResult recognitionResult) {
        this.mRecognitionResultCardNumber = !TextUtils.isEmpty((CharSequence)recognitionResult.getNumber()) ? CardUtils.prettyPrintCardNumber(recognitionResult.getNumber()) : null;
        if (!TextUtils.isEmpty((CharSequence)recognitionResult.getDate())) {
            if (!$assertionsDisabled && recognitionResult.getDate() == null) {
                throw new AssertionError();
            }
            this.mRecognitionResultDate = recognitionResult.getDate().substring(0, 2) + '/' + recognitionResult.getDate().substring(2);
        } else {
            this.mRecognitionResultDate = null;
        }
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mRecognitionResultHolder = recognitionResult.getName();
        Rect rect = cardDetectionStateView.mCardRectInvalidation;
        int n = rect.left;
        int n2 = rect.top;
        int n3 = rect.right;
        int n4 = rect.bottom;
        cardDetectionStateView.postInvalidate(n, n2, n3, n4);
    }

    void setCameraParameters(int n, int n2, int n3, Rect rect) {
        if (this.mCardFrame.setCameraParameters(n, n2, n3, rect)) {
            CardDetectionStateView cardDetectionStateView = this;
            cardDetectionStateView.refreshCardRectCoords();
            cardDetectionStateView.invalidate();
        }
    }
}

