/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.camera.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paycardscanner.camera.widget.CardOverlayView;
import paycardscanner.camera.widget.ScanCardOverlayView;
import paycardscanner.sdk.R;
import paycardscanner.utils.ContextKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0014J\u0012\u00102\u001a\u00020/2\b\b\u0001\u00103\u001a\u00020\u0007H\u0016J\f\u00104\u001a\u00020/*\u000201H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\rR\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000f\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010'\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u000f\u001a\u0004\b(\u0010\rR\u001b\u0010*\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u000f\u001a\u0004\b+\u0010\rR\u000e\u0010-\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lpaycardscanner/camera/widget/ScanCardOverlayView;", "Lpaycardscanner/camera/widget/CardOverlayView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backgroundPath", "Landroid/graphics/Path;", "bottomLeftCornerPath", "getBottomLeftCornerPath", "()Landroid/graphics/Path;", "bottomLeftCornerPath$delegate", "Lkotlin/Lazy;", "bottomRightCornerPath", "getBottomRightCornerPath", "bottomRightCornerPath$delegate", "centerRect", "Landroid/graphics/RectF;", "getCenterRect", "()Landroid/graphics/RectF;", "centerRect$delegate", "centerY", "", "getCenterY", "()F", "centerY$delegate", "cornerPadding", "cornerSize", "cornerStrokeWidth", "cornersColor", "cornersPaint", "Landroid/graphics/Paint;", "cutRectCornerRadius", "pathCornerRadius", "rectCorners", "", "topLeftCornerPath", "getTopLeftCornerPath", "topLeftCornerPath$delegate", "topRightCornerPath", "getTopRightCornerPath", "topRightCornerPath$delegate", "transparentColor", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "setCornersColor", "color", "drawBackground", "sdk_release"})
public final class ScanCardOverlayView
extends CardOverlayView {
    private final float cornerSize;
    private final float pathCornerRadius;
    private final float cutRectCornerRadius;
    private final float cornerStrokeWidth;
    private final float cornerPadding;
    private final int transparentColor;
    private final int cornersColor;
    @NotNull
    private final float[] rectCorners;
    @NotNull
    private final Path backgroundPath;
    @NotNull
    private final Paint cornersPaint;
    @NotNull
    private final Lazy centerY$delegate;
    @NotNull
    private final Lazy centerRect$delegate;
    @NotNull
    private final Lazy topLeftCornerPath$delegate;
    @NotNull
    private final Lazy topRightCornerPath$delegate;
    @NotNull
    private final Lazy bottomLeftCornerPath$delegate;
    @NotNull
    private final Lazy bottomRightCornerPath$delegate;

    @JvmOverloads
    public ScanCardOverlayView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        Paint paint;
        Paint paint2;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        this.cornerSize = ContextKt.dpToPx(context, 40.0f);
        this.pathCornerRadius = ContextKt.dpToPx(context, 12.0f);
        this.cutRectCornerRadius = ContextKt.dpToPx(context, 10.0f);
        this.cornerStrokeWidth = ContextKt.dpToPx(context, 4.0f);
        this.cornerPadding = this.cornerStrokeWidth / 3.0f;
        this.transparentColor = ContextCompat.getColor((Context)context, (int)R.color.paycardscanner_card_shadow_color);
        this.cornersColor = ContextCompat.getColor((Context)context, (int)17170443);
        float[] fArray = new float[8];
        for (int i = 0; i < 8; ++i) {
            fArray[i] = this.cutRectCornerRadius;
        }
        ScanCardOverlayView scanCardOverlayView = this;
        scanCardOverlayView.rectCorners = fArray;
        scanCardOverlayView.backgroundPath = new Path();
        Paint paint3 = paint2 = paint;
        Paint paint4 = paint2;
        paint4();
        paint4.setStyle(Paint.Style.STROKE);
        paint3.setStrokeWidth(this.cornerStrokeWidth);
        paint3.setAntiAlias(true);
        paint3.setPathEffect((PathEffect)new CornerPathEffect(this.pathCornerRadius));
        paint3.setStrokeJoin(Paint.Join.ROUND);
        paint3.setStrokeCap(Paint.Cap.ROUND);
        paint.setColor(this.cornersColor);
        scanCardOverlayView.cornersPaint = paint;
        scanCardOverlayView.centerY$delegate = LazyKt.lazy((Function0)new Function0<Float>(this){
            final /* synthetic */ ScanCardOverlayView this$0;
            {
                this.this$0 = scanCardOverlayView;
                super(0);
            }

            @NotNull
            public final Float invoke() {
                return Float.valueOf((float)(this.this$0.getBottom() - this.this$0.getTop()) / 2.0f);
            }
        });
        scanCardOverlayView.centerRect$delegate = LazyKt.lazy((Function0)new Function0<RectF>(this, context){
            final /* synthetic */ ScanCardOverlayView this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = scanCardOverlayView;
                this.$context = context;
                super(0);
            }

            @NotNull
            public final RectF invoke() {
                centerRect.2 v0 = this;
                float f = (float)v0.this$0.getLeft() + ContextKt.dpToPx(this.$context, 24);
                float f2 = (float)this.this$0.getRight() - ContextKt.dpToPx(this.$context, 24);
                float f3 = (f + f2) / 3.5f;
                float f4 = ScanCardOverlayView.access$getCenterY(v0.this$0) - f3;
                f3 = ScanCardOverlayView.access$getCenterY(v0.this$0) + f3;
                return new RectF(f, f4, f2, f3);
            }
        });
        scanCardOverlayView.topLeftCornerPath$delegate = LazyKt.lazy((Function0)new Function0<Path>(this){
            final /* synthetic */ ScanCardOverlayView this$0;
            {
                this.this$0 = scanCardOverlayView;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                Path path = new Path();
                Object object = object.this$0;
                path.moveTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).left - ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).top + ScanCardOverlayView.access$getCornerSize$p((ScanCardOverlayView)((Object)object)));
                path.lineTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).left - ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).top - ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)));
                path.lineTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).left + ScanCardOverlayView.access$getCornerSize$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).top - ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)));
                return path;
            }
        });
        scanCardOverlayView.topRightCornerPath$delegate = LazyKt.lazy((Function0)new Function0<Path>(this){
            final /* synthetic */ ScanCardOverlayView this$0;
            {
                this.this$0 = scanCardOverlayView;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                Path path = new Path();
                Object object = object.this$0;
                path.moveTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).right - ScanCardOverlayView.access$getCornerSize$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).top - ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)));
                path.lineTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).right + ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).top - ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)));
                path.lineTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).right + ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).top + ScanCardOverlayView.access$getCornerSize$p((ScanCardOverlayView)((Object)object)));
                return path;
            }
        });
        scanCardOverlayView.bottomLeftCornerPath$delegate = LazyKt.lazy((Function0)new Function0<Path>(this){
            final /* synthetic */ ScanCardOverlayView this$0;
            {
                this.this$0 = scanCardOverlayView;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                Path path = new Path();
                Object object = object.this$0;
                path.moveTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).left - ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).bottom - ScanCardOverlayView.access$getCornerSize$p((ScanCardOverlayView)((Object)object)));
                path.lineTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).left - ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).bottom + ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)));
                path.lineTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).left + ScanCardOverlayView.access$getCornerSize$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).bottom + ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)));
                return path;
            }
        });
        scanCardOverlayView.bottomRightCornerPath$delegate = LazyKt.lazy((Function0)new Function0<Path>(this){
            final /* synthetic */ ScanCardOverlayView this$0;
            {
                this.this$0 = scanCardOverlayView;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                Path path = new Path();
                Object object = object.this$0;
                path.moveTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).right - ScanCardOverlayView.access$getCornerSize$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).bottom + ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)));
                path.lineTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).right + ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).bottom + ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)));
                path.lineTo(ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).right + ScanCardOverlayView.access$getCornerPadding$p((ScanCardOverlayView)((Object)object)), ScanCardOverlayView.access$getCenterRect((ScanCardOverlayView)((Object)object)).bottom - ScanCardOverlayView.access$getCornerSize$p((ScanCardOverlayView)((Object)object)));
                return path;
            }
        });
    }

    public /* synthetic */ ScanCardOverlayView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final float getCenterY() {
        return ((Number)this.centerY$delegate.getValue()).floatValue();
    }

    private final RectF getCenterRect() {
        return (RectF)this.centerRect$delegate.getValue();
    }

    private final Path getTopLeftCornerPath() {
        return (Path)this.topLeftCornerPath$delegate.getValue();
    }

    private final Path getTopRightCornerPath() {
        return (Path)this.topRightCornerPath$delegate.getValue();
    }

    private final Path getBottomLeftCornerPath() {
        return (Path)this.bottomLeftCornerPath$delegate.getValue();
    }

    private final Path getBottomRightCornerPath() {
        return (Path)this.bottomRightCornerPath$delegate.getValue();
    }

    private final void drawBackground(Canvas object) {
        Canvas canvas = object;
        ScanCardOverlayView scanCardOverlayView = scanCardOverlayView4;
        Canvas canvas2 = object;
        ScanCardOverlayView scanCardOverlayView2 = scanCardOverlayView4;
        Path path = scanCardOverlayView2.backgroundPath;
        object = path;
        ScanCardOverlayView scanCardOverlayView3 = scanCardOverlayView4;
        object.reset();
        ScanCardOverlayView scanCardOverlayView4 = scanCardOverlayView3.getCenterRect();
        object = scanCardOverlayView3.rectCorners;
        path.addRoundRect((RectF)scanCardOverlayView4, (float[])object, Path.Direction.CW);
        path.setFillType(Path.FillType.INVERSE_EVEN_ODD);
        canvas2.clipPath(scanCardOverlayView2.backgroundPath);
        canvas.drawColor(scanCardOverlayView.transparentColor);
    }

    @JvmOverloads
    public ScanCardOverlayView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public ScanCardOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ float access$getCenterY(ScanCardOverlayView scanCardOverlayView) {
        return scanCardOverlayView.getCenterY();
    }

    public static final /* synthetic */ RectF access$getCenterRect(ScanCardOverlayView scanCardOverlayView) {
        return scanCardOverlayView.getCenterRect();
    }

    public static final /* synthetic */ float access$getCornerPadding$p(ScanCardOverlayView scanCardOverlayView) {
        return scanCardOverlayView.cornerPadding;
    }

    public static final /* synthetic */ float access$getCornerSize$p(ScanCardOverlayView scanCardOverlayView) {
        return scanCardOverlayView.cornerSize;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        ScanCardOverlayView scanCardOverlayView = scanCardOverlayView5;
        ScanCardOverlayView scanCardOverlayView2 = scanCardOverlayView5;
        ScanCardOverlayView scanCardOverlayView3 = scanCardOverlayView5;
        ScanCardOverlayView scanCardOverlayView4 = scanCardOverlayView5;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        scanCardOverlayView4.drawBackground(canvas);
        ScanCardOverlayView scanCardOverlayView5 = scanCardOverlayView4.getTopLeftCornerPath();
        canvas.drawPath((Path)scanCardOverlayView5, scanCardOverlayView4.cornersPaint);
        scanCardOverlayView5 = scanCardOverlayView3.getTopRightCornerPath();
        canvas.drawPath((Path)scanCardOverlayView5, scanCardOverlayView3.cornersPaint);
        scanCardOverlayView5 = scanCardOverlayView2.getBottomLeftCornerPath();
        canvas.drawPath((Path)scanCardOverlayView5, scanCardOverlayView2.cornersPaint);
        scanCardOverlayView5 = scanCardOverlayView.getBottomRightCornerPath();
        canvas.drawPath((Path)scanCardOverlayView5, scanCardOverlayView.cornersPaint);
    }

    @Override
    public void setCornersColor(@ColorInt int n) {
        ScanCardOverlayView scanCardOverlayView = this;
        scanCardOverlayView.cornersPaint.setColor(n);
        scanCardOverlayView.invalidate();
    }
}

