/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.intent;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import paycardscanner.utils.CardUtils;

public class Card
implements Serializable,
Parcelable {
    private static final long serialVersionUID = 1L;
    public static final Parcelable.Creator<Card> CREATOR = new Parcelable.Creator<Card>(){

        public Card createFromParcel(Parcel parcel) {
            return new Card(parcel);
        }

        public Card[] newArray(int n) {
            return new Card[n];
        }
    };
    private final String mCardNumber;
    @Nullable
    private final String mCardHolder;
    @Nullable
    private final String mExpirationDate;

    public Card(String string, @Nullable String string2, @Nullable String string3) {
        this.mCardNumber = string;
        this.mCardHolder = string2;
        this.mExpirationDate = string3;
    }

    protected Card(Parcel parcel) {
        this.mCardNumber = parcel.readString();
        this.mCardHolder = parcel.readString();
        this.mExpirationDate = parcel.readString();
    }

    public String getCardNumber() {
        return this.mCardNumber;
    }

    public String getCardNumberRedacted() {
        return CardUtils.getCardNumberRedacted(this.mCardNumber);
    }

    @Nullable
    public String getCardHolderName() {
        return this.mCardHolder;
    }

    @Nullable
    public String getExpirationDate() {
        return this.mExpirationDate;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (Card)object;
            if (!Objects.equals(this.mCardNumber, ((Card)object).mCardNumber)) {
                return false;
            }
            if (!Objects.equals(this.mCardHolder, ((Card)object).mCardHolder)) {
                return false;
            }
            return Objects.equals(this.mExpirationDate, ((Card)object).mExpirationDate);
        }
        return false;
    }

    public int hashCode() {
        String string = this.mCardNumber;
        int n = (string != null ? string.hashCode() : 0) * 31;
        String string2 = this.mCardHolder;
        int n2 = string2 != null ? string2.hashCode() : 0;
        int n3 = (n + n2) * 31;
        String string3 = this.mExpirationDate;
        int n4 = string3 != null ? string3.hashCode() : 0;
        return n3 + n4;
    }

    @NonNull
    public String toString() {
        return "Card{CardNumber='" + this.getCardNumberRedacted() + '\'' + ", CardHolder='" + this.mCardHolder + '\'' + ", ExpirationDate='" + this.mExpirationDate + '\'' + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mCardNumber);
        parcel.writeString(this.mCardHolder);
        parcel.writeString(this.mExpirationDate);
    }
}

