/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.intent;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.jetbrains.annotations.Contract;
import paycardscanner.intent.Card;

public final class ScanCardCallback {

    public static interface ErrorListener {
        public void onError();
    }

    public static interface CanceledListener {
        public void onCanceled();
    }

    public static interface SuccessListener {
        public void onResult(@NonNull Card var1, @Nullable Bitmap var2);
    }

    public static final class Builder {
        static final /* synthetic */ boolean $assertionsDisabled;
        private SuccessListener onSuccess;
        private CanceledListener onBackPressed;
        private CanceledListener onManualInput;
        private ErrorListener onError;

        static {
            $assertionsDisabled = ScanCardCallback.class.desiredAssertionStatus() ^ true;
        }

        public Builder setOnSuccess(SuccessListener successListener) {
            this.onSuccess = successListener;
            return this;
        }

        public Builder setOnBackPressed(CanceledListener canceledListener) {
            this.onBackPressed = canceledListener;
            return this;
        }

        public Builder setOnManualInput(CanceledListener canceledListener) {
            this.onManualInput = canceledListener;
            return this;
        }

        public Builder setOnError(ErrorListener errorListener) {
            this.onError = errorListener;
            return this;
        }

        @NonNull
        @Contract(pure=true)
        public ActivityResultCallback<ActivityResult> build() {
            return object -> {
                Object object2;
                Object object3 = ScanCardCallback.class.getSimpleName();
                if (object.getResultCode() == -1 && ((Builder)object2).onSuccess != null) {
                    if (!$assertionsDisabled && object.getData() == null) {
                        throw new AssertionError();
                    }
                    ActivityResult activityResult = object;
                    object = (Card)object.getData().getParcelableExtra("RESULT_CARD_DATA");
                    Log.i((String)object3, (String)("Card info: " + ((Card)object).toString()));
                    byte[] byArray = activityResult.getData().getByteArrayExtra("RESULT_CARD_IMAGE");
                    object3 = byArray;
                    if (byArray != null) {
                        Object object4 = object2;
                        Object object5 = object3;
                        object2 = BitmapFactory.decodeByteArray((byte[])object5, (int)0, (int)((Object)object5).length);
                        ((Builder)object4).onSuccess.onResult((Card)object, (Bitmap)object2);
                    } else {
                        ((Builder)object2).onSuccess.onResult((Card)object, null);
                    }
                } else if (object.getResultCode() == 0) {
                    int n = object.getData() != null ? object.getData().getIntExtra("RESULT_CANCEL_REASON", 1) : 1;
                    if (n != 1) {
                        if (n == 2) {
                            Log.i((String)object3, (String)"manual input button pressed");
                            object2 = ((Builder)object2).onManualInput;
                            if (object2 != null) {
                                object2.onCanceled();
                            }
                        }
                    } else {
                        Log.i((String)object3, (String)"back pressed");
                        object2 = ((Builder)object2).onBackPressed;
                        if (object2 != null) {
                            object2.onCanceled();
                        }
                    }
                } else if (object.getResultCode() == 1) {
                    Log.i((String)object3, (String)"scan failed");
                    object2 = ((Builder)object2).onError;
                    if (object2 != null) {
                        object2.onError();
                    }
                }
            };
        }
    }
}

