/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.intent;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.ColorRes;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import paycardscanner.sdk.R;
import paycardscanner.ui.ScanCardActivity;
import paycardscanner.ui.ScanCardRequest;

public final class ScanCardIntent {
    public static final int RESULT_CODE_ERROR = 1;
    public static final String RESULT_CARD_DATA = "RESULT_CARD_DATA";
    public static final String RESULT_CARD_IMAGE = "RESULT_CARD_IMAGE";
    public static final String RESULT_CANCEL_REASON = "RESULT_CANCEL_REASON";
    public static final int BACK_PRESSED = 1;
    public static final int ADD_MANUALLY_PRESSED = 2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String KEY_SCAN_CARD_REQUEST = "payCardScanner.ui.ScanCardActivity.SCAN_CARD_REQUEST";

    private ScanCardIntent() {
    }

    public static final class Builder {
        private final Context mContext;
        private boolean mEnableVibration = true;
        private boolean mScanExpirationDate = true;
        private boolean mScanCardHolder = true;
        private boolean mGrabCardImage = false;
        private String mHint;
        private String mTitle;
        private String mManualInputButton;
        private int mMainColor;
        private String mBottomHint;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setScanExpirationDate(boolean bl) {
            this.mScanExpirationDate = bl;
            return this;
        }

        public Builder setScanCardHolder(boolean bl) {
            this.mScanCardHolder = bl;
            return this;
        }

        public Builder setVibrationEnabled(boolean bl) {
            this.mEnableVibration = bl;
            return this;
        }

        public Builder setSaveCard(boolean bl) {
            this.mGrabCardImage = bl;
            return this;
        }

        public Builder setHint(String string) {
            this.mHint = string;
            return this;
        }

        public Builder setToolbarTitle(String string) {
            this.mTitle = string;
            return this;
        }

        public Builder setManualInputButtonText(String string) {
            this.mManualInputButton = string;
            return this;
        }

        public Builder setMainColor(@ColorRes int n) {
            this.mMainColor = n;
            return this;
        }

        public Builder setBottomHint(String string) {
            this.mBottomHint = string;
            return this;
        }

        public Intent build() {
            Intent intent;
            Builder builder = this;
            Object object = intent;
            intent = new Intent(this.mContext, ScanCardActivity.class);
            boolean bl = builder.mEnableVibration;
            boolean bl2 = builder.mScanExpirationDate;
            boolean bl3 = builder.mScanCardHolder;
            boolean bl4 = builder.mGrabCardImage;
            String string = builder.mHint;
            String string2 = builder.mTitle;
            String string3 = builder.mManualInputButton;
            Context context = builder.mContext;
            int n = builder.mMainColor;
            if (n == 0) {
                n = R.color.paycardscanner_primary_color;
            }
            Intent intent2 = object;
            int n2 = ContextCompat.getColor((Context)context, (int)n);
            object = this.mBottomHint;
            ScanCardRequest scanCardRequest = new ScanCardRequest(bl, bl2, bl3, bl4, string, string2, string3, n2, (String)object);
            intent2.putExtra(ScanCardIntent.KEY_SCAN_CARD_REQUEST, (Parcelable)scanCardRequest);
            return intent2;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CancelReason {
    }
}

